/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.actions;

import com.ericsson.ere.gui.editors.interfaces.ProxySettingsEditorInterface;
import com.ericsson.ere.gui.editors.propertyeditor.DefaultEreProxySettingsEditor;
import com.ericsson.ere.gui.editors.propertyeditor.DefaultNavigatorNodeEditor;
import com.ericsson.ere.gui.editors.propertyeditor.InternalEREProxySettingsEditor;
import com.ericsson.ere.gui.navigator.NavigatorConfigLoader;
import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.NavigatorTreeUtil;
import com.ericsson.ere.gui.navigator.nodes.NavigatorNodeInterface;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.InternalEreProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.SynchronizedEDTProgressVisualizer;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.BindException;
import javax.swing.AbstractAction;
import javax.swing.tree.DefaultMutableTreeNode;

public class PropertiesAction
extends AbstractAction {
    NavigatorTree myTreeOwner = null;

    public PropertiesAction(NavigatorTree owner) {
        super("Properties");
        this.myTreeOwner = owner;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        DefaultMutableTreeNode node = this.myTreeOwner.getSelectedNode();
        if (!(node instanceof NavigatorNodeInterface)) {
            return;
        }
        AbstractEreProxy aProxy = ((NavigatorNodeInterface)((Object)node)).getProxy();
        Class editorClass = DefaultNavigatorNodeEditor.class;
        if (aProxy instanceof RatingPeriodProxy && !NavigatorTreeUtil.nodeIsInEditState(aProxy)) {
            editorClass = aProxy.getEditProxyEditorForClass(RatingPeriodProxy.class);
        } else if (aProxy instanceof ServiceProxy) {
            editorClass = aProxy.getEditProxyEditorForClass(ServiceProxy.class);
        } else if (aProxy instanceof InternalEreProxy) {
            editorClass = InternalEREProxySettingsEditor.class;
        } else if (aProxy instanceof EreProxy) {
            editorClass = DefaultEreProxySettingsEditor.class;
        }
        try {
            this.performEdit(aProxy, editorClass);
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "navigator");
        }
    }

    private void performEdit(AbstractEreProxy aProxy, Class<?> editorClass) throws InstantiationException, IllegalAccessException {
        ProxySettingsEditorInterface editor = (ProxySettingsEditorInterface)editorClass.newInstance();
        editor.performEdit(aProxy);
        if (editor instanceof InternalEREProxySettingsEditor && ((InternalEREProxySettingsEditor)editor).needRestart()) {
            ProgressDialog progressDialog = new ProgressDialog("Restarting Internal ERE", "Changes forced a restart of the internal ERE.", false);
            Thread restarter = new Thread(new ProxyRestarter((InternalEreProxy)aProxy, progressDialog));
            restarter.start();
            progressDialog.setVisible(true);
        }
        this.saveNodeConfiguration();
    }

    private void saveNodeConfiguration() {
        NavigatorConfigLoader.getInstance().saveNodeConfiguration(GuiServiceCenter.getInstance().getNavigatorRootNode());
    }

    static String getAdditionalErrorTextForException(Exception e) {
        Throwable initialCausingExceptionObject;
        String additionalText = "";
        Throwable exceptionObject = e.getCause();
        Throwable throwable = initialCausingExceptionObject = exceptionObject.getCause() == null ? exceptionObject : exceptionObject.getCause();
        additionalText = initialCausingExceptionObject instanceof BindException ? "The port is already in use or could not be assigned." : (initialCausingExceptionObject instanceof IOException ? "Not possible to connect to server." : initialCausingExceptionObject.getMessage());
        return additionalText;
    }

    private static class ProxyRestarter
    implements Runnable {
        private InternalEreProxy myProxy;
        private ProgressDialog myDialog;

        ProxyRestarter(InternalEreProxy proxy, ProgressDialog dialog) {
            this.myProxy = proxy;
            this.myDialog = dialog;
        }

        @Override
        public void run() {
            try {
                ProgressIndicator pi = SynchronizedEDTProgressVisualizer.createThreadSafeProgressIndicator(this.myDialog);
                this.myProxy.restartInternalEre(pi);
                this.myDialog.dispose();
            }
            catch (Exception e) {
                this.myDialog.dispose();
                this.myProxy.disconnect();
                DialogFactory.getErrorDialog("Internal ERE could not be started", "The internal ERE could NOT be started:\n" + PropertiesAction.getAdditionalErrorTextForException(e));
            }
        }
    }
}

