/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.actions;

import com.ericsson.ere.exception.UncheckedInterruptedException;
import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateFrame;
import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.gui.util.FrameOpener;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.management.FieldContext;
import ericsson.ere.management.Service;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.SynchronizedEDTProgressVisualizer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InterruptedIOException;
import javax.swing.AbstractAction;
import javax.swing.tree.DefaultMutableTreeNode;

public class MultiDataUpdateAction
extends AbstractAction {
    NavigatorTree myTreeOwner = null;

    public MultiDataUpdateAction(NavigatorTree owner) {
        super("Multi Data Update");
        this.myTreeOwner = owner;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultMutableTreeNode tNode = this.myTreeOwner.getSelectedNode();
        if (tNode instanceof RatingPeriodNode) {
            RatingPeriodProxy proxy = (RatingPeriodProxy)((RatingPeriodNode)tNode).getProxy();
            FunctionContext ctx = FunctionContext.build().withProxy(proxy).get();
            FunctionState state = FunctionManagerImpl.getInstance().getStateForFunction(FunctionToken.MULTI_DATA_UPDATE, ctx);
            if (state == null || state.getState() != FunctionState.State.ON) {
                return;
            }
            ProgressDialog dialog = new ProgressDialog("Multi Data Update", "Reading period information, please wait...");
            final Thread t = new Thread(new OpenMDUTask(dialog, proxy));
            dialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    t.interrupt();
                }
            });
            t.start();
            dialog.setVisible(true);
        }
    }

    private static class OpenMDUTask
    implements Runnable {
        private final ProgressDialog myDialog;
        private final RatingPeriodProxy myProxy;

        OpenMDUTask(ProgressDialog dialog, RatingPeriodProxy proxy) {
            this.myDialog = dialog;
            this.myProxy = proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ProgressIndicator indicator = SynchronizedEDTProgressVisualizer.createThreadSafeProgressIndicator(this.myDialog, 100);
                ProgressIndicator[] progress = indicator.splitProgress(new int[]{3, 7});
                progress[0].setInfo("Retrieving service " + this.myProxy.getServiceName() + " from the server...");
                progress[0].progressStart();
                ServiceProxy serviceProxy = this.myProxy.getRatingManagerProxy().getServiceListProxy().getServiceProxy(this.myProxy.getServiceName());
                Service service = serviceProxy.instantiateServiceObject();
                RatingPlanProxy rpProxy = this.myProxy.getParentRatingPlanProxy();
                FieldContext context = new FieldContext(rpProxy.getServiceProviderProxy().getName(), rpProxy.getName());
                ContextAwareServiceContainer serviceContainer = ContextAwareServiceContainer.createContainerWithContext(service, context);
                progress[0].progressFinished();
                MultiDataUpdateFrame aNewFrame = MultiDataUpdateFrame.createSafelyForProxy(this.myProxy, serviceContainer, progress[1]);
                new FrameOpener(aNewFrame).open();
            }
            catch (Exception e) {
                block4: {
                    try {
                        if (this.isInterruption(e)) break block4;
                        ExceptionUtil.handleException(e, "ratingRuleFrame", 1, "Failed to open Multi Data Update for " + this.myProxy.getName(), true);
                    }
                    catch (Throwable throwable) {
                        EDT.runLater(new Runnable(this){
                            final /* synthetic */ OpenMDUTask this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public void run() {
                                this.this$0.myDialog.dispose();
                            }
                        });
                        throw throwable;
                    }
                }
                EDT.runLater(new /* invalid duplicate definition of identical inner class */);
            }
            EDT.runLater(new /* invalid duplicate definition of identical inner class */);
        }

        private boolean isInterruption(Throwable t) {
            if (t == null) {
                return false;
            }
            if (t instanceof InterruptedException || t instanceof InterruptedIOException || t instanceof UncheckedInterruptedException) {
                return true;
            }
            return this.isInterruption(t.getCause());
        }
    }
}

