/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.actions;

import com.ericsson.ere.gui.navigator.NavigatorConfigLoader;
import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.NavigatorTreeUtil;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.connector.EreCommunicationException;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DeleteAction
extends AbstractAction {
    NavigatorTree myTreeOwner = null;

    public DeleteAction(NavigatorTree owner) {
        super("from this ERE");
        this.myTreeOwner = owner;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreePath[] selectionPaths = this.myTreeOwner.getSelectionPaths();
        if (NavigatorTree.isMultiSelectForRatingPeriodNodes(selectionPaths)) {
            if (DialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), "Confirm delete", "Do you really want to delete these nodes?")) {
                ArrayList<AbstractNavigatorNode> nodeList = new ArrayList<AbstractNavigatorNode>();
                for (TreePath treePath : selectionPaths) {
                    nodeList.add((AbstractNavigatorNode)treePath.getLastPathComponent());
                }
                ArrayList<Integer> indexes = new ArrayList<Integer>();
                this.findNewSelectionAfterDelete((DefaultMutableTreeNode)nodeList.get(0), indexes);
                for (AbstractNavigatorNode navNode : nodeList) {
                    this.performDelete(navNode, navNode.getProxy());
                }
                this.selectNewNode(indexes);
                NavigatorConfigLoader.getInstance().saveNodeConfiguration(GuiServiceCenter.getInstance().getNavigatorRootNode());
            }
        } else {
            DefaultMutableTreeNode node = this.myTreeOwner.getSelectedNode();
            if (NavigatorTreeUtil.nodeIsDeletable(node)) {
                AbstractNavigatorNode navNode = (AbstractNavigatorNode)node;
                if (DialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), "Confirm delete", "Do you really want to delete '" + navNode.toString() + "'?")) {
                    AbstractEreProxy abstractPeriodProxy = navNode.getProxy();
                    ArrayList<Integer> indexes = new ArrayList<Integer>();
                    this.findNewSelectionAfterDelete(node, indexes);
                    this.performDelete(navNode, abstractPeriodProxy);
                    this.selectNewNode(indexes);
                    NavigatorConfigLoader.getInstance().saveNodeConfiguration(GuiServiceCenter.getInstance().getNavigatorRootNode());
                }
            }
        }
    }

    private void findNewSelectionAfterDelete(DefaultMutableTreeNode node, List<Integer> indexes) {
        boolean reduceLastIndex = false;
        TreePath newSelection = null;
        if (node.getNextSibling() != null) {
            newSelection = new TreePath(node.getNextSibling().getPath());
            reduceLastIndex = true;
        } else {
            newSelection = node.getPreviousSibling() != null ? new TreePath(node.getPreviousSibling().getPath()) : new TreePath(((DefaultMutableTreeNode)node.getParent()).getPath());
        }
        for (int i = 1; i < newSelection.getPath().length; ++i) {
            TreeNode pathNode = (TreeNode)newSelection.getPath()[i];
            int index = pathNode.getParent().getIndex(pathNode);
            if (i == newSelection.getPath().length - 1 && reduceLastIndex) {
                --index;
            }
            indexes.add(index);
        }
    }

    private void performDelete(AbstractNavigatorNode navNode, AbstractEreProxy abstractPeriodProxy) {
        try {
            if (abstractPeriodProxy instanceof ServiceProviderProxy) {
                ServiceProviderProxy serviceProviderProxy = (ServiceProviderProxy)abstractPeriodProxy;
                serviceProviderProxy.getRatingManagerProxy().getServiceProviderListProxy().deleteServiceProvider(serviceProviderProxy);
            } else if (abstractPeriodProxy instanceof RatingPlanProxy) {
                RatingPlanProxy ratingPlanProxy = (RatingPlanProxy)abstractPeriodProxy;
                ratingPlanProxy.getServiceProviderProxy().deleteRatingPlan(ratingPlanProxy);
            } else if (abstractPeriodProxy instanceof ServiceProxy) {
                ServiceProxy serviceProviderProxy = (ServiceProxy)abstractPeriodProxy;
                serviceProviderProxy.getRatingManagerProxy().getServiceListProxy().deleteService(serviceProviderProxy);
            } else if (abstractPeriodProxy instanceof RatingPeriodProxy) {
                RatingPeriodProxy ratingPeriodProxy = (RatingPeriodProxy)abstractPeriodProxy;
                ratingPeriodProxy.getParentRatingPlanProxy().deleteRatingPeriod(ratingPeriodProxy);
            } else if (abstractPeriodProxy instanceof EreProxy) {
                EreProxy ereProxy = (EreProxy)abstractPeriodProxy;
                EreProxyManager.getInstance().removeEre(ereProxy);
            }
        }
        catch (EreCommunicationException ex) {
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Problem deleting " + navNode.toString(), "Could not complete the delete operation. \nReason:" + ex.getMessage());
        }
    }

    private void selectNewNode(List<Integer> indexes) {
        TreePath newSelection = new TreePath(this.myTreeOwner.getModel().getRoot());
        for (int i = 0; i < indexes.size(); ++i) {
            if (((TreeNode)newSelection.getLastPathComponent()).getChildCount() > indexes.get(i)) {
                newSelection = newSelection.pathByAddingChild(((TreeNode)newSelection.getLastPathComponent()).getChildAt(indexes.get(i)));
                continue;
            }
            if (indexes.get(i) < 0) continue;
            try {
                newSelection = newSelection.pathByAddingChild(((TreeNode)newSelection.getLastPathComponent()).getChildAt(indexes.get(i) - 1));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            break;
        }
        this.myTreeOwner.expandPath(newSelection);
        this.myTreeOwner.setSelectionPath(newSelection);
    }
}

