/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.actions;

import com.ericsson.ere.gui.editors.propertyeditor.DefaultEreProxySettingsEditor;
import com.ericsson.ere.gui.navigator.NavigatorConfigLoader;
import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.propertieseditor.EditablePropertiesInterface;
import ericsson.ere.gui.propertieseditor.PropertiesEditor;
import ericsson.ere.gui.propertieseditor.PropertiesException;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.integration.settingsmap.propertyio.VarTableInput;
import ericsson.ere.integration.settingsmap.propertyio.VarTableOutput;
import ericsson.vareditor.VarTableModel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class AddEreAction
extends AbstractAction {
    private NavigatorTree myTreeOwner = null;
    private String myType = null;

    public AddEreAction(NavigatorTree owner) {
        this.myTreeOwner = owner;
    }

    public void setType(String type) {
        this.myType = type;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            final EreProxy newProxy = EreProxyManager.getInstance().instantiateNewRemoteEre(this.myType);
            VarTableModel newSettings = VarTableOutput.writeToVarTableModel(newProxy.getSettingsMap());
            PropertiesEditor.showDialogEdit(newSettings, "Connect new Ere", new EditablePropertiesInterface(){

                @Override
                public void cancel() {
                    EreProxyManager.getInstance().removeEre(newProxy);
                }

                @Override
                public String getTitle() {
                    return "New Connection";
                }

                @Override
                public void update(VarTableModel model) throws PropertiesException {
                    try {
                        SettingsMap finalSettings = VarTableInput.readFromVarTableModel(model);
                        this.validateSettings(finalSettings);
                        newProxy.setSettingsMap(finalSettings);
                    }
                    catch (PropertiesException pe) {
                        throw pe;
                    }
                    catch (Exception e) {
                        ExceptionUtil.handleException(e, "ereProxyStructure", 1, "Failed to save settings", true);
                    }
                }

                private void validateSettings(SettingsMap finalSettings) throws PropertiesException {
                    DefaultEreProxySettingsEditor.validateNodeName(finalSettings, newProxy);
                }

                @Override
                public boolean isSuccessful() {
                    return true;
                }
            });
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        NavigatorConfigLoader.getInstance().saveNodeConfiguration(GuiServiceCenter.getInstance().getNavigatorRootNode());
    }

    public String toString() {
        return this.myType;
    }
}

