/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator;

import com.ericsson.ere.exportmanager.NonExportable;
import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionManager;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.DeletableNode;
import com.ericsson.ere.interfaces.ProxyTargetEditor;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.RatingManagerProxy;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.util.StringUtil;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class NavigatorTreeUtil {
    public static final String NODE_SEPARATOR_STRING = "\u0000";
    public static final String PROP_SERVICE_SHOW = "Service.show";

    private NavigatorTreeUtil() {
    }

    public static Vector<DefaultMutableTreeNode> getAllDescendantExportableNodesAsVector(AbstractNavigatorNode rootNode) {
        Vector<DefaultMutableTreeNode> tVector = new Vector<DefaultMutableTreeNode>();
        tVector.add(rootNode);
        Enumeration<TreeNode> e = rootNode.children();
        while (e.hasMoreElements()) {
            AbstractNavigatorNode tNode = (AbstractNavigatorNode)e.nextElement();
            boolean isExportable = !(tNode.getProxy() instanceof NonExportable);
            if (!isExportable) continue;
            tVector.addAll(NavigatorTreeUtil.getAllDescendantExportableNodesAsVector(tNode));
        }
        return tVector;
    }

    public static synchronized boolean shouldServiceListBeShown(RatingManagerProxy ratingManagerProxy) {
        FunctionContext ctx = FunctionContext.createFunctionCtxFromProxy(ratingManagerProxy);
        FunctionManager mgr = FunctionManagerImpl.getInstance();
        FunctionState state = mgr.getStateForFunction(FunctionToken.SHOW_SERVICE_LIST, ctx);
        boolean showServiceList = false;
        if (state.getState() == FunctionState.State.ON) {
            showServiceList = true;
        }
        return showServiceList;
    }

    public static TreePath stringToPath(TreeModel model, String string) {
        String[] nodeNames;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        String strpath = string;
        if (strpath.startsWith("[")) {
            strpath = strpath.substring(1);
        }
        if (strpath.endsWith("]")) {
            strpath = strpath.substring(0, strpath.length() - 1);
        }
        if ((nodeNames = strpath.split(NODE_SEPARATOR_STRING)).length == 0 || StringUtil.isEmptyString(nodeNames[0]) || !nodeNames[0].equals(root.toString())) {
            return null;
        }
        TreePath treePath = new TreePath(root);
        Enumeration<TreeNode> children = root.children();
        if (nodeNames.length > 1) {
            block0: for (int i = 1; i < nodeNames.length && children != null; ++i) {
                while (children.hasMoreElements()) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                    if (!child.toString().equals(nodeNames[i])) continue;
                    treePath = treePath.pathByAddingChild(child);
                    children = child.children();
                    continue block0;
                }
            }
        }
        return treePath;
    }

    public static String pathToString(TreePath path) {
        StringBuffer buf = new StringBuffer("[");
        int max = path.getPathCount();
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                buf.append(NODE_SEPARATOR_STRING);
            }
            buf.append(path.getPathComponent(i));
        }
        buf.append("]");
        return buf.toString();
    }

    public static boolean nodeIsDeletable(DefaultMutableTreeNode node) {
        boolean deletable = false;
        if (node != null && node instanceof AbstractNavigatorNode) {
            AbstractNavigatorNode navNode = (AbstractNavigatorNode)node;
            AbstractEreProxy proxy = navNode.getProxy();
            if (navNode instanceof DeletableNode) {
                deletable = !NavigatorTreeUtil.nodeIsInEditState(proxy) && NavigatorTreeUtil.deleteFunctionIsAllowed(proxy);
            }
        }
        return deletable;
    }

    public static boolean nodeIsDistributable(DefaultMutableTreeNode node) {
        boolean distributable = false;
        if (node != null && node instanceof AbstractNavigatorNode) {
            AbstractNavigatorNode navNode = (AbstractNavigatorNode)node;
            AbstractEreProxy proxy = navNode.getProxy();
            distributable = !NavigatorTreeUtil.nodeIsInEditState(proxy) && NavigatorTreeUtil.distributionFunctionIsAllowed(proxy);
        }
        return distributable;
    }

    private static boolean deleteFunctionIsAllowed(AbstractEreProxy proxy) {
        FunctionManager mgr;
        FunctionState state;
        boolean deletable = true;
        if (!(proxy instanceof EreProxy) && (state = (mgr = FunctionManagerImpl.getInstance()).getStateForFunction(FunctionToken.DELETE_RATING_PERIOD, FunctionContext.build().withProxy(proxy).get())).getState() == FunctionState.State.OFF) {
            deletable = false;
        }
        return deletable;
    }

    public static boolean distributionFunctionIsAllowed(AbstractEreProxy proxy) {
        FunctionManager mgr;
        FunctionState state;
        boolean allowDist = true;
        if (!(proxy instanceof EreProxy) && (state = (mgr = FunctionManagerImpl.getInstance()).getStateForFunction(FunctionToken.DISTRIBUTION_TARGET, FunctionContext.build().withProxy(proxy).get())).getState() == FunctionState.State.OFF) {
            allowDist = false;
        }
        return allowDist;
    }

    public static boolean nodeIsInEditState(AbstractEreProxy proxy) {
        JInternalFrame[] allFrames;
        boolean open = false;
        for (JInternalFrame frame : allFrames = GuiServiceCenter.getInstance().getDesktopPane().getAllFrames()) {
            if (!(frame instanceof ProxyTargetEditor) || !((ProxyTargetEditor)((Object)frame)).isEditingProxy(proxy)) continue;
            open = true;
            break;
        }
        return open;
    }
}

