/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator;

import com.ericsson.ere.io.IOUtil;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import java.io.File;
import javax.swing.JFileChooser;

public class NavigatorFileChooser {
    public static File getExportFile(String description) {
        boolean approved;
        GuiServiceCenter.getInstance().setFileFilter("xml");
        JFileChooser fileChooser = GuiServiceCenter.getInstance().getFileChooser();
        fileChooser.setDialogTitle(description);
        File dest = null;
        boolean bl = approved = fileChooser.showSaveDialog(GuiServiceCenter.getInstance().getMainWindow()) == 0;
        if (approved) {
            boolean overwrite;
            String path;
            dest = fileChooser.getSelectedFile();
            String filename = dest.getName();
            if (!filename.endsWith(".xml")) {
                filename = filename + ".xml";
            }
            if ((dest = new File(filename = (path = dest.getAbsolutePath()).substring(0, path.lastIndexOf(File.separator)) + File.separator + filename)).exists() && !(overwrite = DialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), "File exists", "The file '" + dest.getPath() + "' exists, overwrite existing file?"))) {
                return NavigatorFileChooser.getExportFile(description);
            }
            if (!IOUtil.canCreateFile(dest)) {
                DialogFactory.getErrorDialog("Invalid file name", "The selected file name " + filename + "\n contains invalid characters.\nPlease select another name.");
                return NavigatorFileChooser.getExportFile(description);
            }
        }
        return dest;
    }

    public static File getImportFile(String description) {
        GuiServiceCenter.getInstance().setFileFilter("xml");
        JFileChooser fileChooser = GuiServiceCenter.getInstance().getFileChooser();
        fileChooser.setDialogTitle(description);
        int returnVal = fileChooser.showOpenDialog(GuiServiceCenter.getInstance().getMainWindow());
        if (returnVal == 0) {
            File source = fileChooser.getSelectedFile();
            String fileName = source.getName();
            if (!fileName.toLowerCase().endsWith(".xml")) {
                fileName = fileName + ".xml";
                String path = source.getAbsolutePath();
                fileName = path.substring(0, path.lastIndexOf(File.separator)) + File.separator + fileName;
                source = new File(fileName);
            }
            return source;
        }
        return null;
    }
}

