/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate.presenter;

import com.ericsson.ere.exception.ServiceException;
import com.ericsson.ere.exception.UncheckedInterruptedException;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateFindCriteria;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateModelIOHandler;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateSaveHandler;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateState;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateTableModel;
import com.ericsson.ere.gui.multiupdate.Status;
import com.ericsson.ere.gui.multiupdate.presenter.CopyPasteAction;
import com.ericsson.ere.gui.multiupdate.presenter.ExportAction;
import com.ericsson.ere.gui.multiupdate.presenter.ImportAction;
import com.ericsson.ere.gui.multiupdate.presenter.MultiDataUpdateFindPresenter;
import com.ericsson.ere.gui.multiupdate.view.MultiDataUpdateFindView;
import com.ericsson.ere.gui.multiupdate.view.MultiDataUpdateInfoView;
import com.ericsson.ere.gui.multiupdate.view.MultiDataUpdateModificationView;
import com.ericsson.ere.gui.ratingrules.SelectionTree;
import com.ericsson.ere.gui.ratingrules.SelectionTreeSaveHandler;
import com.ericsson.ere.gui.ratingrules.SelectionTreeSaveHandlerImpl;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.selectiontree.mdu.MDUException;
import com.ericsson.ere.selectiontree.mdu.filter.BooleanSelectionTreeElementFilter;
import com.ericsson.ere.selectiontree.mdu.filter.ConfigurationParameterFilter;
import com.ericsson.ere.selectiontree.mdu.filter.MultiDataUpdateFilterFactory;
import com.ericsson.ere.selectiontree.mdu.filter.SelectionTreeElementFilter;
import com.ericsson.ere.selectiontree.mdu.filter.SelectionTreeElementFilterHelper;
import com.ericsson.ere.selectiontree.mdu.filter.TagBasedElementFilter;
import com.ericsson.ere.selectiontree.mdu.model.ConfigurationParameterPipe;
import com.ericsson.ere.selectiontree.mdu.model.MultiDataUpdateModel;
import com.ericsson.ere.selectiontree.mdu.model.MultiDataUpdateModelImpl;
import com.ericsson.ere.selectiontree.mdu.model.SelectionTreeElementSelector;
import com.ericsson.ere.selectiontree.mdu.model.SelectionTreeElementType;
import com.ericsson.ere.util.BooleanPredicate;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.management.Service;
import ericsson.ere.progress.ProgressIndicator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JInternalFrame;

public class MultiDataUpdateModificationPresenter {
    private MultiDataUpdateModificationView myModificationView;
    private MultiDataUpdateFindView myFindView;
    private SelectionTreeElementFilter myElementServiceFilter;
    private ConfigurationParameterFilter myParameterServiceFilter;
    private RatingPeriodProxy myPeriodProxy;
    private MultiDataUpdateModel myModel;
    private ContextAwareServiceContainer myServiceContainer;
    private MultiDataUpdateState myState = new MultiDataUpdateState();

    public MultiDataUpdateModificationPresenter(MultiDataUpdateModificationView modificationView, MultiDataUpdateInfoView infoView, MultiDataUpdateFindView findView, TariffStructureNode initialRoot, RatingPeriodProxy proxy, ContextAwareServiceContainer serviceContainer) {
        this.myModificationView = modificationView;
        this.myPeriodProxy = proxy;
        this.myFindView = findView;
        this.myServiceContainer = serviceContainer;
        this.createServiceFilters(serviceContainer.getService());
        this.subscribeToViewEvents(initialRoot);
        this.initStateWithObservers(infoView);
    }

    private void initStateWithObservers(MultiDataUpdateInfoView infoView) {
        this.myState.addObserver(infoView);
        this.myState.setDefaultStatus();
    }

    private void createServiceFilters(Service service) {
        MultiDataUpdateFilterFactory factory = this.getMDUFilterFactory(service);
        this.myElementServiceFilter = factory.createElementFilter();
        this.myParameterServiceFilter = factory.createParameterFilter();
    }

    private MultiDataUpdateFilterFactory getMDUFilterFactory(Service service) {
        MultiDataUpdateFilterFactory factory;
        try {
            factory = service.getMultiDataUpdateFilterFactory();
        }
        catch (ServiceException ex) {
            ExceptionUtil.handleException(ex, "multidataupdate", 1, "Failed to create MDU filter factory from service " + service.getId(), false);
            factory = new ExcludeAllMDUFilterFactory();
        }
        if (factory == null) {
            factory = new IncludeAllMDUFilterFactory();
        }
        return factory;
    }

    private void subscribeToViewEvents(TariffStructureNode initialRoot) {
        this.myModificationView.exportDataToFileEvent().addActionListener(new ExportAction(this.myModificationView, this.myState));
        this.myModificationView.importDataFromFileEvent().addActionListener(new ImportAction(this.myModificationView, this.myState));
        this.myModificationView.saveDataEvent().addActionListener(new SaveAction());
        this.myModificationView.saveDataAsEvent().addActionListener(new SaveAsAction());
        this.myModificationView.discardDataEvent().addActionListener(new DiscardDataAction());
        this.myModificationView.setCopyPasteListener(new CopyPasteAction(this.myModificationView, this.myState));
        this.myFindView.extractElements().addActionListener(new ElementExtractorAction(initialRoot, this.myFindView, this.myModificationView));
    }

    SelectionTreeSaveHandler createSaveHandler(SelectionTree st) {
        SelectionTreeSaveHandlerImpl handler = SelectionTreeSaveHandlerImpl.createForProxy(st, this.myServiceContainer, new SelectionTreeSaveHandlerImpl.RatingPeriodProxyWrapper(){

            @Override
            public RatingPeriodProxy getProxy() {
                return MultiDataUpdateModificationPresenter.this.myPeriodProxy;
            }
        });
        handler.useDialogForDifferenceDetectionTool();
        return handler;
    }

    private JInternalFrame findOwnerFrame() {
        if (this.myModificationView instanceof Component) {
            return GuiUtil.getClosestParentOfClass((Component)((Object)this.myModificationView), JInternalFrame.class);
        }
        return null;
    }

    private boolean prepareModelForSaving() {
        boolean success;
        boolean modelNeedsSave = this.myModificationView.isModified();
        boolean canSave = true;
        if (modelNeedsSave && (canSave = this.myModificationView.finishEditing())) {
            this.myModificationView.commitTableModels();
        }
        if (!canSave) {
            this.myState.setStatus(new Status("Changes not saved", "One or more cells contain invalid values.", Status.SEVERITY.ERROR));
        }
        boolean bl = success = canSave && modelNeedsSave;
        if (success) {
            this.myModel.applyChanges();
        }
        return success;
    }

    public boolean doSave(ProgressIndicator progress) {
        boolean saveSuccess = false;
        boolean save = this.prepareModelForSaving();
        if (save) {
            MultiDataUpdateSaveHandler st = new MultiDataUpdateSaveHandler(this.findOwnerFrame(), this.myModel);
            st.getPropertyChangeSupport().addPropertyChangeListener("modified", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MultiDataUpdateModificationPresenter.this.myModificationView.synchronizeTableModels();
                }
            });
            SelectionTreeSaveHandler.SaveResult result = this.createSaveHandler(st).save(progress);
            boolean bl = saveSuccess = result == SelectionTreeSaveHandler.SaveResult.SUCCESS || !st.isModified();
            if (saveSuccess) {
                this.myState.setStatus(new Status("Save success", "Configuration saved successfully.", Status.SEVERITY.TEXT));
            } else {
                this.myModel.revertChanges();
                this.myState.setStatus(new Status("Save error", "Configuration could not be saved, see the log for more information.", Status.SEVERITY.ERROR));
            }
        }
        return saveSuccess;
    }

    public boolean viewHasUnsavedChanges() {
        if (!this.myModificationView.finishEditing()) {
            return true;
        }
        return this.myModificationView.isModified();
    }

    private static class FilterAndCriteriaType {
        SelectionTreeElementFilter filter;
        MultiDataUpdateFindCriteria criteriaType;

        FilterAndCriteriaType(SelectionTreeElementFilter filter, MultiDataUpdateFindCriteria criteriaType) {
            this.filter = filter;
            this.criteriaType = criteriaType;
        }
    }

    private static class ExcludeAllMDUFilterFactory
    implements MultiDataUpdateFilterFactory {
        private ExcludeAllMDUFilterFactory() {
        }

        @Override
        public SelectionTreeElementFilter createElementFilter() {
            return SelectionTreeElementFilterHelper.NO_ELEMENTS_FILTERS;
        }

        @Override
        public ConfigurationParameterFilter createParameterFilter() {
            return SelectionTreeElementFilterHelper.NO_PARAMETERS_FILTER;
        }
    }

    private static class IncludeAllMDUFilterFactory
    implements MultiDataUpdateFilterFactory {
        private IncludeAllMDUFilterFactory() {
        }

        @Override
        public SelectionTreeElementFilter createElementFilter() {
            return SelectionTreeElementFilterHelper.ALL_ELEMENTS_FILTERS;
        }

        @Override
        public ConfigurationParameterFilter createParameterFilter() {
            return SelectionTreeElementFilterHelper.ALL_PARAMETERS;
        }
    }

    private final class SaveAsAction
    implements ActionListener {
        private SaveAsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean save = MultiDataUpdateModificationPresenter.this.prepareModelForSaving();
            if (save) {
                MultiDataUpdateModificationPresenter.this.myModificationView.runInBackground(new MultiDataUpdateModificationView.ProgressJob(){

                    @Override
                    public String getText() {
                        return "Saving changes...";
                    }

                    @Override
                    public String getTitle() {
                        return "Save As";
                    }

                    @Override
                    public boolean needsProgressControl() {
                        return true;
                    }

                    @Override
                    public void run(ProgressIndicator progress) {
                        SaveAsAction.this.doSaveAs(progress);
                    }
                });
            }
        }

        private void doSaveAs(ProgressIndicator progress) {
            boolean wasSaved;
            MultiDataUpdateSaveHandler st = new MultiDataUpdateSaveHandler(MultiDataUpdateModificationPresenter.this.findOwnerFrame(), MultiDataUpdateModificationPresenter.this.myModel);
            boolean saveSuccess = MultiDataUpdateModificationPresenter.this.createSaveHandler(st).saveAs(progress);
            boolean bl = wasSaved = saveSuccess || !st.isModified();
            if (wasSaved) {
                MultiDataUpdateModificationPresenter.this.myState.setStatus(new Status("Save success", "Configuration saved successfully.", Status.SEVERITY.TEXT));
            } else if (progress.isCanceled()) {
                MultiDataUpdateModificationPresenter.this.myState.setStatus(new Status("Save cancelled", "Save has been canceled.", Status.SEVERITY.TEXT));
            } else {
                MultiDataUpdateModificationPresenter.this.myState.setStatus(new Status("Save error", "Configuration was not saved.", Status.SEVERITY.ERROR));
            }
            MultiDataUpdateModificationPresenter.this.myModel.revertChanges();
        }
    }

    private final class DiscardDataAction
    implements ActionListener {
        private DiscardDataAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiDataUpdateModificationPresenter.this.myModificationView.clearResults();
            MultiDataUpdateModificationPresenter.this.myFindView.clearFilter();
            MultiDataUpdateModificationPresenter.this.myState.setDefaultStatus();
            MultiDataUpdateModificationPresenter.this.myModel = null;
        }
    }

    private final class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiDataUpdateModificationPresenter.this.myModificationView.runInBackground(new MultiDataUpdateModificationView.ProgressJob(){

                @Override
                public String getText() {
                    return "Saving changes...";
                }

                @Override
                public String getTitle() {
                    return "Save";
                }

                @Override
                public boolean needsProgressControl() {
                    return true;
                }

                @Override
                public void run(ProgressIndicator progress) {
                    MultiDataUpdateModificationPresenter.this.doSave(progress);
                }
            });
        }
    }

    private final class ElementExtractorAction
    implements ActionListener {
        private TariffStructureNode myTreeRoot;
        private MultiDataUpdateFindView myFindView;
        private MultiDataUpdateModificationView myModificationView;

        public ElementExtractorAction(TariffStructureNode root, MultiDataUpdateFindView findView, MultiDataUpdateModificationView modificationView) {
            this.myTreeRoot = root;
            this.myFindView = findView;
            this.myModificationView = modificationView;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.extractElements(this.myFindView.getSelectedFilterType());
        }

        private void extractElements(MultiDataUpdateFindPresenter.MDUFindFilterType type) {
            Map<String, MultiDataUpdateTableModel> modelMap;
            FilterAndCriteriaType filterAndCriteriaType = this.createFilterAndCriteriaType(type);
            SelectionTreeElementFilter searchFilter = filterAndCriteriaType.filter;
            MultiDataUpdateFindCriteria criteriaType = filterAndCriteriaType.criteriaType;
            if (searchFilter != null && (modelMap = this.buildModels(searchFilter, criteriaType)) != null) {
                assert (MultiDataUpdateModificationPresenter.this.myModel != null) : "Model was not set!";
                this.myModificationView.updateModel(modelMap);
                if (modelMap.isEmpty() && !searchFilter.equals(SelectionTreeElementFilterHelper.NO_ELEMENTS_FILTERS)) {
                    MultiDataUpdateModificationPresenter.this.myState.updateStateWithTipsOnNoHits(type);
                } else if (type == MultiDataUpdateFindPresenter.MDUFindFilterType.BASED_ON_FILE && this.myFindView.isImportDataFromFileSelected()) {
                    File file = this.myFindView.getCriterionBaseFileIfSelected();
                    assert (file != null);
                    MultiDataUpdateModificationPresenter.this.myState.setStatus(MultiDataUpdateModelIOHandler.importFromFileToModel(file, modelMap, this.myModificationView.getActiveTabTitle()));
                } else {
                    MultiDataUpdateModificationPresenter.this.myState.setResultStatus();
                }
            }
        }

        private FilterAndCriteriaType createFilterAndCriteriaType(MultiDataUpdateFindPresenter.MDUFindFilterType type) {
            FilterAndCriteriaType ret;
            switch (type) {
                case ALL_BASED_ON_PATH: {
                    ret = new FilterAndCriteriaType(SelectionTreeElementFilterHelper.ALL_ELEMENTS_FILTERS, MultiDataUpdateFindCriteria.PATH_BASED);
                    break;
                }
                case ALL_BASED_ON_TAG: {
                    ret = new FilterAndCriteriaType(SelectionTreeElementFilterHelper.TAG_ELEMENT_FILTER, MultiDataUpdateFindCriteria.TAG_BASED);
                    break;
                }
                case BASED_ON_FILE: {
                    File baseFile = this.myFindView.getCriterionBaseFileIfSelected();
                    if (baseFile == null) {
                        return new FilterAndCriteriaType(null, null);
                    }
                    ret = this.createFilterBasedOnFile(baseFile);
                    break;
                }
                default: {
                    ret = this.createFilterFromCriteriaString(type);
                }
            }
            return ret;
        }

        private FilterAndCriteriaType createFilterBasedOnFile(File file) {
            SelectionTreeElementFilter filter = SelectionTreeElementFilterHelper.NO_ELEMENTS_FILTERS;
            MultiDataUpdateFindCriteria criteriaType = MultiDataUpdateFindCriteria.TAG_BASED;
            if (file == null) {
                MultiDataUpdateModificationPresenter.this.myState.setStatus(new Status("Could not read from file", "File not found.", Status.SEVERITY.ERROR));
            } else {
                List<Object> filters = new ArrayList();
                try {
                    filters = MultiDataUpdateModelIOHandler.importFiltersFromFile(file);
                    if (!filters.isEmpty()) {
                        criteriaType = filters.get(0) instanceof TagBasedElementFilter ? MultiDataUpdateFindCriteria.TAG_BASED : MultiDataUpdateFindCriteria.PATH_BASED;
                        filter = new BooleanSelectionTreeElementFilter(BooleanPredicate.Operation.OR, filters, "File filter");
                    }
                }
                catch (MDUException mdue) {
                    MultiDataUpdateModificationPresenter.this.myState.setStatus(new Status("Could not read from file", mdue.getMessage(), Status.SEVERITY.ERROR));
                    filter = null;
                }
            }
            return new FilterAndCriteriaType(filter, criteriaType);
        }

        private FilterAndCriteriaType createFilterFromCriteriaString(MultiDataUpdateFindPresenter.MDUFindFilterType type) {
            MultiDataUpdateFindCriteria criteriaType;
            SelectionTreeElementFilter filter = null;
            switch (type) {
                case SPECIFIC_TAGS: {
                    criteriaType = MultiDataUpdateFindCriteria.TAG_BASED;
                    break;
                }
                case SPECIFIC_PATHS: {
                    criteriaType = MultiDataUpdateFindCriteria.PATH_BASED;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Type not expected here: " + (Object)((Object)type)));
                }
            }
            String criteriaString = this.myFindView.getCriteriaString().trim();
            if (criteriaString.length() > 0) {
                try {
                    filter = criteriaType.createBooleanPredicateFromString(criteriaString);
                }
                catch (IllegalArgumentException e) {
                    MultiDataUpdateModificationPresenter.this.myState.setStatus(new Status("Faulty format", e.getMessage() + " Press F1 to access RMA User Guide to see a definition of the path criteria format.", Status.SEVERITY.ERROR));
                }
            } else {
                switch (type) {
                    case SPECIFIC_TAGS: {
                        filter = SelectionTreeElementFilterHelper.TAG_ELEMENT_FILTER;
                        break;
                    }
                    case SPECIFIC_PATHS: {
                        filter = SelectionTreeElementFilterHelper.ALL_ELEMENTS_FILTERS;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Type not expected here: " + (Object)((Object)type)));
                    }
                }
            }
            return new FilterAndCriteriaType(filter, criteriaType);
        }

        private Map<String, MultiDataUpdateTableModel> buildModels(SelectionTreeElementFilter searchFilter, MultiDataUpdateFindCriteria criteriaType) {
            ModelBuilder builder = new ModelBuilder(searchFilter, criteriaType);
            this.myModificationView.runInBackground(builder);
            Map<String, MultiDataUpdateTableModel> ret = null;
            if (builder.model != null && builder.tableModels != null) {
                MultiDataUpdateModificationPresenter.this.myModel = builder.model;
                ret = builder.tableModels;
            } else if (builder.error != null) {
                long num = ExceptionUtil.handleException(builder.error, "multidataupdate", 1, "An error occurred while building models.", false);
                MultiDataUpdateModificationPresenter.this.myState.setStatus(new Status("Search failed", String.format("An error occurred while searching for data. Please see log entry %d for details.", num), Status.SEVERITY.ERROR));
            }
            return ret;
        }

        private final class ModelBuilder
        implements MultiDataUpdateModificationView.ProgressJob {
            private SelectionTreeElementFilter mySearchFilter;
            private MultiDataUpdateFindCriteria myCriteriaType;
            MultiDataUpdateModel model;
            Map<String, MultiDataUpdateTableModel> tableModels;
            Throwable error;

            ModelBuilder(SelectionTreeElementFilter searchFilter, MultiDataUpdateFindCriteria criteriaType) {
                this.mySearchFilter = searchFilter;
                this.myCriteriaType = criteriaType;
            }

            @Override
            public void run(ProgressIndicator progress) {
                block5: {
                    ProgressIndicator[] pis = progress.splitProgress(new int[]{1, 9});
                    try {
                        pis[0].setInfo("Discovering selection tree elements...");
                        pis[0].progressStart();
                        MultiDataUpdateModel mdl = this.createMainModel(this.mySearchFilter);
                        pis[0].progressFinished();
                        if (!Thread.interrupted()) {
                            Map<String, MultiDataUpdateTableModel> tms = this.createTableModels(mdl, this.myCriteriaType, pis[1]);
                            if (!Thread.interrupted()) {
                                this.model = mdl;
                                this.tableModels = tms;
                            }
                        }
                    }
                    catch (UncheckedInterruptedException mdl) {
                    }
                    catch (RuntimeException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof InterruptedException) break block5;
                        this.error = cause != null ? cause : ex;
                    }
                }
            }

            @Override
            public String getText() {
                return "Searching...";
            }

            @Override
            public String getTitle() {
                return "Multi Data Update";
            }

            @Override
            public boolean needsProgressControl() {
                return true;
            }

            private MultiDataUpdateModel createMainModel(SelectionTreeElementFilter searchFilter) {
                SelectionTreeElementSelector selector = SelectionTreeElementSelector.create(MultiDataUpdateModificationPresenter.this.myElementServiceFilter, searchFilter);
                ConfigurationParameterPipe pipe = ConfigurationParameterPipe.create(MultiDataUpdateModificationPresenter.this.myParameterServiceFilter, SelectionTreeElementFilterHelper.ALL_PARAMETERS);
                return MultiDataUpdateModelImpl.build(ElementExtractorAction.this.myTreeRoot, selector, pipe);
            }

            private Map<String, MultiDataUpdateTableModel> createTableModels(MultiDataUpdateModel model, MultiDataUpdateFindCriteria criteria, ProgressIndicator progress) {
                HashMap<String, MultiDataUpdateTableModel> models = new HashMap<String, MultiDataUpdateTableModel>();
                Collection<SelectionTreeElementType> ctypes = model.getElementTypes();
                int count = ctypes.size();
                ProgressIndicator[] pis = progress.splitProgress(count);
                int idx = 0;
                for (SelectionTreeElementType type : ctypes) {
                    pis[idx].setInfo("Building table for " + type.getTypeName() + "...");
                    pis[idx].progressStart(2);
                    List<TariffStructureNode> elements = model.getElementsOfType(type);
                    List<SelectionTreeElementFilter> rowFilters = criteria.extractUniqueFiltersFromCompound(elements);
                    pis[idx].progressIncrement();
                    MultiDataUpdateTableModel tableModel = new MultiDataUpdateTableModel(type, model, rowFilters, null);
                    models.put(type.getTypeName(), tableModel);
                    pis[idx].progressFinished();
                    ++idx;
                }
                return models;
            }
        }
    }
}

