/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate.presenter;

import com.ericsson.ere.gui.multiupdate.MultiDataUpdateModelIOHandler;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateState;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateTableModel;
import com.ericsson.ere.gui.multiupdate.Status;
import com.ericsson.ere.gui.multiupdate.view.MultiDataUpdateModificationView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;

final class CopyPasteAction
implements ActionListener {
    private MultiDataUpdateModificationView myModificationView;
    private MultiDataUpdateState myState;

    public CopyPasteAction(MultiDataUpdateModificationView modificationView, MultiDataUpdateState state) {
        this.myModificationView = modificationView;
        this.myState = state;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.currentViewStateAllowsPaste()) {
            Map<String, MultiDataUpdateTableModel> tableModels = this.myModificationView.getUsedModels();
            String key = this.myModificationView.getActiveTabTitle();
            if ("Copy".equals(e.getActionCommand())) {
                MultiDataUpdateTableModel model = tableModels.get(key);
                Status statusOfCopy = MultiDataUpdateModelIOHandler.copyFromModel(model, key);
                this.updateState(statusOfCopy);
            } else {
                Status status = MultiDataUpdateModelIOHandler.pasteIntoModel(tableModels, key);
                this.updateState(status);
            }
        }
    }

    private void updateState(Status statusOfPaste) {
        if (statusOfPaste == null) {
            this.myState.setResultStatus();
        } else {
            this.myState.setStatus(statusOfPaste);
        }
    }

    private boolean currentViewStateAllowsPaste() {
        boolean pasteAllowed = true;
        if (this.myModificationView.isModified()) {
            String question = "There are modified values in the current view.\nPasted values will overwrite any existing modifications.\nDo you want to continue?";
            pasteAllowed = this.myModificationView.askQuestion("Paste", question);
        }
        return pasteAllowed;
    }
}

