/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate;

import com.ericsson.ere.gui.multiupdate.MultiDataUpdateTableModel;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.selectiontree.mdu.filter.SelectionTreeElementFilter;
import com.ericsson.ere.util.HTMLUtil;
import ericsson.ere.defs.RmaDefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public abstract class MultiDataUpdateCellRenderer
extends JLabel
implements TableCellRenderer {
    protected static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(2, 2, 0, 2);
    protected static final Font STD_FONT = new Font("Arial", 0, 12);

    protected MultiDataUpdateCellRenderer() {
        this.setOpaque(true);
        this.setFont(STD_FONT);
        this.setBorder(EMPTY_BORDER);
    }

    public static TableCellRenderer createRendererForHeaderColumn() {
        return new HeaderColRenderer();
    }

    public static TableCellRenderer createRendererForOldValueColumn() {
        return new OldValueColRenderer();
    }

    public static TableCellRenderer createRendererForNewValueColumn() {
        return new NewValueColRenderer();
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setToolTipText(null);
        return this.getTableCellRendererComponent(MultiDataUpdateCellRenderer.getTableModel(table), value, isSelected, hasFocus, row, column);
    }

    protected abstract Component getTableCellRendererComponent(MultiDataUpdateTableModel var1, Object var2, boolean var3, boolean var4, int var5, int var6);

    protected static MultiDataUpdateTableModel getTableModel(JTable table) {
        return (MultiDataUpdateTableModel)table.getModel();
    }

    protected JComponent createCompositeComponent(Component left, Component right) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(left, "Center");
        panel.add(right, "East");
        return panel;
    }

    protected Component getVariableRenderer(MultiDataUpdateTableModel tm, int row, int column, Object value, Color bg) {
        Component r;
        try {
            r = tm.createRendererForCell(row, column, value);
            r.setBackground(bg);
            if (r instanceof JComponent) {
                JComponent jr = (JComponent)r;
                jr.setOpaque(true);
                jr.setBorder(EMPTY_BORDER);
            }
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "multidataupdate", 1, String.format("Failed to get variable renderer for cell [%d, %d].", row, column), false);
            r = null;
        }
        return r;
    }

    protected String getDisplayString(MultiDataUpdateTableModel tm, int row, int column, Object value) {
        String s;
        try {
            s = tm.getDisplayStringForCell(row, column, value);
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "multidataupdate", 1, String.format("Failed to get variable renderer for cell [%d, %d].", row, column), false);
            s = String.valueOf(value);
        }
        return s;
    }

    private static class HeaderColRenderer
    extends MultiDataUpdateCellRenderer {
        private static final Font COUNT_LBL_FONT = STD_FONT.deriveFont(1, 11.0f);
        private static final Color COUNT_LBL_BG = Color.blue.darker();
        private static final Color COUNT_LBL_FG = Color.white;
        private static final String NOCOUNT_HTML_FMT = "<html><i>%s</i></html>";
        private static final String EXT_COUNT_TOOLTIP_FMT = "<html><span/>%s<br><i>This row represents %d selection tree elements.</i></html>";

        private HeaderColRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(MultiDataUpdateTableModel tm, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            assert (column == 0) : "This renderer should be used for the first column.";
            assert (value == null || value instanceof SelectionTreeElementFilter);
            this.setToolTipText(null);
            this.setText("");
            if (value != null) {
                int count = tm.getElementCountForRow(row);
                SelectionTreeElementFilter filter = (SelectionTreeElementFilter)value;
                String labelText = String.format(NOCOUNT_HTML_FMT, HTMLUtil.escape(filter.getDisplayString()));
                this.setText(labelText);
                JComponent rend = this;
                String tooltip = filter.getDisplayString();
                if (count > 1) {
                    rend = this.createCompositeComponent(this, this.createCountLabel(count));
                    tooltip = String.format(EXT_COUNT_TOOLTIP_FMT, tooltip, count);
                }
                rend.setToolTipText(tooltip);
                return rend;
            }
            return this;
        }

        private JLabel createCountLabel(int count) {
            JLabel countLabel = new JLabel(String.valueOf(count));
            countLabel.setOpaque(true);
            countLabel.setFont(COUNT_LBL_FONT);
            countLabel.setBorder(BorderFactory.createEmptyBorder(2, 5, 0, 5));
            countLabel.setBackground(COUNT_LBL_BG);
            countLabel.setForeground(COUNT_LBL_FG);
            return countLabel;
        }
    }

    private static class OldValueColRenderer
    extends MultiDataUpdateCellRenderer {
        private OldValueColRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(MultiDataUpdateTableModel tm, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer;
            boolean isNoValue;
            assert (column % 2 == 1) : "This renderer should be used for odd-numbered columns.";
            Object v = value;
            boolean hasMultiValues = false;
            boolean bl = isNoValue = v == null;
            if (value instanceof Collection) {
                Collection coll = (Collection)value;
                if (coll.isEmpty()) {
                    isNoValue = true;
                } else {
                    v = coll.iterator().next();
                    hasMultiValues = true;
                }
            }
            if (isNoValue) {
                this.setText("No value");
                this.setFont(this.getFont().deriveFont(2));
                renderer = this;
            } else {
                renderer = this.getRendererComponent(tm, row, column, v);
                if (hasMultiValues) {
                    JLabel iconLabel = this.createIconLabel();
                    JComponent jrend = this.createCompositeComponent(renderer, iconLabel);
                    String tooltip = this.createMultiValueToolTip(tm, row, column, value);
                    jrend.setToolTipText(tooltip);
                    renderer = jrend;
                }
            }
            return renderer;
        }

        private String createMultiValueToolTip(MultiDataUpdateTableModel tm, int row, int column, Object value) {
            StringBuilder builder = new StringBuilder("<html><b>There are multiple values in the tree</b>:\n");
            Collection coll = (Collection)value;
            int i = 0;
            int count = coll.size();
            for (Object x : coll) {
                builder.append("<br><span>- </span>");
                if (builder.length() > 2500) {
                    int omitted = count - i;
                    builder.append("... (").append(omitted).append(" values omitted)\n");
                    break;
                }
                String str = HTMLUtil.escape(this.getDisplayString(tm, row, column, x));
                builder.append(str).append("\n");
                ++i;
            }
            return builder.toString();
        }

        private JLabel createIconLabel() {
            JLabel iconLabel = new JLabel(RmaDefs.getImageIcon("information16.png"));
            iconLabel.setOpaque(false);
            iconLabel.setBorder(EMPTY_BORDER);
            return iconLabel;
        }

        private Component getRendererComponent(MultiDataUpdateTableModel tm, int row, int column, Object value) {
            Component renderer = this.getVariableRenderer(tm, row, column, value, this.getBackground());
            if (renderer == null) {
                String s;
                if (value instanceof Number) {
                    this.setHorizontalAlignment(4);
                }
                if ((s = String.valueOf(value)).indexOf(10) >= 0) {
                    s = "<html>" + HTMLUtil.escape(s).replaceAll("\r?\n", "<br>") + "</html>";
                }
                this.setText(s);
                renderer = this;
            } else if (renderer instanceof JLabel) {
                ((JLabel)renderer).setFont(this.getFont());
            }
            return renderer;
        }
    }

    private static class NewValueColRenderer
    extends MultiDataUpdateCellRenderer {
        private NewValueColRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(MultiDataUpdateTableModel tm, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            assert (column % 2 == 0) : "This renderer should be used for even-numbered columns.";
            boolean modified = tm.isModifiedAt(row, column);
            Component renderer = null;
            if (modified) {
                renderer = this.getVariableRenderer(tm, row, column, value, Color.WHITE);
            }
            if (renderer == null) {
                this.setBackground(Color.WHITE);
                if (value instanceof Number) {
                    this.setHorizontalAlignment(4);
                }
                this.setText(modified ? String.valueOf(value) : "");
                renderer = this;
            }
            return renderer;
        }
    }
}

