/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate;

import com.ericsson.charging.common.dataitem.DataItemAdapter;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.MultiplierNumber;
import com.ericsson.ere.interfaces.DynamicClassProfile;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.interfaces.ConfigurationParameter;
import com.ericsson.ere.selectiontree.mdu.filter.ExtendedSelectionTreeElementFilter;
import com.ericsson.ere.selectiontree.mdu.filter.SelectionTreeElementFilter;
import com.ericsson.ere.selectiontree.mdu.model.MultiDataUpdateModel;
import com.ericsson.ere.selectiontree.mdu.model.SelectionTreeElementType;
import com.ericsson.ere.selectiontree.util.SelectionTreeGUIUtil;
import com.ericsson.ere.selectiontree.util.SelectionTreeUtil;
import ericsson.ere.datatype.Time;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.interfaces.ClassProfile;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.vareditor.variable.DoubleVariable;
import ericsson.vareditor.variable.MultiplierSelectEditorVariable;
import ericsson.vareditor.variable.MultiplierSelectEditorVariable2;
import ericsson.vareditor.variable.Variable;
import java.awt.Component;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;

public class ConfigurationParameterHelper {
    private TariffStructureNode myElement;
    private ConfigurationParameter myParameter;

    public ConfigurationParameterHelper(MultiDataUpdateModel model, SelectionTreeElementType elementType, SelectionTreeElementFilter rowFilter, ConfigurationParameter parameter) {
        if (model == null || elementType == null || parameter == null || rowFilter == null) {
            throw new IllegalArgumentException("Null argument not permitted.");
        }
        TariffStructureNode found = this.getFirstElement(model, elementType, rowFilter);
        if (found == null) {
            throw new IllegalArgumentException("The element type does not appear to come from the model.");
        }
        this.myElement = found;
        this.myParameter = parameter;
    }

    private TariffStructureNode getFirstElement(MultiDataUpdateModel model, SelectionTreeElementType elementType, SelectionTreeElementFilter rowFilter) {
        List<TariffStructureNode> elements = model.getElementsOfType(elementType);
        if (rowFilter instanceof ExtendedSelectionTreeElementFilter) {
            Collection<TariffStructureNode> coll = ((ExtendedSelectionTreeElementFilter)rowFilter).filter(elements);
            return coll.iterator().next();
        }
        TariffStructureNode found = null;
        for (TariffStructureNode tn : elements) {
            if (!rowFilter.test(tn)) continue;
            found = tn;
            break;
        }
        return found;
    }

    public Object parseStringToObject(String str) throws Exception {
        Variable var = this.createVariable();
        var.setValue(str);
        if (!var.isValueValid()) {
            throw new IllegalArgumentException("Value " + str + " was not accepted as valid by the variable.");
        }
        return var.getValueObject();
    }

    public Variable createVariable() throws Exception {
        return this.createVariableForValue(null);
    }

    public Variable createVariableForValue(Object value) throws Exception {
        Variable var = ConfigurationParameterHelper.findVariableForParameterAndValue(this.createFreshProfileVariables(), this.myParameter, value);
        if (var == null) {
            String msg = "No matching variable found for configuration parameter " + this.myParameter.getName();
            if (value != null) {
                msg = msg + " with value " + value;
            }
            throw new IllegalArgumentException(msg);
        }
        if (value != null) {
            var.setValue(value);
            if (!var.isValueValid()) {
                throw new IllegalArgumentException("Value " + value + " was not accepted as valid by the variable.");
            }
        }
        return var;
    }

    public Component createRendererForValue(Object value) throws Exception {
        Variable var = this.createVariableForValue(value);
        return var.getRenderer();
    }

    public String getDisplayStringForValue(Object value) throws Exception {
        Variable var = this.createVariableForValue(value);
        return var.toString();
    }

    public String getValueStringForValue(Object value) throws Exception {
        Variable var = this.createVariableForValue(value);
        return var.getValueString();
    }

    private List<Variable> createFreshProfileVariables() throws Exception {
        TSElement tse = SelectionTreeGUIUtil.getTSElement(this.myElement);
        Element config = SelectionTreeUtil.getElementConfiguration(this.myElement);
        tse.init(config);
        List<Variable> vars = tse.getVariablesForEditing(null);
        this.registerVariables(tse.getClassProfile(), vars);
        return vars;
    }

    private void registerVariables(ClassProfile profile, List<Variable> vars) {
        VariableChangeListener listener = new VariableChangeListener(profile, vars);
        for (Variable var : vars) {
            var.setDataItem(listener);
        }
    }

    public static Variable findVariableForParameterAndValue(List<Variable> variables, ConfigurationParameter param, Object value) {
        Variable ret = null;
        Variable var = ConfigurationParameterHelper.findVariableForParameter(variables, param);
        if (var != null) {
            Variable real = ConfigurationParameterHelper.performVariableSubstitution(var, param);
            Class<?> variableType = ConfigurationParameterHelper.getVariableValueType(real, value);
            if (value == null || variableType.isInstance(value)) {
                ret = real;
            }
        }
        return ret;
    }

    private static Class<?> getVariableValueType(Variable var, Object value) {
        Class<Object> type = var.getValueClass();
        if (value instanceof ERETime && type == Time.class) {
            type = ERETime.class;
        } else if (value instanceof EREDate && type == Date.class) {
            type = EREDate.class;
        }
        return type;
    }

    private static Variable findVariableForParameter(List<Variable> variables, ConfigurationParameter param) {
        Variable found = null;
        for (Variable var : variables) {
            if (!var.getLabel().equalsIgnoreCase(param.getName()) && !var.getLabel().equalsIgnoreCase(param.getDisplayName()) && !var.getKey().equalsIgnoreCase(param.getName())) continue;
            found = var;
            break;
        }
        return found;
    }

    private static Variable performVariableSubstitution(Variable v, ConfigurationParameter param) {
        Variable ret = v;
        Class<?> type = param.getType();
        if (v instanceof MultiplierSelectEditorVariable && MultiplierNumber.class.isAssignableFrom(type)) {
            ret = MultiplierSelectEditorVariable2.wrap((MultiplierSelectEditorVariable)v);
        } else if (v instanceof DoubleVariable && type == RatingDecimal.class) {
            ret = ((DoubleVariable)v).createCompatibleRatingDecimalVariable();
        }
        return ret;
    }

    public String toString() {
        return String.format("Helper for parameter %s (%s)", this.myParameter.getName(), this.myParameter.getDisplayName());
    }

    private static class VariableChangeListener
    extends DataItemAdapter {
        private DynamicClassProfile myProfile;
        private List<Variable> myVariables;

        VariableChangeListener(ClassProfile profile, List<Variable> variables) {
            if (profile instanceof DynamicClassProfile) {
                this.myProfile = (DynamicClassProfile)((Object)profile);
            }
            this.myVariables = variables;
        }

        @Override
        public void setDataItem(Object key, Object variable) {
            boolean updated;
            Variable var = (Variable)variable;
            if (this.myProfile != null && (updated = this.myProfile.parameterChanged(var.getLabel(), var, this.myVariables))) {
                throw new IllegalStateException("Cannot edit value, since it changes the entire element setup.");
            }
        }
    }
}

