/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.xmlprinters;

import com.ericsson.ere.gui.editors.serviceeditor.interfaces.ServiceEditorNodeInterface;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrintServiceDefintion {
    private static final int CONTEXT_FIELDS_INDEX = 1;
    static String TAB = "\t";
    static String NL = System.getProperty("line.separator");

    public static void useTabs(boolean onOff) {
        TAB = onOff ? "\t" : "";
    }

    public static Document printToDocument(DefaultMutableTreeNode fieldsDefNode, DefaultMutableTreeNode contextDefNode, String constraintsXML) throws Exception {
        Document fieldsDocument = XMLUtil.createEmptyDocument();
        ((ServiceEditorNodeInterface)((Object)fieldsDefNode)).appendXML(fieldsDocument);
        Document contextsDocument = XMLUtil.createEmptyDocument();
        ((ServiceEditorNodeInterface)((Object)contextDefNode)).appendXML(contextsDocument);
        PrintServiceDefintion.moveContextFieldsToContextDefinitions(fieldsDocument, contextsDocument);
        PrintServiceDefintion.moveContextDefinitionsIntoFieldsDocument(fieldsDocument, contextsDocument);
        if (constraintsXML != null) {
            Element constraintsRoot = XMLUtil.buildDocumentFromString(constraintsXML).getDocumentElement();
            constraintsRoot = (Element)fieldsDocument.adoptNode(constraintsRoot);
            fieldsDocument.getDocumentElement().appendChild(constraintsRoot);
        }
        return fieldsDocument;
    }

    private static void moveContextDefinitionsIntoFieldsDocument(Document fieldsDocument, Document contextsDocument) {
        Node contextDefRoot = contextsDocument.getDocumentElement();
        contextDefRoot = fieldsDocument.adoptNode(contextDefRoot);
        fieldsDocument.getDocumentElement().appendChild(contextDefRoot);
    }

    private static void moveContextFieldsToContextDefinitions(Document fieldsDoc, Document contextsDoc) {
        Node contextFieldsRoot = PrintServiceDefintion.getContextFieldsRoot(fieldsDoc);
        Element contextDefinitionsRoot = contextsDoc.getDocumentElement();
        contextFieldsRoot = contextsDoc.adoptNode(contextFieldsRoot);
        contextDefinitionsRoot.insertBefore(contextFieldsRoot, contextDefinitionsRoot.getFirstChild());
    }

    private static Node getContextFieldsRoot(Document fieldsDoc) {
        NodeList children = fieldsDoc.getDocumentElement().getChildNodes();
        List<Element> fieldElements = XMLUtil.getElementNodesNamed("Fields", children);
        assert (fieldElements.size() == 2);
        return fieldElements.get(1);
    }

    public static Document printToDocument(DefaultMutableTreeNode fieldsDefNode, DefaultMutableTreeNode contextDefNode) throws Exception {
        return PrintServiceDefintion.printToDocument(fieldsDefNode, contextDefNode, null);
    }

    public static String print(DefaultMutableTreeNode fieldsDefNode, DefaultMutableTreeNode contextDefNode) throws Exception {
        Document doc = PrintServiceDefintion.printToDocument(fieldsDefNode, contextDefNode);
        return DomWriter.nodeToString(doc, true);
    }
}

