/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes;

import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.AbstractPluginTM;
import com.ericsson.ere.util.CountedObjectRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class GenericConditionTM
extends AbstractPluginTM {
    private static final String TAG_GenericConditions = "Condition";
    private static final String ATT_ConditionAlias = "alias";
    private static final String ATT_Field = "field";
    private static final String ICON = "condition16.png";
    static final String LABEL_FIELD = "Field";

    public GenericConditionTM(CountedObjectRepository<String> conditionNameRepository) {
        super(TAG_GenericConditions, conditionNameRepository);
    }

    @Override
    protected void setupVarList(CountedObjectRepository<String> conditionNameRepository) {
        super.setupVarList(conditionNameRepository);
        this.addAliasVariable(conditionNameRepository);
        VarListUtil.insertVariableAfterLabel(this.myVarList, "Comment", new StringVariable(LABEL_FIELD, ""));
    }

    public GenericConditionTM(NamedNodeMap attributes, CountedObjectRepository<String> conditionNameRepository) {
        super(TAG_GenericConditions, attributes, conditionNameRepository);
        String aliasString = XMLUtil.getAttributeValue(attributes, ATT_ConditionAlias, "");
        String fieldStr = XMLUtil.getAttributeValue(attributes, ATT_Field, "");
        VarListUtil.getVariableForName(this.myVarList, "Alias").setValue(aliasString);
        VarListUtil.getVariableForName(this.myVarList, LABEL_FIELD).setValue(fieldStr);
    }

    @Override
    protected Element createConfigurationElement(Document doc) {
        Element e = super.createConfigurationElement(doc);
        e.setAttribute(ATT_ConditionAlias, this.getAlias());
        e.setAttribute(ATT_Field, this.getVariableString(LABEL_FIELD));
        return e;
    }

    @Override
    protected ImageIcon getNodeIcon(boolean expanded) {
        return RmaDefs.getImageIcon(ICON);
    }

    @Override
    public String getAlias() {
        return this.getVariableString("Alias");
    }
}

