/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.AbstractPluginTM;
import com.ericsson.ere.util.CountedObjectRepository;
import ericsson.ere.defs.EreDefs;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.ArrayVariable;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class BaseConditionTM
extends AbstractPluginTM {
    private static final String TAG_BaseConditions = "Condition";
    private static final String ATT_ConditionAlias = "alias";
    private static final String ATT_DataType = "dataType";
    private static final String ATT_DataTypeList = "DataTypeList";
    private static final String ICON = "condition16.png";
    private static final String LOCKED_ICON = "condition_locked16.png";
    static final String LABEL_DATATYPE = "Data type";
    static final String LABEL_DATATYPE_LIST = "Data type list";
    private String defaultDataType = "String";
    private Object[] defaultDataTypeArray = new Object[]{this.defaultDataType};
    private Variable myDataTypeArray = new ArrayVariable("Data type", this.defaultDataTypeArray);
    private Variable myDataTypeDropDown = new DropDownVariable("Data type", (Object)this.defaultDataType, (Object[])EreDefs.dataTypeArray);

    public BaseConditionTM(CountedObjectRepository<String> conditionNameRepository) {
        super(TAG_BaseConditions, conditionNameRepository);
        this.myVarList.add(this.myDataTypeDropDown);
    }

    @Override
    protected void setupVarList(CountedObjectRepository<String> nameRepository) {
        super.setupVarList(nameRepository);
        this.addAliasVariable(nameRepository);
        this.myVarList.add(new BoolVariable(LABEL_DATATYPE_LIST, false));
    }

    public BaseConditionTM(NamedNodeMap attributes, CountedObjectRepository<String> conditionNameRepository) {
        super(TAG_BaseConditions, attributes, conditionNameRepository);
        String aliasString = XMLUtil.getAttributeValue(attributes, ATT_ConditionAlias, "");
        String dataTypeStr = XMLUtil.getAttributeValue(attributes, ATT_DataType, "");
        String isDataTypeListStr = XMLUtil.getAttributeValue(attributes, ATT_DataTypeList, "");
        boolean isDataTypeList = Boolean.parseBoolean(isDataTypeListStr) || dataTypeStr.contains(",");
        VarListUtil.getVariableForName(this.myVarList, "Alias").setValue(aliasString);
        VarListUtil.getVariableForName(this.myVarList, LABEL_DATATYPE_LIST).setValue(isDataTypeList);
        if (isDataTypeList) {
            String[] types = dataTypeStr.split(",\\s*");
            this.myDataTypeArray.setValue(types);
        } else {
            this.myDataTypeDropDown.setValue(dataTypeStr);
        }
    }

    private void setVariablesForDataType() {
        VarListUtil.removeVariablesByLabel((List<Variable>)this.myVarList, LABEL_DATATYPE);
        if (VarListUtil.getBooleanValueForName(this.myVarList, LABEL_DATATYPE_LIST).booleanValue()) {
            this.myVarList.add(this.myDataTypeArray);
        } else {
            this.myVarList.add(this.myDataTypeDropDown);
        }
    }

    @Override
    protected Element createConfigurationElement(Document doc) {
        boolean isDataTypeList = VarListUtil.getBooleanValueForName(this.myVarList, LABEL_DATATYPE_LIST);
        String dataTypeString = this.getDataTypeString(isDataTypeList);
        Element e = super.createConfigurationElement(doc);
        e.setAttribute(ATT_ConditionAlias, this.getAlias());
        e.setAttribute(ATT_DataTypeList, Boolean.toString(isDataTypeList));
        e.setAttribute(ATT_DataType, dataTypeString);
        return e;
    }

    private String getDataTypeString(boolean isDataTypeList) {
        String dataTypeString;
        if (isDataTypeList) {
            Object[] dataTypeArray = (Object[])this.myDataTypeArray.getValueObject();
            dataTypeString = StringUtil.join(dataTypeArray, ",");
        } else {
            dataTypeString = this.myDataTypeDropDown.toString();
        }
        return dataTypeString;
    }

    public List<String> getDataTypeNames() {
        ArrayList<String> types = new ArrayList<String>();
        boolean isDataTypeList = VarListUtil.getBooleanValueForName(this.myVarList, LABEL_DATATYPE_LIST);
        if (isDataTypeList) {
            Object[] dataTypeArray;
            for (Object dt : dataTypeArray = (Object[])this.myDataTypeArray.getValueObject()) {
                types.add(dt.toString().trim());
            }
        } else {
            String dataTypeString = this.myDataTypeDropDown.toString().trim();
            types.add(dataTypeString);
        }
        return types;
    }

    @Override
    protected ImageIcon getNodeIcon(boolean expanded) {
        String icon = this.getReferrers().size() > 0 ? LOCKED_ICON : ICON;
        return RmaDefs.getImageIcon(icon);
    }

    private void setReadOnly(boolean isReadOnly) {
        VarListUtil.getVariableForName(this.myVarList, "Name").setAllowEdit(!isReadOnly);
        VarListUtil.getVariableForName(this.myVarList, "Alias").setAllowEdit(!isReadOnly);
        this.updateTableModel();
    }

    @Override
    public void addReferrer(AbstractTreeNode referrer) {
        super.addReferrer(referrer);
        if (this.getReferrers().size() == 1) {
            this.setReadOnly(true);
        }
    }

    @Override
    public void removeReferrer(AbstractTreeNode referrer) {
        super.removeReferrer(referrer);
        if (this.getReferrers().size() == 0) {
            this.setReadOnly(false);
        }
    }

    @Override
    public void setDataItem(Object reference, Object object) {
        if (LABEL_DATATYPE_LIST.equals(reference)) {
            this.setVariablesForDataType();
        }
        super.setDataItem(reference, object);
    }

    @Override
    public String getAlias() {
        return this.getVariableString("Alias");
    }
}

