/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.swing.TreeModelMonitor;
import com.ericsson.ere.util.CountedObjectRepository;
import com.ericsson.ere.util.CountedObjectRepositoryListener;
import com.ericsson.ere.variable.UniqueStringVariable;
import com.ericsson.vareditor.document.ClassNameDocument;
import com.ericsson.vareditor.document.LimitLeadingAndTrailingSpacesStringDocument;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import javax.swing.tree.DefaultTreeModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class AbstractPluginTM
extends AbstractTreeNode {
    protected static final String LABEL_NAME = "Name";
    protected static final String LABEL_COMMENT = "Comment";
    protected static final String LABEL_PROFILE = "Profile";
    protected static final String LABEL_CLASS = "Class";
    protected static final String LABEL_ALIAS = "Alias";
    private static final String ATT_NAME = "name";
    private static final String ATT_COMMENT = "comment";
    private static final String ATT_PROFILE = "profile";
    private static final String ATT_CLASS = "class";
    private String myTagName;

    protected AbstractPluginTM(String tagName, CountedObjectRepository<String> nameRepository) {
        this(tagName, null, nameRepository);
    }

    protected AbstractPluginTM(String tagName, NamedNodeMap attributes, CountedObjectRepository<String> nameRepository) {
        this.myTagName = tagName;
        this.setupVarList(this.wrapRepository(nameRepository));
        if (attributes != null) {
            String nameStr = XMLUtil.getAttributeValue(attributes, ATT_NAME, "");
            String commentString = XMLUtil.getAttributeValue(attributes, ATT_COMMENT, "");
            String profileStr = XMLUtil.getAttributeValue(attributes, ATT_PROFILE, "");
            String classStr = XMLUtil.getAttributeValue(attributes, ATT_CLASS, "");
            VarListUtil.getVariableForName(this.myVarList, LABEL_NAME).setValue(nameStr);
            VarListUtil.getVariableForName(this.myVarList, LABEL_COMMENT).setValue(commentString);
            VarListUtil.getVariableForName(this.myVarList, LABEL_CLASS).setValue(classStr);
            VarListUtil.getVariableForName(this.myVarList, LABEL_PROFILE).setValue(profileStr);
        }
    }

    private CountedObjectRepository<String> wrapRepository(CountedObjectRepository<String> nameRepository) {
        return nameRepository != null ? new NameAliasRepository(nameRepository) : null;
    }

    protected void setupVarList(CountedObjectRepository<String> nameRepository) {
        this.myVarList.add(new UniqueStringVariable(LABEL_NAME, "", nameRepository, new LimitLeadingAndTrailingSpacesStringDocument(false)));
        this.myVarList.add(new MultilineStringVariable(LABEL_COMMENT, ""));
        this.myVarList.add(new StringVariable(LABEL_CLASS, "", new ClassNameDocument(this.createRulesForClass())));
        this.myVarList.add(new StringVariable(LABEL_PROFILE, "", new ClassNameDocument(this.createRulesForProfile())));
    }

    protected void addAliasVariable(CountedObjectRepository<String> nameRepository) {
        UniqueStringVariable aliasVar = new UniqueStringVariable(LABEL_ALIAS, "", nameRepository, new LimitLeadingAndTrailingSpacesStringDocument(true), "^$");
        VarListUtil.insertVariableAfterLabel(this.myVarList, LABEL_NAME, aliasVar);
    }

    protected ClassNameDocument.ClassRules createRulesForClass() {
        return ClassNameDocument.ClassRules.defaultRules().andDisallowEmptyName();
    }

    protected ClassNameDocument.ClassRules createRulesForProfile() {
        return ClassNameDocument.ClassRules.defaultRules().andDisallowEmptyName();
    }

    @Override
    public void setTreeModel(DefaultTreeModel m) {
        boolean hadNoModel = this.getTreeModel() == null;
        super.setTreeModel(m);
        if (hadNoModel) {
            new TreeModelMonitor(m, this).onRemove(new Runnable(){

                @Override
                public void run() {
                    ((UniqueStringVariable)VarListUtil.getVariableForName(AbstractPluginTM.this.myVarList, AbstractPluginTM.LABEL_NAME)).detachFromRepository();
                    Variable aliasVar = VarListUtil.getVariableForName(AbstractPluginTM.this.myVarList, AbstractPluginTM.LABEL_ALIAS);
                    if (aliasVar != null) {
                        ((UniqueStringVariable)aliasVar).detachFromRepository();
                    }
                }
            }).onInsert(new Runnable(){

                @Override
                public void run() {
                    ((UniqueStringVariable)VarListUtil.getVariableForName(AbstractPluginTM.this.myVarList, AbstractPluginTM.LABEL_NAME)).attachToRepository();
                    Variable aliasVar = VarListUtil.getVariableForName(AbstractPluginTM.this.myVarList, AbstractPluginTM.LABEL_ALIAS);
                    if (aliasVar != null) {
                        ((UniqueStringVariable)aliasVar).attachToRepository();
                    }
                }
            });
        }
    }

    public abstract String getAlias();

    @Override
    public String getName() {
        return this.getVariableString(LABEL_NAME);
    }

    public String getProfileClassName() {
        return this.getVariableString(LABEL_PROFILE);
    }

    public String getTrafficClassName() {
        return this.getVariableString(LABEL_CLASS);
    }

    @Override
    protected Element createConfigurationElement(Document doc) {
        Element e = doc.createElement(this.myTagName);
        e.setAttribute(ATT_NAME, this.getVariableString(LABEL_NAME));
        e.setAttribute(ATT_COMMENT, XMLUtil.unEscape(this.getVariableString(LABEL_COMMENT)));
        e.setAttribute(ATT_CLASS, this.getVariableString(LABEL_CLASS));
        e.setAttribute(ATT_PROFILE, this.getVariableString(LABEL_PROFILE));
        return e;
    }

    protected String getVariableString(String label) {
        Variable var = VarListUtil.getVariableForName(this.myVarList, label);
        return var != null ? var.toString().trim() : null;
    }

    @Override
    public String toString() {
        String ret = this.getAlias();
        if (StringUtil.isEmptyString(ret)) {
            ret = this.getName();
        }
        ret = StringUtil.isEmptyString(ret) ? "[Unnamed]" : ret;
        return ret;
    }

    private class NameAliasRepository
    implements CountedObjectRepository<String> {
        private CountedObjectRepository<String> myInnerRepository;

        NameAliasRepository(CountedObjectRepository<String> inner) {
            this.myInnerRepository = inner;
        }

        @Override
        public void add(String object, Object owner) {
            this.myInnerRepository.add(object, owner);
        }

        @Override
        public boolean remove(String object, Object owner) {
            return this.myInnerRepository.remove(object, owner);
        }

        @Override
        public int getReferenceCount(String object) {
            String alias = AbstractPluginTM.this.getAlias();
            int refCount = this.myInnerRepository.getReferenceCount(object);
            if (!StringUtil.isEmptyString(alias) && alias.equals(AbstractPluginTM.this.getName())) {
                --refCount;
            }
            return refCount;
        }

        @Override
        public void addRepositoryListener(CountedObjectRepositoryListener<String> listener) {
            this.myInnerRepository.addRepositoryListener(listener);
        }

        @Override
        public void removeRepositoryListener(CountedObjectRepositoryListener<String> listener) {
            this.myInnerRepository.removeRepositoryListener(listener);
        }
    }
}

