/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.plugins;

import com.ericsson.ere.gui.editors.serviceeditor.NameRepositories;
import com.ericsson.ere.gui.editors.serviceeditor.ServiceEditorTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.TreeNodeChangeTracker;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.AbstractPluginTM;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.AbstractPluginTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.BaseConditionTM;
import com.ericsson.ere.util.Predicate;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class PluginsTreeModel
extends ServiceEditorTreeModel {
    public PluginsTreeModel(AbstractPluginTM root, NameRepositories repositories) {
        super(root);
        root.setTreeModel(this);
        new TreeNodeChangeTracker(this);
    }

    public AbstractTreeNode addNodeAsChild(TreePath parentPath, AbstractTreeNode childNode) {
        AbstractTreeNode parentNode = (AbstractTreeNode)parentPath.getLastPathComponent();
        int index = parentNode.getChildCount();
        if (parentNode != this.getRoot()) {
            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                AbstractTreeNode currentChild = (AbstractTreeNode)parentNode.getChildAt(i);
                if (currentChild.getName().compareTo(childNode.getName()) <= 0) continue;
                index = i;
                break;
            }
        }
        this.insertNodeInto(childNode, parentNode, index);
        childNode.setTreeModel(this);
        return childNode;
    }

    public AbstractPluginTM addNewTMNode(TreePath treePath) {
        DefaultMutableTreeNode childNode;
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        this.checkParentNode(parentNode);
        boolean isContainerNode = parentNode.getLevel() == 1;
        int index = 0;
        if (!isContainerNode) {
            childNode = parentNode;
            parentNode = (DefaultMutableTreeNode)parentNode.getParent();
            index = parentNode.getIndex(childNode) + 1;
        }
        assert (parentNode instanceof AbstractPluginTreeNode);
        childNode = ((AbstractPluginTreeNode)parentNode).createChildNode();
        this.insertNodeInto(childNode, parentNode, index);
        ((AbstractPluginTM)childNode).setTreeModel(this);
        return childNode;
    }

    public BaseConditionTM findBaseCondition(String name) {
        List<AbstractTreeNode> nodes = this.findNodes(new BaseConditionFinder(name));
        return (BaseConditionTM)(nodes.isEmpty() ? null : nodes.get(0));
    }

    private void checkParentNode(DefaultMutableTreeNode parentNode) {
        if (parentNode.isRoot()) {
            throw new IllegalArgumentException("Cannot add a new TM node to the root.");
        }
    }

    private static class BaseConditionFinder
    implements Predicate<AbstractTreeNode> {
        private String myName;

        BaseConditionFinder(String name) {
            this.myName = name;
        }

        @Override
        public boolean test(AbstractTreeNode node) {
            return node instanceof BaseConditionTM && this.myName.equals(node.getName());
        }
    }
}

