/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.plugins;

import com.ericsson.ere.gui.editors.serviceeditor.ServiceEditorInternalFrame;
import com.ericsson.ere.gui.editors.serviceeditor.ServiceEditorTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.ServiceEditorTreeRenderer;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.PluginsTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.AbstractPluginTM;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.BaseConditionDefinitionNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.BaseConditionTM;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.FieldStructureBaseConditionDefinitionNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.FieldStructureBaseConditionTM;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.GenericConditionDefinitionNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.GenericConditionTM;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.ModifierNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.ModifierTM;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.NodesNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.NodesTM;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.ServiceDefinitionTM;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.TariffstructuresNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.TariffstructuresTM;
import com.ericsson.ere.gui.editors.serviceeditor.xmlprinters.PrintPlugins;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DefaultDialogFactory;
import ericsson.ere.gui.util.DialogFactoryInterface;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.RmaAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class PluginsTree
extends JTree
implements MouseListener {
    private static final String BASE_CONDITION_LOCKED_FMT = "The Base Condition '%1$s' is locked for deletion.\n'%1$s' is in use in the Service definition.";
    static final String LBL_ADD_TARIFF_STRUCTURE = "Add Tariff Structure";
    static final String LBL_ADD_NODE = "Add Node";
    static final String LBL_ADD_BASE_CONDITION = "Add Base Condition";
    static final String LBL_ADD_HIERARCHICAL_BASE_CONDITION = "Add Hierarchical Base Condition";
    static final String LBL_ADD_GENERIC_CONDITION = "Add Generic Condition";
    static final String LBL_ADD_MODIFIER = "Add Modifier";
    static final String LBL_DELETE = "Delete";
    static final String LBL_PRINT_CLASS = "Print Class";
    static final String LBL_PRINT_STRUCTURE = "Print Structure";
    static final String LBL_MOVE_UP = "Move Up";
    static final String LBL_MOVE_DOWN = "Move Down";
    private Action myAddNodeAction;
    private Action myDeleteAction;
    private Action myImportAction;
    private Action mySaveAction;
    private Action myExportAction;
    private Action myMoveUpAction;
    private Action myMoveDownAction;
    private JPopupMenu myPopupMenu;
    private JMenuItem myPrintClassName;
    private JMenuItem myPrintStructure;
    private JMenuItem myAddNode;
    private JMenuItem mySaveToFile;
    private PluginsTreeModel myTreeModel;
    private DialogFactoryInterface myDialogFactory = new DefaultDialogFactory();

    public PluginsTree(PluginsTreeModel model, Map<String, Action> commonActions) {
        super(model);
        this.myTreeModel = model;
        this.setCellRenderer(new ServiceEditorTreeRenderer());
        this.getSelectionModel().setSelectionMode(1);
        this.addListenerToTree();
        this.addMouseListener(this);
        GuiUtil.disableRootCollapse(this);
        GuiUtil.enableSelectionOnRightClick(this);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.myAddNodeAction = new RmaAction(this, "addNodeAction", LBL_ADD_NODE, null, "Adds a new node after the currently selected node", KeyStroke.getKeyStroke(78, 2));
        this.myDeleteAction = new RmaAction(this, "deleteAction", LBL_DELETE, null, "Delete the currently selected item", KeyStroke.getKeyStroke(127, 0));
        this.myImportAction = commonActions.get(ServiceEditorInternalFrame.ACTION_KEY_IMPORT);
        this.mySaveAction = commonActions.get(ServiceEditorInternalFrame.ACTION_KEY_SAVE);
        this.myExportAction = commonActions.get(ServiceEditorInternalFrame.ACTION_KEY_EXPORT);
        this.myMoveUpAction = new RmaAction(this, "moveUpAction", LBL_MOVE_UP, "Up16.gif", "Move the current selection one step up", KeyStroke.getKeyStroke(38, 2));
        this.myMoveDownAction = new RmaAction(this, "moveDownAction", LBL_MOVE_DOWN, "Down16.gif", "Move the current selection one step down", KeyStroke.getKeyStroke(40, 2));
        this.myPopupMenu = this.createPopupMenu();
        ActionMap am = this.getActionMap();
        am.put("addNodeAction", this.myAddNodeAction);
        am.put("delete", this.myDeleteAction);
        am.put("moveUp", this.myMoveUpAction);
        am.put("moveDown", this.myMoveDownAction);
        KeyStroke key = null;
        InputMap im2 = this.getInputMap(2);
        for (InputMap im2 : new InputMap[]{this.getInputMap(1), this.getInputMap()}) {
            key = (KeyStroke)this.myAddNodeAction.getValue("AcceleratorKey");
            im2.put(key, "addNodeAction");
            key = (KeyStroke)this.myDeleteAction.getValue("AcceleratorKey");
            im2.put(key, "delete");
            key = (KeyStroke)this.myMoveUpAction.getValue("AcceleratorKey");
            im2.put(key, "moveUp");
            key = (KeyStroke)this.myMoveDownAction.getValue("AcceleratorKey");
            im2.put(key, "moveDown");
        }
        GuiServiceCenter.getInstance().enableHelpKey(this, this.getClass().toString(), null);
        this.setName("PluginsTree");
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setDialogFactory(DialogFactoryInterface dialogFactory) {
        this.myDialogFactory = dialogFactory;
    }

    public DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.getModel().getRoot();
    }

    private void addListenerToTree() {
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PluginsTree.this.enablePopupMenu(true);
            }
        });
    }

    public void addNodeAction(ActionEvent evt) {
        TreePath parentPath = this.getSelectionPath();
        if (parentPath.getLastPathComponent() != this.getRootNode()) {
            AbstractPluginTM newChild = this.myTreeModel.addNewTMNode(parentPath);
            this.setSelectionPath(new TreePath(newChild.getPath()));
        }
    }

    public void deleteAction(ActionEvent evt) {
        boolean isContainerNode;
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        boolean bl = isContainerNode = selectedNode.getLevel() == 1;
        if (!isContainerNode) {
            this.deleteNode(selectedNode);
        }
    }

    public void moveUpAction(ActionEvent evt) {
        this.moveUpOrDown(true);
    }

    public void moveDownAction(ActionEvent evt) {
        this.moveUpOrDown(false);
    }

    protected DefaultMutableTreeNode getSelectedNode() {
        TreePath selPath = this.getSelectionPath();
        if (selPath != null) {
            return (DefaultMutableTreeNode)selPath.getLastPathComponent();
        }
        return null;
    }

    private void enablePopupMenu(boolean clickedInTree) {
        DefaultMutableTreeNode tmpTreeNode = this.getSelectedNode();
        this.myAddNodeAction.setEnabled(true);
        this.myDeleteAction.setEnabled(false);
        this.myImportAction.setEnabled(true);
        this.mySaveAction.setEnabled(true);
        this.myExportAction.setEnabled(true);
        this.myMoveUpAction.setEnabled(false);
        this.myMoveDownAction.setEnabled(false);
        if (this.hideAddNode(clickedInTree, tmpTreeNode)) {
            if (this.myPopupMenu.getComponent(0).equals(this.myAddNode)) {
                this.myPopupMenu.remove(0);
                this.myPopupMenu.remove(0);
            }
        } else if (!this.myPopupMenu.getComponent(0).equals(this.myAddNode)) {
            this.myPopupMenu.insert(this.myAddNode, 0);
            this.myPopupMenu.insert(new JSeparator(), 1);
        }
        if (tmpTreeNode == null || !clickedInTree) {
            return;
        }
        if (tmpTreeNode instanceof BaseConditionDefinitionNode || tmpTreeNode instanceof BaseConditionTM) {
            this.myAddNode.setText(LBL_ADD_BASE_CONDITION);
        }
        if (tmpTreeNode instanceof GenericConditionDefinitionNode || tmpTreeNode instanceof GenericConditionTM) {
            this.myAddNode.setText(LBL_ADD_GENERIC_CONDITION);
        }
        if (tmpTreeNode instanceof ModifierNode || tmpTreeNode instanceof ModifierTM) {
            this.myAddNode.setText(LBL_ADD_MODIFIER);
        }
        if (tmpTreeNode instanceof NodesNode || tmpTreeNode instanceof NodesTM) {
            this.myAddNode.setText(LBL_ADD_NODE);
        }
        if (tmpTreeNode instanceof FieldStructureBaseConditionDefinitionNode || tmpTreeNode instanceof FieldStructureBaseConditionTM) {
            this.myAddNode.setText(LBL_ADD_HIERARCHICAL_BASE_CONDITION);
        }
        if (tmpTreeNode instanceof BaseConditionTM || tmpTreeNode instanceof GenericConditionTM || tmpTreeNode instanceof ModifierTM || tmpTreeNode instanceof NodesTM || tmpTreeNode instanceof FieldStructureBaseConditionTM) {
            this.myDeleteAction.setEnabled(true);
            this.myMoveUpAction.setEnabled(true);
            this.myMoveDownAction.setEnabled(true);
        }
    }

    private boolean hideAddNode(boolean clickedInTree, DefaultMutableTreeNode tmpTreeNode) {
        return tmpTreeNode instanceof ServiceDefinitionTM || tmpTreeNode == null || tmpTreeNode instanceof TariffstructuresNode || tmpTreeNode instanceof TariffstructuresTM || !clickedInTree;
    }

    private void enableMenuExtensions(MouseEvent e, boolean clickedInTree) {
        boolean foundExtensions = false;
        boolean extendedTrigger = e.isShiftDown() && e.isControlDown();
        for (int i = 0; i < this.myPopupMenu.getComponentCount(); ++i) {
            if (this.myPopupMenu.getComponent(i) != this.myPrintClassName) continue;
            foundExtensions = true;
        }
        if (foundExtensions && !extendedTrigger) {
            this.myPopupMenu.remove(this.myPopupMenu.getComponentIndex(this.myPrintStructure) + 1);
            this.myPopupMenu.remove(this.myPrintClassName);
            this.myPopupMenu.remove(this.myPrintStructure);
        }
        if (!foundExtensions && extendedTrigger) {
            this.myPrintClassName.setEnabled(true);
            this.myPrintStructure.setEnabled(true);
            int lastIndex = this.myPopupMenu.getComponentIndex(this.mySaveToFile) + 1;
            this.myPopupMenu.add((Component)this.myPrintStructure, lastIndex);
            this.myPopupMenu.add((Component)this.myPrintClassName, lastIndex);
            this.myPopupMenu.add((Component)new JPopupMenu.Separator(), lastIndex);
        }
    }

    private void maybeShowPopup(MouseEvent e) {
        boolean clickedInTree = true;
        if (e.isPopupTrigger()) {
            if (this.getRowForLocation(e.getX(), e.getY()) == -1) {
                clickedInTree = false;
            }
            this.enablePopupMenu(clickedInTree);
            this.enableMenuExtensions(e, clickedInTree);
            this.myPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private JPopupMenu createPopupMenu() {
        this.myAddNodeAction.setEnabled(true);
        this.myDeleteAction.setEnabled(false);
        this.myImportAction.setEnabled(true);
        this.mySaveAction.setEnabled(true);
        this.myExportAction.setEnabled(true);
        this.myMoveUpAction.setEnabled(false);
        this.myMoveDownAction.setEnabled(false);
        JPopupMenu tmpPopupMenu = new JPopupMenu();
        this.myAddNode = new JMenuItem(this.myAddNodeAction);
        this.myAddNode.setName("PluginsTree.menu.add-condition");
        tmpPopupMenu.add(this.myDeleteAction).setName("PluginsTree.menu.delete-condition");
        tmpPopupMenu.addSeparator();
        tmpPopupMenu.add(this.myImportAction);
        tmpPopupMenu.add(this.mySaveAction).setName("PluginsTree.menu.save-service");
        tmpPopupMenu.add(this.myExportAction);
        tmpPopupMenu.addSeparator();
        this.myPrintClassName = tmpPopupMenu.add(new PrintClassAction());
        this.myPrintStructure = tmpPopupMenu.add(new PrintStructureAction());
        tmpPopupMenu.addSeparator();
        tmpPopupMenu.add(this.myMoveUpAction);
        tmpPopupMenu.add(this.myMoveDownAction);
        return tmpPopupMenu;
    }

    private void deleteNode(DefaultMutableTreeNode selected) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selected.getParent();
        boolean isOkToDelete = this.myDialogFactory.getQuestionDialog(this, RmaDefs.getStringResource("ratingrules.questions.confirmDelete.title"), RmaDefs.getStringResource("ratingrules.questions.confirmDelete.msg"));
        if (isOkToDelete) {
            TreePath thePath = new TreePath(parent.getPath());
            try {
                this.myTreeModel.removeNodeFromParent(selected);
                this.scrollPathToVisible(thePath);
                this.setSelectionPath(thePath);
            }
            catch (ServiceEditorTreeModel.RemovalOfLinkTargetsNotPermittedException ex) {
                String txt = String.format(BASE_CONDITION_LOCKED_FMT, selected);
                this.myDialogFactory.getErrorDialog("Delete not allowed", txt);
            }
        }
    }

    private void moveUpOrDown(boolean up) {
        int newIndex = -1;
        DefaultMutableTreeNode currentNode = this.getSelectedNode();
        if (currentNode == null) {
            return;
        }
        DefaultMutableTreeNode theParent = (DefaultMutableTreeNode)currentNode.getParent();
        if (up && theParent.getIndex(currentNode) > 0) {
            newIndex = theParent.getIndex(currentNode) - 1;
        } else if (!up && theParent.getIndex(currentNode) < theParent.getChildCount() - 1) {
            newIndex = theParent.getIndex(currentNode) + 1;
        }
        if (newIndex >= 0) {
            this.myTreeModel.removeNodeFromParent(currentNode);
            this.myTreeModel.insertNodeInto(currentNode, theParent, newIndex);
            this.scrollPathToVisible(new TreePath(currentNode.getPath()));
            this.setSelectionPath(new TreePath(currentNode.getPath()));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    private class PrintStructureAction
    extends AbstractAction {
        PrintStructureAction() {
            this.putValue("Name", PluginsTree.LBL_PRINT_STRUCTURE);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                System.out.println(PrintPlugins.print(PluginsTree.this.getRootNode()));
            }
            catch (Exception e) {
                RmaDefs.loggerServiceDefinition.warning("Error printing Repository " + e.getMessage());
            }
        }
    }

    private class PrintClassAction
    extends AbstractAction {
        PrintClassAction() {
            this.putValue("Name", PluginsTree.LBL_PRINT_CLASS);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println("Class Name for node " + PluginsTree.this.getSelectedNode().getClass());
        }
    }
}

