/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.AbstractInputRestriction;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.InputRestrictionType;
import ericsson.ere.datatype.DataType;
import ericsson.vareditor.variable.RangeObject;
import ericsson.vareditor.variable.RangeVariable;
import ericsson.vareditor.variable.Variable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RangeInputRestriction
extends AbstractInputRestriction<RangeObject> {
    private static final String LABEL_RANGE = "Range";
    static final String TAG_RANGE = "Range";
    private static final String ATTR_RANGE_MIN = "min";
    private static final String ATTR_RANGE_MAX = "max";
    private static final String TYPE_RANGE = "Range";
    private final RangeObject myValue;
    private final DataType myValueType;

    public RangeInputRestriction(RangeObject range, DataType valueType) {
        super("Range");
        this.myValue = range;
        this.myValueType = valueType;
    }

    public RangeInputRestriction(NodeList rangeList, DataType valueType) {
        super("Range");
        Element last = (Element)rangeList.item(rangeList.getLength() - 1);
        String min = last.getAttribute(ATTR_RANGE_MIN);
        String max = last.getAttribute(ATTR_RANGE_MAX);
        this.myValue = new RangeObject(valueType.isIntegerNumeric(), min, max);
        this.myValueType = valueType;
    }

    @Override
    public RangeObject getValueObject() {
        return this.myValue;
    }

    @Override
    public void appendTypeXML(Element root) {
        Element range = root.getOwnerDocument().createElement("Range");
        range.setAttribute(ATTR_RANGE_MIN, this.myValue.getMinValue());
        range.setAttribute(ATTR_RANGE_MAX, this.myValue.getMaxValue());
        root.appendChild(range);
    }

    @Override
    public Variable createVariable() {
        return new RangeVariable("Range", this.myValueType.getTypeName(), this.myValue.getMinValue(), this.myValue.getMaxValue(), true);
    }

    @Override
    public InputRestrictionType getType() {
        return InputRestrictionType.RANGE;
    }
}

