/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils;

import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.AbstractInputRestriction;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.InputRestrictionType;
import ericsson.ere.datatype.DataType;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.ArrayVariable;
import ericsson.vareditor.variable.Variable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EnumerationInputRestriction
extends AbstractInputRestriction<Object[]> {
    private static final String LABEL_ENUM_NAME = "Name";
    private static final String LABEL_ENUM_VALUE = "Value";
    private static final String LABEL_ENUM = "Enumeration";
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Value"};
    static final String TAG_ENUM = "Enum";
    private static final String ATTR_ENUM_NAME = "name";
    private static final String ATTR_ENUM_VALUE = "value";
    private static final String TYPE_ENUM = "Enum";
    private final Object[] myValue;
    private final DataType myValueType;

    public EnumerationInputRestriction(Object[] theData, DataType valueType) {
        super("Enum");
        this.myValue = theData;
        this.myValueType = valueType;
    }

    public EnumerationInputRestriction(NodeList enumList, DataType valueType) {
        super("Enum");
        Object[] enumArray = new Object[2];
        String[] names = new String[enumList.getLength()];
        Object[] values = valueType.createArray(enumList.getLength());
        for (int i = 0; i < enumList.getLength(); ++i) {
            Element e = (Element)enumList.item(i);
            names[i] = e.getAttribute(ATTR_ENUM_NAME);
            values[i] = valueType.parseValue(e.getAttribute(ATTR_ENUM_VALUE));
        }
        enumArray[0] = names;
        enumArray[1] = values;
        this.myValue = enumArray;
        this.myValueType = valueType;
    }

    @Override
    public Object[] getValueObject() {
        return this.myValue;
    }

    @Override
    public void appendTypeXML(Element root) {
        if (this.myValue != null && this.myValue.length == 2) {
            String[] names = (String[])this.myValue[0];
            Object[] values = (Object[])this.myValue[1];
            for (int row = 0; row < names.length; ++row) {
                Element enm = root.getOwnerDocument().createElement("Enum");
                enm.setAttribute(ATTR_ENUM_NAME, names[row]);
                enm.setAttribute(ATTR_ENUM_VALUE, this.myValueType.makeParseableString(values[row]));
                root.appendChild(enm);
            }
        }
    }

    @Override
    public Variable createVariable() {
        ArrayVariable var = new ArrayVariable(LABEL_ENUM, new ArrayModel(this.myValue, COLUMN_NAMES), (ValueResolver)this.myValueType);
        var.setAllowEmpty(false);
        return var;
    }

    @Override
    public InputRestrictionType getType() {
        return InputRestrictionType.ENUMERATION;
    }
}

