/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.InputRestriction;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.InputRestrictionType;
import com.ericsson.vareditor.document.ClassNameDocument;
import ericsson.ere.gui.interfaces.SimulationEditor;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.util.StringUtil;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.Variable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CustomEditorInputRestriction
implements InputRestriction<String> {
    private static final String LABEL_EDITOR_CLASS = "Editor class";
    private String myClassName;

    public CustomEditorInputRestriction(String className) {
        this.myClassName = className;
    }

    @Override
    public String getValueObject() {
        return this.myClassName;
    }

    @Override
    public void appendXML(Node parent) {
        if (!StringUtil.isEmptyString(this.myClassName)) {
            Element editComponent = parent.getOwnerDocument().createElement("EditComponent");
            editComponent.setAttribute("class", this.myClassName);
            parent.appendChild(editComponent);
        }
    }

    @Override
    public Variable createVariable() {
        String value = this.myClassName != null ? this.myClassName : "";
        return new StringVariable(LABEL_EDITOR_CLASS, value, new ClassNameDocument(ClassNameDocument.ClassRules.defaultRules().andRequireSuperTypes(SimulationEditor.class, XMLInitializable.class)));
    }

    @Override
    public InputRestrictionType getType() {
        return InputRestrictionType.NO_DATA;
    }
}

