/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.CommonFieldsGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.ContextFieldsGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldConfig;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldNode;
import com.ericsson.ere.swing.TreeModelMonitor;
import com.ericsson.ere.util.CountedObjectRepository;
import com.ericsson.ere.util.CountedObjectRepositoryImpl;
import com.ericsson.ere.variable.UniqueStringVariable;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.DefaultDialogFactory;
import ericsson.ere.gui.util.DialogFactoryInterface;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.documents.RegularExpressionMatcherDocument;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class HierarchicalFieldNode
extends AbstractTreeNode
implements PropertyChangeListener {
    private static final String DOCUMENT_REGEXP = "[^<>'&;/%\\:\"]*";
    private static final long serialVersionUID = 412394247895341092L;
    private static final String ATTR_COMPLEX_TYPE = "ComplexType";
    private static final String TAG_FIELDSTRUCTURE = "FieldStructure";
    private static final String LABEL_NAME = "Name";
    private static final String ATTR_NAME = "Name";
    private static final String LABEL_AUTOMAP_CONDITION = "Show in plugins";
    private static final String ATTR_AUTOMAP_CONDITION = "AutoConditionMap";
    private static final String LABEL_TOOLTIP = "Tooltip";
    private static final String ATTR_TOOLTIP = "Tooltip";
    private static final ImageIcon ICON = RmaDefs.getImageIcon("cubes_blue.png");
    public static final String DEFAULT_NAME = "[Unnamed]";
    private static final boolean DEFAULT_SHOW_IN_PLUGINS = true;
    public static final String LABEL_COMPLEX_TYPE = "Collection";
    public static final String LABEL_ERROR = "Error";
    private final CountedObjectRepository<String> myFieldNameRepository = new CountedObjectRepositoryImpl<String>();
    private final CountedObjectRepository<String> myParentNameRepository;
    private FieldConfig.ComplexType myComplexType;
    private AbstractTreeNode myParent;
    private DialogFactoryInterface myDialogFactory = new DefaultDialogFactory();

    public HierarchicalFieldNode(AbstractTreeNode parent, CountedObjectRepository<String> parentNameRepository, Element element) {
        this.myParentNameRepository = parentNameRepository;
        this.myParent = parent;
        if (element == null) {
            this.createVariables(null);
        } else {
            this.createVariables(element.getAttributes());
        }
    }

    private void createVariables(NamedNodeMap attributes) {
        String name = XMLUtil.getAttributeValue(attributes, "Name", DEFAULT_NAME);
        UniqueStringVariable nameVar = new UniqueStringVariable("Name", name, this.myParentNameRepository, new RegularExpressionMatcherDocument(DOCUMENT_REGEXP, false));
        this.myVarList.add(nameVar);
        String complexAttr = XMLUtil.getAttributeValue(attributes, ATTR_COMPLEX_TYPE, FieldConfig.ComplexType.NONE.toString());
        this.myComplexType = FieldConfig.ComplexType.valueOf(complexAttr);
        DropDownVariable dropDown = new DropDownVariable(LABEL_COMPLEX_TYPE, (Object)this.myComplexType, (Object[])FieldConfig.ComplexType.values());
        this.myVarList.add(dropDown);
        String showInPluginsAttr = XMLUtil.getAttributeValue(attributes, ATTR_AUTOMAP_CONDITION, String.valueOf(true));
        this.myVarList.add(new BoolVariable(LABEL_AUTOMAP_CONDITION, Boolean.valueOf(showInPluginsAttr)));
        String tooltip = XMLUtil.getAttributeValue(attributes, "Tooltip", "");
        this.myVarList.add(new StringVariable("Tooltip", tooltip));
        if (!(this.myParent instanceof CommonFieldsGroupNode) && !(this.myParent instanceof ContextFieldsGroupNode)) {
            dropDown.setAllowEdit(false);
        }
        this.checkFields();
    }

    private void checkFields() {
        VarListUtil.removeVariablesByLabel((List<Variable>)this.myVarList, LABEL_ERROR);
        if (this.getComplexType() == FieldConfig.ComplexType.MAP) {
            boolean hasKeyField = false;
            for (int i = 0; !hasKeyField && i < this.getChildCount(); ++i) {
                TreeNode child = this.getChildAt(i);
                if (!(child instanceof FieldNode) || !((FieldNode)child).isKey()) continue;
                hasKeyField = true;
            }
            if (!hasKeyField) {
                this.myVarList.add(new NotAllowedVariable(LABEL_ERROR, "This MAP hierarchical field must have at least one key field."));
            }
        } else if (this.getChildCount() < 1) {
            this.myVarList.add(new NotAllowedVariable(LABEL_ERROR, "There must be at least one field in this hierarchical field."));
        }
    }

    @Override
    protected ImageIcon getNodeIcon(boolean expanded) {
        return ICON;
    }

    @Override
    public String getName() {
        return VarListUtil.getStringValueForName(this.myVarList, "Name");
    }

    @Override
    public String toString() {
        String name = this.getName();
        if (this.getComplexType() != FieldConfig.ComplexType.NONE) {
            name = name + " (" + this.getComplexType().toString() + ")";
        }
        return name;
    }

    private String getToolTip() {
        return VarListUtil.getStringValueForName(this.myVarList, "Tooltip");
    }

    public FieldConfig.ComplexType getComplexType() {
        return (FieldConfig.ComplexType)((Object)VarListUtil.getValueForName(this.myVarList, LABEL_COMPLEX_TYPE));
    }

    public boolean shouldShowInPlugins() {
        return (Boolean)VarListUtil.getValueForName(this.myVarList, LABEL_AUTOMAP_CONDITION);
    }

    @Override
    protected Element createConfigurationElement(Document doc) {
        Element element = doc.createElement(TAG_FIELDSTRUCTURE);
        element.setAttribute("Name", this.getName());
        element.setAttribute(ATTR_COMPLEX_TYPE, this.getComplexType().name());
        element.setAttribute(ATTR_AUTOMAP_CONDITION, String.valueOf(this.shouldShowInPlugins()));
        String toolTip = this.getToolTip();
        if (!StringUtil.isEmptyString(toolTip)) {
            element.setAttribute("Tooltip", toolTip);
        }
        return element;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.checkFields();
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        if (this.getComplexType() == FieldConfig.ComplexType.MAP) {
            AbstractTreeNode node = (AbstractTreeNode)newChild;
            node.addPropertyChangeListener(this);
        }
        super.insert(newChild, childIndex);
        this.checkFields();
    }

    @Override
    public void remove(int childIndex) {
        AbstractTreeNode node = (AbstractTreeNode)this.getChildAt(childIndex);
        node.removePropertyChangeListener(this);
        super.remove(childIndex);
        this.checkFields();
    }

    public CountedObjectRepository<String> getFieldNameRepository() {
        return this.myFieldNameRepository;
    }

    @Override
    public void setDataItem(Object changingVariableKey, Object changingVariable) {
        FieldConfig.ComplexType newType;
        super.setDataItem(changingVariableKey, changingVariable);
        if (changingVariableKey.equals(LABEL_COMPLEX_TYPE) && (newType = FieldConfig.ComplexType.valueOf(((Variable)changingVariable).getValueObject().toString())) != this.myComplexType) {
            if (this.getChildCount() > 0) {
                if (this.myDialogFactory.getQuestionDialogCustomButtons(null, "Change collection type", "This hierarchical field contains at least one field that will be deleted if the collection type is changed.\n\nDo you want to continue changing the collection type?", "Yes", "No")) {
                    this.removeChildren();
                    this.myComplexType = newType;
                } else {
                    ((Variable)changingVariable).setValue((Object)this.myComplexType);
                }
            } else {
                this.myComplexType = newType;
            }
            VarListUtil.removeVariablesByLabel((List<Variable>)this.myVarList, LABEL_ERROR);
        }
        if (!changingVariableKey.equals("Name") && !changingVariableKey.equals("Tooltip")) {
            this.checkFields();
        }
    }

    public void setDialogFactory(DialogFactoryInterface fact) {
        if (fact == null) {
            throw new IllegalArgumentException("Dialog factory cannot be null.");
        }
        this.myDialogFactory = fact;
    }

    private void removeChildren() {
        DefaultTreeModel model = this.getTreeModel();
        if (model != null) {
            while (this.getChildCount() > 0) {
                model.removeNodeFromParent((MutableTreeNode)this.getChildAt(0));
            }
        }
    }

    @Override
    public void setTreeModel(DefaultTreeModel theModel) {
        super.setTreeModel(theModel);
        new TreeModelMonitor(theModel, this).onRemove(new Runnable(){

            @Override
            public void run() {
                UniqueStringVariable usv = (UniqueStringVariable)VarListUtil.getVariableForName(HierarchicalFieldNode.this.myVarList, "Name");
                usv.detachFromRepository();
            }
        }).onInsert(new Runnable(){

            @Override
            public void run() {
                UniqueStringVariable usv = (UniqueStringVariable)VarListUtil.getVariableForName(HierarchicalFieldNode.this.myVarList, "Name");
                usv.attachToRepository();
            }
        });
    }
}

