/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.ContextDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.FieldsDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.CommonLinkNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.HierarchicalFieldNode;
import ericsson.ere.defs.RmaDefs;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.Variable;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HierarchicalFieldLinkNode
extends CommonLinkNode<HierarchicalFieldNode> {
    public static final String TAG_FIELD_STRUCTURE = "FieldStructure";
    private static final String ATTR_NAME = "Name";
    private static ImageIcon myIcon = RmaDefs.getImageIcon("cubes_blue_link.png");
    private Variable myName;

    public HierarchicalFieldLinkNode(NamedNodeMap attributes) {
        super(HierarchicalFieldLinkNode.extractTargetName(attributes));
        this.initVariables();
    }

    private static String extractTargetName(NamedNodeMap attributes) {
        String name = "[Unnamed]";
        Node nameNode = attributes.getNamedItem(ATTR_NAME);
        if (nameNode != null) {
            name = nameNode.getNodeValue();
        }
        return name;
    }

    public HierarchicalFieldLinkNode(HierarchicalFieldNode aLinkObject) {
        super(aLinkObject);
        this.initVariables();
    }

    private void initVariables() {
        this.myName = new StringVariable(ATTR_NAME, this.getName());
        this.myName.setAllowEdit(false);
        this.myVarList.add(this.myName);
    }

    @Override
    public String getName() {
        return this.myTargetName;
    }

    @Override
    protected Element createConfigurationElement(Document doc) {
        Element e = doc.createElement(TAG_FIELD_STRUCTURE);
        e.setAttribute(ATTR_NAME, this.getName());
        return e;
    }

    @Override
    public ImageIcon getNodeIcon(boolean expanded) {
        return myIcon;
    }

    @Override
    protected HierarchicalFieldNode resolveTarget(DefaultTreeModel model, String name) {
        ContextDefinitionTreeModel cmodel = (ContextDefinitionTreeModel)model;
        FieldsDefinitionTreeModel fieldsModel = cmodel.getFieldsModel();
        return (HierarchicalFieldNode)fieldsModel.findField(name);
    }

    @Override
    protected void onTargetChange(String propertyName) {
        if (ATTR_NAME.equals(propertyName)) {
            this.myName.setValue(this.getName());
        }
    }
}

