/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.CustomEditorInputRestriction;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.InputRestriction;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.InputRestrictionType;
import com.ericsson.ere.interfaces.XMLAppendable;
import ericsson.ere.datatype.DataType;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.ElementIterator;
import ericsson.ere.xml.XMLUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FieldConfig
implements XMLAppendable {
    private static final String TAG_FIELD_SETTINGS = "FieldSettings";
    private static final String TAG_FIELD = "Field";
    private static final String TAG_ALLOW_NEGATIVE_INPUT = "AllowNegativeInput";
    private static final String TAG_AMOUNT_FACTORY_CLASS = "AmountFactoryClass";
    private static final String ATTR_NAME = "Name";
    private static final String ATTR_TAG_NUMBER = "TagNumber";
    private static final String ATTR_AUTOCONDITIONMAP = "AutoConditionMap";
    private static final String ATTR_COMMENT = "Comment";
    private static final String ATTR_VALUE_LIST = "ValueList";
    private static final String ATTR_DATA_TYPE = "DataType";
    private static final String ATTR_PARAMETER_TYPE = "ParameterType";
    private static final String ATTR_MANDATORY = "Mandatory";
    private static final String ATTR_DEFAULT = "Default";
    private static final String ATTR_VALUE_CLASS = "ValueClass";
    private static final String ATTR_VALUE_CLASS_FACTORY = "ValueClassFactory";
    private static final String ATTR_COMPLEX_TYPE = "ComplexType";
    private static final String ATTR_KEY = "KeyField";
    private static final String ATTR_TOOLTIP = "Tooltip";
    private static final String DFLT_NAME = "[Unnamed]";
    private static final DataType DFLT_DATA_TYPE = DataType.STRING;
    private static final boolean DFLT_SHOW_IN_PLUGINS = true;
    private static final String DFLT_PARAMETER_TYPE = "IN";
    private static final boolean DFLT_MANDATORY = false;
    private static final boolean DFLT_ALLOW_NEGATIVE_AMOUNT = true;
    private String myName;
    private DataType myDataType;
    private String myParameterType;
    private String myComment;
    private String myTagNumber;
    private Boolean myMandatory;
    private Boolean myShowInPlugins;
    private ComplexType myComplexType;
    private String myValueClass;
    private String myValueClassFactory;
    private Object[] myDefaultValue;
    private boolean myIsKey;
    private InputRestriction<?> myInputRestriction;
    private Map<String, String> myFieldSettings;
    private final FieldGroupNode.GroupType myGroupType;
    private String myTooltip;

    public FieldConfig(FieldGroupNode.GroupType groupType) {
        this.myGroupType = groupType;
        this.myComplexType = this.complexTypeFromGroupType(groupType);
        this.myFieldSettings = new HashMap<String, String>();
    }

    public FieldConfig(NamedNodeMap attributes, NodeList childNodes, FieldGroupNode.GroupType groupType) {
        this.myGroupType = groupType;
        this.myName = this.readAttributeValue(attributes, ATTR_NAME);
        String key = XMLUtil.getAttributeValue(attributes, ATTR_KEY, "false");
        this.myIsKey = key == null ? false : FieldConfig.parseBooleanNull(key);
        this.myDataType = DataType.lookup(this.readAttributeValue(attributes, ATTR_DATA_TYPE));
        this.myParameterType = this.readParameterType(attributes);
        this.myComment = this.readAttributeValue(attributes, ATTR_COMMENT);
        this.myTagNumber = this.readAttributeValue(attributes, ATTR_TAG_NUMBER);
        this.myMandatory = FieldConfig.parseBooleanNull(this.readAttributeValue(attributes, ATTR_MANDATORY));
        this.myShowInPlugins = FieldConfig.parseBooleanNull(this.readAttributeValue(attributes, ATTR_AUTOCONDITIONMAP));
        this.myComplexType = this.readComplexType(attributes);
        this.myValueClass = this.readAttributeValue(attributes, ATTR_VALUE_CLASS);
        this.myValueClassFactory = this.readAttributeValue(attributes, ATTR_VALUE_CLASS_FACTORY);
        this.myDefaultValue = this.parseDefaultValue(this.readAttributeValue(attributes, ATTR_DEFAULT), this.getDataType(), this.getComplexType());
        this.myFieldSettings = this.readFieldSettings(childNodes);
        this.myInputRestriction = InputRestrictionType.createInputRestriction(childNodes, this.myDataType);
        this.myTooltip = this.readAttributeValue(attributes, ATTR_TOOLTIP);
    }

    private static Boolean parseBooleanNull(String s) {
        return s == null ? null : Boolean.valueOf(Boolean.parseBoolean(s));
    }

    private ComplexType complexTypeFromGroupType(FieldGroupNode.GroupType groupType) {
        ComplexType ct;
        switch (groupType) {
            case ARRAY_GROUP: {
                ct = ComplexType.ARRAY;
                break;
            }
            case MAP_GROUP: {
                ct = ComplexType.MAP;
                break;
            }
            default: {
                ct = ComplexType.NONE;
            }
        }
        return ct;
    }

    private static <T> T valueOrDefault(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public String getName() {
        return FieldConfig.valueOrDefault(this.myName, DFLT_NAME);
    }

    public boolean isKey() {
        return this.myIsKey;
    }

    public void setKey(boolean key) {
        this.myIsKey = key;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public DataType getDataType() {
        return FieldConfig.valueOrDefault(this.myDataType, DFLT_DATA_TYPE);
    }

    public void setDataType(DataType dataType) {
        this.myDataType = dataType;
    }

    public String getParameterType() {
        return FieldConfig.valueOrDefault(this.myParameterType, DFLT_PARAMETER_TYPE);
    }

    public void setParameterType(String parameterType) {
        this.myParameterType = parameterType;
    }

    public String getComment() {
        return FieldConfig.valueOrDefault(this.myComment, "");
    }

    public void setComment(String comment) {
        this.myComment = comment;
    }

    public boolean hasTagNumber() {
        return !StringUtil.isEmptyString(this.myTagNumber);
    }

    public String getTagNumber() {
        return FieldConfig.valueOrDefault(this.myTagNumber, "");
    }

    public void setTagNumber(String tagNumber) {
        this.myTagNumber = tagNumber;
    }

    public boolean isMandatory() {
        return "VIRTUAL".equals(this.myParameterType) ? true : FieldConfig.valueOrDefault(this.myMandatory, false);
    }

    public void setMandatory(Boolean mandatory) {
        this.myMandatory = mandatory;
    }

    public boolean shouldShowInPlugins() {
        return FieldConfig.valueOrDefault(this.myShowInPlugins, true);
    }

    public void setShouldShowInPlugins(Boolean show) {
        this.myShowInPlugins = show;
    }

    public ComplexType getComplexType() {
        ComplexType type = this.myGroupType != FieldGroupNode.GroupType.GROUP ? this.complexTypeFromGroupType(this.myGroupType) : FieldConfig.valueOrDefault(this.myComplexType, ComplexType.NONE);
        return type;
    }

    public void setComplexType(ComplexType type) {
        this.myComplexType = type;
    }

    public String getValueClass() {
        return FieldConfig.valueOrDefault(this.myValueClass, "");
    }

    public void setValueClass(String className) {
        this.myValueClass = className;
    }

    public String getValueClassFactory() {
        return FieldConfig.valueOrDefault(this.myValueClassFactory, "");
    }

    public void setValueClassFactory(String className) {
        this.myValueClassFactory = className;
    }

    public boolean hasDefaultValue() {
        return this.myDefaultValue != null && this.myDefaultValue.length > 0;
    }

    public Object[] getDefaultValue() {
        return this.myDefaultValue;
    }

    public void setDefaultValue(Object[] defaultValue) {
        this.myDefaultValue = defaultValue != null ? (Object[])defaultValue.clone() : null;
    }

    public InputRestriction<?> getInputRestriction() {
        return this.myInputRestriction != null ? this.myInputRestriction : new CustomEditorInputRestriction("");
    }

    public void setInputRestriction(InputRestriction<?> restriction) {
        this.myInputRestriction = restriction;
    }

    public boolean allowsNegativeAmountBalance() {
        String setting = this.myFieldSettings.get(TAG_ALLOW_NEGATIVE_INPUT);
        return setting != null ? Boolean.parseBoolean(setting) : true;
    }

    public void setAllowsNegativeAmountBalance(Boolean allow) {
        this.setOrRemoveSetting(TAG_ALLOW_NEGATIVE_INPUT, allow);
    }

    public String getAmountFactory() {
        String setting = this.myFieldSettings.get(TAG_AMOUNT_FACTORY_CLASS);
        return FieldConfig.valueOrDefault(setting, "");
    }

    public void setAmountFactory(String className) {
        this.setOrRemoveSetting(TAG_AMOUNT_FACTORY_CLASS, className);
    }

    public String getBeginningOfTimeLabel() {
        String setting = this.myFieldSettings.get("BeginningOfTimeLabel");
        return FieldConfig.valueOrDefault(setting, "");
    }

    public void setBeginningOfTimeLabel(String label) {
        this.setOrRemoveSetting("BeginningOfTimeLabel", label);
    }

    public String getEndOfTimeLabel() {
        String setting = this.myFieldSettings.get("EndOfTimeLabel");
        return FieldConfig.valueOrDefault(setting, "");
    }

    public void setEndOfTimeLabel(String label) {
        this.setOrRemoveSetting("EndOfTimeLabel", label);
    }

    public String getTooltip() {
        return this.myTooltip;
    }

    public void setTooltip(String tooltip) {
        this.myTooltip = tooltip;
    }

    private Object[] parseDefaultValue(String defaultString, DataType dataType, ComplexType complexType) {
        Object[] ret = null;
        if (defaultString != null) {
            switch (complexType) {
                case ARRAY: {
                    ret = dataType.parseMultiValue(defaultString);
                    break;
                }
                default: {
                    ret = new Object[]{dataType.parseValue(defaultString)};
                }
            }
        }
        return ret;
    }

    private Map<String, String> readFieldSettings(NodeList additionalNodes) {
        Map<String, String> ret;
        List<Element> elements = XMLUtil.getElementNodesNamed(TAG_FIELD_SETTINGS, additionalNodes);
        if (!elements.isEmpty()) {
            ret = new HashMap();
            Element settingsRoot = elements.get(0);
            for (Element child : new ElementIterator(settingsRoot.getChildNodes())) {
                ret.put(child.getNodeName(), child.getTextContent());
            }
        } else {
            ret = Collections.emptyMap();
        }
        return ret;
    }

    private String readParameterType(NamedNodeMap attributes) {
        String pt = this.readAttributeValue(attributes, ATTR_PARAMETER_TYPE);
        if ("WorkingParameter".equals(pt)) {
            pt = "WORKING";
        }
        return pt;
    }

    private ComplexType readComplexType(NamedNodeMap attributes) {
        ComplexType ret = null;
        Node complexTypeAttribute = attributes.getNamedItem(ATTR_COMPLEX_TYPE);
        Node valueListAttribute = attributes.getNamedItem(ATTR_VALUE_LIST);
        if (complexTypeAttribute != null) {
            String value = complexTypeAttribute.getNodeValue();
            try {
                ret = ComplexType.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (valueListAttribute != null) {
            boolean valueList = Boolean.parseBoolean(valueListAttribute.getNodeValue());
            ret = valueList ? ComplexType.ARRAY : ComplexType.NONE;
        }
        return ret;
    }

    private String readAttributeValue(NamedNodeMap attributes, String attrName) {
        Node item = attributes.getNamedItem(attrName);
        return item != null ? item.getNodeValue() : null;
    }

    @Override
    public void appendXML(Node parent) {
        Element fieldElement = (parent instanceof Document ? (Document)parent : parent.getOwnerDocument()).createElement(TAG_FIELD);
        fieldElement.setAttribute(ATTR_NAME, this.myName);
        fieldElement.setAttribute(ATTR_DATA_TYPE, this.myDataType.getTypeName());
        fieldElement.setAttribute(ATTR_TAG_NUMBER, this.myTagNumber);
        fieldElement.setAttribute(ATTR_COMMENT, XMLUtil.unEscape(this.myComment));
        fieldElement.setAttribute(ATTR_PARAMETER_TYPE, this.myParameterType);
        fieldElement.setAttribute(ATTR_MANDATORY, Boolean.toString(this.myMandatory));
        fieldElement.setAttribute(ATTR_AUTOCONDITIONMAP, Boolean.toString(this.myShowInPlugins));
        fieldElement.setAttribute(ATTR_COMPLEX_TYPE, this.myComplexType.toString());
        this.setNonDefaultAttribute(fieldElement, ATTR_VALUE_CLASS, this.myValueClass, "");
        this.setNonDefaultAttribute(fieldElement, ATTR_VALUE_CLASS_FACTORY, this.myValueClassFactory, "");
        this.setNonDefaultAttribute(fieldElement, ATTR_KEY, this.myIsKey, false);
        if (this.myDefaultValue != null) {
            fieldElement.setAttribute(ATTR_DEFAULT, this.createDefaultString(this.myDefaultValue, this.myDataType));
        }
        if (!StringUtil.isEmptyString(this.myTooltip)) {
            fieldElement.setAttribute(ATTR_TOOLTIP, this.myTooltip);
        }
        if (this.myInputRestriction != null) {
            this.myInputRestriction.appendXML(fieldElement);
        }
        this.appendFieldSettings(fieldElement, this.myFieldSettings);
        parent.appendChild(fieldElement);
    }

    private <T> void setNonDefaultAttribute(Element e, String attrName, T value, T defaultValue) {
        if (value != null && !value.equals(defaultValue)) {
            e.setAttribute(attrName, value.toString());
        }
    }

    private void appendFieldSettings(Node parent, Map<String, String> settings) {
        if (!settings.isEmpty()) {
            Element e = parent.getOwnerDocument().createElement(TAG_FIELD_SETTINGS);
            for (Map.Entry<String, String> entry : settings.entrySet()) {
                String value = entry.getValue();
                if (StringUtil.isEmptyString(value)) continue;
                Element setting = parent.getOwnerDocument().createElement(entry.getKey());
                setting.setTextContent(value);
                e.appendChild(setting);
            }
            parent.appendChild(e);
        }
    }

    private String createDefaultString(Object[] defaultValue, DataType dataType) {
        String str;
        if (defaultValue.length == 1) {
            str = dataType.makeValueString(defaultValue[0]);
        } else {
            Object[] strings = new String[defaultValue.length];
            for (int i = 0; i < defaultValue.length; ++i) {
                strings[i] = dataType.makeValueString(defaultValue[i]);
            }
            str = StringUtil.buildSemiColonSeparatedString(strings);
        }
        return str;
    }

    private void setOrRemoveSetting(String tag, Object value) {
        if (value != null) {
            this.myFieldSettings.put(tag, String.valueOf(value));
        } else {
            this.myFieldSettings.remove(tag);
        }
    }

    public static enum ComplexType {
        NONE,
        ARRAY,
        MAP,
        SET;


        public static String[] names() {
            ComplexType[] types = ComplexType.values();
            String[] names = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                names[i] = types[i].name();
            }
            return names;
        }
    }
}

