/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.ContextDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.FieldsDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.HierarchicalFieldNode;
import com.ericsson.ere.swing.TreeModelAdapter;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class ContextTopNode
extends AbstractTreeNode {
    private static final Map<String, String> EMPTY_STRING_MAP = Collections.emptyMap();
    private static final String TAG_CONTEXTDEFINITION = "ContextDefinition";
    private static final String ATTR_CONTEXTFIELDID = "ContextFieldIdentifier";
    private static final String LABEL_REFERENCE_FIELD = "Reference Field";
    private Variable myReferenceField;
    private ImageIcon myIcon = RmaDefs.getImageIcon("cubes_blue.png");
    private Map<FieldNode, String> myContextFields;

    public ContextTopNode() {
        this(null);
    }

    public ContextTopNode(NamedNodeMap attributes) {
        String ref = XMLUtil.getAttributeValue(attributes, ATTR_CONTEXTFIELDID, "");
        this.myReferenceField = new DropDownVariable(LABEL_REFERENCE_FIELD, (Object)ref, (Object[])new String[]{ref});
        this.myVarList.add(this.myReferenceField);
    }

    @Override
    protected Element createConfigurationElement(Document doc) {
        Element e = doc.createElement(TAG_CONTEXTDEFINITION);
        e.setAttribute(ATTR_CONTEXTFIELDID, this.myReferenceField.toString());
        return e;
    }

    @Override
    public String getToolTipText() {
        String current = this.myReferenceField.toString();
        String toolTip = null;
        if (!StringUtil.isEmptyString(current)) {
            toolTip = "Current reference field: " + current;
        }
        return toolTip;
    }

    @Override
    public void setTreeModel(DefaultTreeModel theModel) {
        super.setTreeModel(theModel);
        theModel.addTreeModelListener(new ContextTracker());
        FieldsDefinitionTreeModel fieldsModel = ((ContextDefinitionTreeModel)theModel).getFieldsModel();
        this.discoverContextFields((TreeNode)fieldsModel.getRoot());
        fieldsModel.addTreeModelListener(new ContextFieldTracker());
    }

    private void discoverContextFields(TreeNode root) {
        ArrayList<FieldNode> fields = new ArrayList<FieldNode>();
        this.findFields(root, fields, true);
        this.myContextFields = new HashMap<FieldNode, String>();
        for (FieldNode node : fields) {
            this.myContextFields.put(node, node.getName());
        }
        this.updateReference(EMPTY_STRING_MAP);
    }

    private void findFields(TreeNode node, List<FieldNode> fields, boolean onlyReferenceFields) {
        if (node instanceof FieldNode) {
            FieldNode fn = (FieldNode)node;
            if (!onlyReferenceFields || this.isAppropriateReferenceField(fn)) {
                fields.add(fn);
            }
        }
        if (!(node instanceof HierarchicalFieldNode)) {
            int cc = node.getChildCount();
            for (int i = 0; i < cc; ++i) {
                this.findFields(node.getChildAt(i), fields, onlyReferenceFields);
            }
        }
    }

    @Override
    public ImageIcon getNodeIcon(boolean expanded) {
        return this.myIcon;
    }

    @Override
    public String getName() {
        return "Contexts";
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        String refField = this.myReferenceField.getValueString();
        if (!"".equals(refField) || !this.myReferenceField.isValueValid()) {
            builder.append(" (");
            if ("".equals(refField)) {
                builder.append("no reference field");
            } else {
                builder.append("reference field: ");
                builder.append(refField);
            }
            builder.append(")");
        }
        return builder.toString();
    }

    private void updateReference(Map<String, String> nameChanges) {
        String currentReference = this.myReferenceField.toString();
        if (nameChanges.containsKey(currentReference)) {
            currentReference = nameChanges.get(currentReference);
        }
        boolean hasContexts = this.getChildCount() > 0;
        Object[] fieldNames = this.myContextFields.values().toArray(new String[this.myContextFields.size()]);
        this.myVarList.clear();
        if (!hasContexts) {
            String[] temp = new String[fieldNames.length + 1];
            System.arraycopy(fieldNames, 0, temp, 1, fieldNames.length);
            temp[0] = "";
            fieldNames = temp;
        }
        this.myReferenceField = new DropDownVariable(LABEL_REFERENCE_FIELD, (Object)currentReference, fieldNames);
        this.myVarList.add(this.myReferenceField);
    }

    private boolean isAppropriateReferenceField(FieldNode field) {
        return field.isContextField() && !field.isComplexType();
    }

    private class ContextTracker
    extends TreeModelAdapter {
        private ContextTracker() {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            Object parent = e.getTreePath().getLastPathComponent();
            if (parent == ContextTopNode.this && ContextTopNode.this.getChildCount() == 1) {
                ContextTopNode.this.updateReference(EMPTY_STRING_MAP);
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            Object parent = e.getTreePath().getLastPathComponent();
            if (parent == ContextTopNode.this && ContextTopNode.this.getChildCount() == 0) {
                ContextTopNode.this.updateReference(EMPTY_STRING_MAP);
            }
        }
    }

    private class ContextFieldTracker
    extends TreeModelAdapter {
        private ContextFieldTracker() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            HashMap<String, String> nameChanges = new HashMap<String, String>();
            List<FieldNode> nonRefFields = this.getFieldNodes(e, false);
            List<FieldNode> refFields = this.getFieldNodes(e, true);
            nonRefFields.removeAll(refFields);
            boolean listChanged = ContextTopNode.this.myContextFields.keySet().removeAll(nonRefFields);
            for (FieldNode node : refFields) {
                String oldName = (String)ContextTopNode.this.myContextFields.get(node);
                String newName = node.getName();
                if (newName.equals(oldName)) continue;
                ContextTopNode.this.myContextFields.put(node, newName);
                nameChanges.put(oldName, newName);
            }
            if (listChanged || !nameChanges.isEmpty()) {
                ContextTopNode.this.updateReference(nameChanges);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            List<FieldNode> fields = this.getFieldNodes(e, true);
            for (FieldNode node : fields) {
                ContextTopNode.this.myContextFields.put(node, node.getName());
            }
            ContextTopNode.this.updateReference(EMPTY_STRING_MAP);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            List<FieldNode> fields = this.getFieldNodes(e, false);
            for (FieldNode node : fields) {
                ContextTopNode.this.myContextFields.remove(node);
            }
            ContextTopNode.this.updateReference(EMPTY_STRING_MAP);
        }

        private List<FieldNode> getFieldNodes(TreeModelEvent e, boolean onlyReferenceFields) {
            ArrayList<FieldNode> fields = new ArrayList<FieldNode>();
            Object[] roots = e.getChildren();
            if (roots != null) {
                for (Object root : roots) {
                    ContextTopNode.this.findFields((TreeNode)root, fields, onlyReferenceFields);
                }
            }
            return fields;
        }
    }
}

