/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.swing.TreeModelMonitor;
import com.ericsson.ere.util.CountedObjectRepository;
import com.ericsson.ere.variable.UniqueStringVariable;
import ericsson.ere.defs.RmaDefs;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class ContextNode
extends AbstractTreeNode {
    public static final String TAG_CONTEXT = "Context";
    private static final String ATTR_NAME = "Name";
    private UniqueStringVariable myName;
    private ImageIcon myIcon = RmaDefs.getImageIcon("folder_cubes.png");

    public ContextNode(CountedObjectRepository<String> contextNameRepository) {
        this(contextNameRepository, null);
    }

    public ContextNode(CountedObjectRepository<String> contextNameRepository, NamedNodeMap attributes) {
        String name = "[Unnamed]";
        if (attributes != null && attributes.getNamedItem(ATTR_NAME).getNodeValue() != null) {
            name = attributes.getNamedItem(ATTR_NAME).getNodeValue();
        }
        this.myName = new UniqueStringVariable(ATTR_NAME, name, contextNameRepository);
        this.myVarList.add(this.myName);
    }

    @Override
    protected Element createConfigurationElement(Document doc) {
        Element e = doc.createElement(TAG_CONTEXT);
        e.setAttribute(ATTR_NAME, this.myName.toString());
        return e;
    }

    @Override
    public ImageIcon getNodeIcon(boolean expanded) {
        return this.myIcon;
    }

    @Override
    public void setTreeModel(DefaultTreeModel theModel) {
        super.setTreeModel(theModel);
        new TreeModelMonitor(theModel, this).onRemove(new Runnable(){

            @Override
            public void run() {
                ContextNode.this.myName.detachFromRepository();
            }
        }).onInsert(new Runnable(){

            @Override
            public void run() {
                ContextNode.this.myName.attachToRepository();
            }
        });
    }

    @Override
    public String getName() {
        return this.myName.getValueString();
    }
}

