/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes;

import com.ericsson.charging.common.dataitem.DataItem;
import com.ericsson.ere.gui.editors.serviceeditor.interfaces.ServiceEditorNodeInterface;
import com.ericsson.ere.util.Transformer;
import com.ericsson.ere.variable.VariableChangeEvent;
import com.ericsson.ere.variable.VariableChangeListener;
import com.ericsson.ere.variable.VariableList;
import ericsson.ere.util.StringUtil;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.Variable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractTreeNode
extends DefaultMutableTreeNode
implements DataItem,
ServiceEditorNodeInterface {
    public static final String PROP_NAME_VALID = "___varlistvalid";
    protected VariableList myVarList = new VariableList();
    private VarTableModel myTableModel = null;
    private PropertyChangeSupport myListeners = new PropertyChangeSupport(this);
    private List<AbstractTreeNode> myReferrers;
    private DefaultTreeModel myTreeModel;
    private VariableListValidityListener myValidityListener;

    public AbstractTreeNode() {
        this.myVarList.addListDataListener(new VariableListListener());
        this.myValidityListener = new VariableListValidityListener();
        this.myVarList.addPropertyChangeListener("valid", this.myValidityListener);
    }

    protected void disableValidityChangeEvents() {
        this.myValidityListener.disable();
    }

    protected void enableValidityChangeEvents() {
        this.myValidityListener.enable();
    }

    @Override
    public void setDataItem(Object object) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myListeners.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myListeners.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.myListeners.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.myListeners.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public final ImageIcon getNodeIcon(JTree tree) {
        return this.getNodeIcon(this.isExpandedInTree(tree));
    }

    @Override
    public Object getDataItem(Object reference) {
        return null;
    }

    @Override
    public Object getDataItem() {
        return null;
    }

    @Override
    public void editingFinished(List<Variable> vars) {
        for (Variable var : vars) {
            var.editFinished();
        }
        this.myTableModel = null;
    }

    @Override
    public void setNodeOwner(DefaultMutableTreeNode node) {
    }

    public boolean isNodeValid() {
        boolean valid = this.myVarList.isValid();
        int cc = this.getChildCount();
        for (int i = 0; valid && i < cc; ++i) {
            valid = ((AbstractTreeNode)this.getChildAt(i)).isNodeValid();
        }
        return valid;
    }

    @Override
    public final boolean isModified() {
        throw new UnsupportedOperationException("Modified status is no longer tracked within the node.");
    }

    @Override
    public final void resetModified() {
        throw new UnsupportedOperationException("Modified status is no longer tracked within the node.");
    }

    @Override
    public void reset() {
        this.resetModified();
    }

    public boolean isContextField() {
        TreeNode parent = this.getParent();
        return parent != null && ((AbstractTreeNode)parent).isContextField();
    }

    protected abstract ImageIcon getNodeIcon(boolean var1);

    public abstract String getName();

    @Override
    public void setTreeModel(DefaultTreeModel model) {
        this.myTreeModel = model;
    }

    public DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    @Override
    public void setDataItem(Object reference, Object object) {
    }

    @Override
    public final List<Variable> getVariablesForEditing(VarTableModel aModel) {
        this.myTableModel = aModel;
        return this.myVarList;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public final void appendXML(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = this.createConfigurationElement(doc);
        int cc = this.getChildCount();
        for (int i = 0; i < cc; ++i) {
            ServiceEditorNodeInterface child = (ServiceEditorNodeInterface)((Object)this.getChildAt(i));
            child.appendXML(element);
        }
        parent.appendChild(element);
    }

    protected abstract Element createConfigurationElement(Document var1);

    @Override
    public final String getStartTag(String tabs) {
        throw new UnsupportedOperationException("Replaced by XMLAppendable.");
    }

    @Override
    public final String getXMLDefinition(String tabs) throws Exception {
        throw new UnsupportedOperationException("Replaced by XMLAppendable.");
    }

    @Override
    public final String getEndTag(String tabs) {
        throw new UnsupportedOperationException("Replaced by XMLAppendable.");
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void addReferrer(AbstractTreeNode referrer) {
        if (this.myReferrers == null) {
            this.myReferrers = new ArrayList<AbstractTreeNode>();
        }
        this.myReferrers.add(referrer);
    }

    public void removeReferrer(AbstractTreeNode referrer) {
        this.myReferrers.remove(referrer);
    }

    public List<AbstractTreeNode> getReferrers() {
        return this.myReferrers != null ? Collections.unmodifiableList(this.myReferrers) : Collections.emptyList();
    }

    public String getInvalidReason() {
        String reason = "";
        List<Variable> invalidVars = this.myVarList.getInvalidVariables();
        if (!invalidVars.isEmpty()) {
            boolean plural = invalidVars.size() > 1;
            StringBuilder reasonBuilder = new StringBuilder("The configuration parameter");
            if (plural) {
                reasonBuilder.append("s");
            }
            reasonBuilder.append(" ");
            reasonBuilder.append(StringUtil.joinSequenceAsSentence(new VariableToLabelTransformer(), invalidVars));
            reasonBuilder.append(plural ? " are" : " is");
            reasonBuilder.append(" invalid.");
            reason = reasonBuilder.toString();
        }
        return reason;
    }

    private boolean isExpandedInTree(JTree tree) {
        boolean expanded = false;
        if (this.getChildCount() > 0) {
            TreePath path = new TreePath(((DefaultMutableTreeNode)this.getFirstChild()).getPath());
            expanded = tree.isVisible(path);
        }
        return expanded;
    }

    protected void updateTableModel() {
        if (this.myTableModel != null) {
            this.myTableModel.setData(this.myVarList);
        }
    }

    private class VariableListValidityListener
    implements PropertyChangeListener {
        private Boolean mySavedState;

        private VariableListValidityListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fire((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
        }

        private void fire(Boolean oldValue, Boolean newValue) {
            if (this.mySavedState == null) {
                AbstractTreeNode.this.myListeners.firePropertyChange(AbstractTreeNode.PROP_NAME_VALID, oldValue, newValue);
            }
        }

        void disable() {
            this.mySavedState = AbstractTreeNode.this.myVarList.isValid();
        }

        void enable() {
            if (this.mySavedState == null) {
                throw new IllegalStateException("No previous saved validity state.");
            }
            boolean savedState = this.mySavedState;
            this.mySavedState = null;
            this.fire(savedState, AbstractTreeNode.this.myVarList.isValid());
        }
    }

    private static class VariableToLabelTransformer
    implements Transformer<Variable, String> {
        private VariableToLabelTransformer() {
        }

        @Override
        public String transform(Variable input) {
            return input.getLabel();
        }
    }

    private class VariableListListener
    implements ListDataListener,
    VariableChangeListener {
        private VariableListListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.updateVariables(e.getIndex0(), e.getIndex1());
            AbstractTreeNode.this.updateTableModel();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            AbstractTreeNode.this.updateTableModel();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.updateVariables(e.getIndex0(), e.getIndex1());
            AbstractTreeNode.this.updateTableModel();
        }

        private void updateVariables(int index0, int index1) {
            for (int i = index0; i <= index1; ++i) {
                Variable var = (Variable)AbstractTreeNode.this.myVarList.get(i);
                var.setHelpId(AbstractTreeNode.this.getClass().toString());
                var.removeVariableChangeListener(this);
                var.addVariableChangeListener(this);
            }
        }

        @Override
        public void valueChanged(VariableChangeEvent event) {
            Variable var = event.getVariable();
            if (!AbstractTreeNode.this.myVarList.contains(var)) {
                var.removeVariableChangeListener(this);
            } else {
                AbstractTreeNode.this.setDataItem(event.getKey(), var);
                AbstractTreeNode.this.myListeners.firePropertyChange(event.getKey(), event.getPreviousValue(), event.getValue());
            }
        }
    }
}

