/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts;

import com.ericsson.ere.gui.editors.serviceeditor.NameRepositories;
import com.ericsson.ere.gui.editors.serviceeditor.ServiceEditorTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.TreeNodeChangeTracker;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.CommonFieldsGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.ContextFieldsGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.ContextTopNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldConditionNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldTopNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.HierarchicalFieldNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.PluginsTreeModel;
import com.ericsson.ere.util.CountedObjectRepository;
import com.ericsson.ere.util.Predicate;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;

public class FieldsDefinitionTreeModel
extends ServiceEditorTreeModel {
    private final CountedObjectRepository<String> myFieldNameRepository;
    private final CountedObjectRepository<String> myConditionNameRepository;
    private boolean myAddChildOrderEnabled = true;
    private PluginsTreeModel myPluginsModel;

    public FieldsDefinitionTreeModel(AbstractTreeNode topNode, NameRepositories repositories, PluginsTreeModel pluginsModel) {
        super(topNode);
        this.myFieldNameRepository = repositories.getFieldNameRepository();
        this.myConditionNameRepository = repositories.getConditionNameRepository();
        this.myPluginsModel = pluginsModel;
        topNode.setTreeModel(this);
        new TreeNodeChangeTracker(this);
    }

    public PluginsTreeModel getPluginsModel() {
        return this.myPluginsModel;
    }

    private void addNode(AbstractTreeNode newNode, TreePath thePath) {
        if (thePath != null) {
            int index;
            AbstractTreeNode parentNode = (AbstractTreeNode)thePath.getLastPathComponent();
            int n = index = this.myAddChildOrderEnabled ? -1 : parentNode.getChildCount();
            if (parentNode instanceof FieldNode && newNode instanceof FieldNode || parentNode instanceof FieldConditionNode && newNode instanceof FieldConditionNode) {
                AbstractTreeNode theFieldNode = parentNode;
                parentNode = (AbstractTreeNode)parentNode.getParent();
                index = parentNode.getIndex(theFieldNode) + 1;
            }
            if (index == -1) {
                int defaultIndex = newNode instanceof FieldNode ? parentNode.getChildCount() : 0;
                index = this.lastIndexOfChildType(parentNode, newNode.getClass());
                index = index >= 0 ? index + 1 : defaultIndex;
            }
            this.insertNodeInto(newNode, parentNode, index);
        }
    }

    private int lastIndexOfChildType(AbstractTreeNode parentNode, Class<? extends AbstractTreeNode> childType) {
        int idx = -1;
        for (int i = parentNode.getChildCount() - 1; i >= 0; --i) {
            if (!childType.isInstance(parentNode.getChildAt(i))) continue;
            idx = i;
            break;
        }
        return idx;
    }

    public void deleteNode(TreePath thePath) {
        AbstractTreeNode theNode = (AbstractTreeNode)thePath.getLastPathComponent();
        if (!(theNode instanceof ContextTopNode) && !(theNode instanceof FieldTopNode)) {
            this.removeNodeFromParent(theNode);
        }
    }

    public AbstractTreeNode findField(String fieldName) {
        List<AbstractTreeNode> nodes = this.findNodes(new FieldFinder(fieldName));
        return nodes.isEmpty() ? null : nodes.get(0);
    }

    public boolean isTreeValid() {
        return ((AbstractTreeNode)this.root).isNodeValid();
    }

    public boolean hasConditionNamed(String conditionName) {
        return this.hasConditionNamed(conditionName, (AbstractTreeNode)this.root);
    }

    private boolean hasConditionNamed(String conditionName, AbstractTreeNode parent) {
        if (parent instanceof FieldConditionNode && ((FieldConditionNode)parent).getCondition().equals(conditionName)) {
            return true;
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (!this.hasConditionNamed(conditionName, (AbstractTreeNode)parent.getChildAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean moveUpOrDown(AbstractTreeNode aNode, boolean up) {
        int newIndex = -1;
        if (aNode == null) {
            return false;
        }
        DefaultMutableTreeNode theParent = (DefaultMutableTreeNode)aNode.getParent();
        if (up && theParent.getIndex(aNode) > 0) {
            newIndex = theParent.getIndex(aNode) - 1;
        } else if (!up && theParent.getIndex(aNode) < theParent.getChildCount() - 1) {
            newIndex = theParent.getIndex(aNode) + 1;
        }
        if (newIndex >= 0) {
            this.removeNodeFromParent(aNode);
            this.insertNodeInto(aNode, theParent, newIndex);
            return true;
        }
        return false;
    }

    public boolean moveIntoGroup(AbstractTreeNode currentNode) {
        DefaultMutableTreeNode nextNode;
        for (nextNode = currentNode.getNextSibling(); nextNode != null && nextNode instanceof FieldNode; nextNode = nextNode.getNextNode()) {
        }
        if (nextNode != null && nextNode instanceof FieldGroupNode && !((FieldGroupNode)nextNode).isComplexGroup()) {
            this.removeNodeFromParent(currentNode);
            this.insertNodeInto(currentNode, nextNode, 0);
            return true;
        }
        return false;
    }

    public boolean moveOutOfGroup(AbstractTreeNode currentNode) {
        DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)currentNode.getParent();
        if (nextNode != null && nextNode instanceof FieldGroupNode && !((FieldGroupNode)nextNode).isComplexGroup()) {
            int index = nextNode.getParent().getIndex(nextNode);
            this.removeNodeFromParent(currentNode);
            this.insertNodeInto(currentNode, (MutableTreeNode)nextNode.getParent(), index);
            return true;
        }
        return false;
    }

    public FieldNode addNewFieldNode(FieldGroupNode.GroupType groupType, TreePath treePath) {
        AbstractTreeNode parent = this.checkNodeAndFindActualParent(treePath);
        CountedObjectRepository<String> nameRepo = this.getNameRepoFrom(parent);
        FieldNode newNode = new FieldNode(parent, nameRepo, groupType);
        return this.addNodeAndReturn(newNode, treePath);
    }

    private CountedObjectRepository<String> getNameRepoFrom(AbstractTreeNode parent) {
        CountedObjectRepository<String> nameRepo = this.myFieldNameRepository;
        if (parent instanceof HierarchicalFieldNode) {
            nameRepo = ((HierarchicalFieldNode)parent).getFieldNameRepository();
        }
        return nameRepo;
    }

    public HierarchicalFieldNode addNewHierarchicalFieldNode(TreePath treePath, Element configElement) {
        AbstractTreeNode parent = this.checkNodeAndFindActualParent(treePath);
        CountedObjectRepository<String> nameRepo = this.getNameRepoFrom(parent);
        HierarchicalFieldNode newNode = new HierarchicalFieldNode(parent, nameRepo, configElement);
        return this.addNodeAndReturn(newNode, treePath);
    }

    public FieldNode addNewFieldNode(FieldGroupNode.GroupType groupType, TreePath parentPath, Element configElement) {
        AbstractTreeNode parent = this.checkNodeAndFindActualParent(parentPath);
        CountedObjectRepository<String> nameRepo = this.getNameRepoFrom(parent);
        FieldNode newNode = new FieldNode(parent, nameRepo, configElement.getAttributes(), configElement.getChildNodes(), groupType);
        return this.addNodeAndReturn(newNode, parentPath);
    }

    private AbstractTreeNode checkNodeAndFindActualParent(TreePath parentPath) {
        AbstractTreeNode parent = (AbstractTreeNode)parentPath.getLastPathComponent();
        if (!(parent instanceof CommonFieldsGroupNode || parent instanceof ContextFieldsGroupNode || parent instanceof FieldGroupNode || parent instanceof FieldNode || parent instanceof HierarchicalFieldNode)) {
            throw new IllegalArgumentException("FieldNode parent is invalid: " + parent.getClass().getSimpleName());
        }
        if (parent instanceof FieldNode) {
            parent = (AbstractTreeNode)parent.getParent();
        }
        return parent;
    }

    public FieldConditionNode addNewFieldConditionNode(TreePath treePath) {
        this.checkFieldConditionNodeParent(treePath);
        FieldNode fieldNode = this.findFieldNode(treePath);
        FieldConditionNode newNode = new FieldConditionNode(fieldNode, this.myConditionNameRepository);
        return this.addNodeAndReturn(newNode, treePath);
    }

    private FieldNode findFieldNode(TreePath parentPath) {
        FieldNode node;
        TreeNode parent = (TreeNode)parentPath.getLastPathComponent();
        if (parent instanceof FieldNode) {
            node = (FieldNode)parent;
        } else {
            assert (parent instanceof FieldConditionNode);
            node = (FieldNode)parent.getParent();
        }
        return node;
    }

    public FieldConditionNode addNewFieldConditionNode(TreePath treePath, Element configElement) {
        this.checkFieldConditionNodeParent(treePath);
        FieldNode fieldNode = (FieldNode)treePath.getLastPathComponent();
        FieldConditionNode newNode = new FieldConditionNode(configElement.getAttributes(), fieldNode, this.myConditionNameRepository);
        return this.addNodeAndReturn(newNode, treePath);
    }

    private void checkFieldConditionNodeParent(TreePath parentPath) {
        Object parent = parentPath.getLastPathComponent();
        if (!(parent instanceof FieldNode) && !(parent instanceof FieldConditionNode)) {
            throw new IllegalArgumentException("FieldConditionNode can only be added to FieldNode or FieldConditionNode.");
        }
    }

    public FieldGroupNode addNewFieldGroupNode(TreePath parentPath) {
        this.checkFieldGroupNodeParent(parentPath);
        FieldGroupNode newNode = new FieldGroupNode();
        return this.addNodeAndReturn(newNode, parentPath);
    }

    public FieldGroupNode addNewFieldGroupNode(TreePath parentPath, Element configElement) {
        this.checkFieldGroupNodeParent(parentPath);
        FieldGroupNode newNode = new FieldGroupNode(configElement.getAttributes());
        return this.addNodeAndReturn(newNode, parentPath);
    }

    private void checkFieldGroupNodeParent(TreePath parentPath) {
        Object parent = parentPath.getLastPathComponent();
        if (!(parent instanceof CommonFieldsGroupNode || parent instanceof ContextFieldsGroupNode || parent instanceof FieldGroupNode)) {
            throw new IllegalArgumentException("FieldGroupNode parent is invalid: " + parent.getClass().getSimpleName());
        }
    }

    public CommonFieldsGroupNode addNewCommonFieldsGroupNode() {
        CommonFieldsGroupNode newNode = new CommonFieldsGroupNode();
        return this.addNodeAndReturn(newNode, new TreePath(this.getRoot()));
    }

    public ContextFieldsGroupNode addNewContextFieldsGroupNode() {
        ContextFieldsGroupNode newNode = new ContextFieldsGroupNode();
        return this.addNodeAndReturn(newNode, new TreePath(this.getRoot()));
    }

    private <T extends AbstractTreeNode> T addNodeAndReturn(T newNode, TreePath parentPath) {
        this.addNode(newNode, parentPath);
        newNode.setTreeModel(this);
        return newNode;
    }

    public void setAddChildOrderEnabled(boolean enabled) {
        this.myAddChildOrderEnabled = enabled;
    }

    private static class FieldFinder
    implements Predicate<AbstractTreeNode> {
        private String myName;

        FieldFinder(String name) {
            this.myName = name;
        }

        @Override
        public boolean test(AbstractTreeNode node) {
            return (node instanceof FieldNode || node instanceof HierarchicalFieldNode) && this.myName.equals(node.getName());
        }
    }
}

