/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts;

import com.ericsson.ere.gui.editors.serviceeditor.ServiceEditorInternalFrame;
import com.ericsson.ere.gui.editors.serviceeditor.ServiceEditorTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.ServiceEditorTreeRenderer;
import com.ericsson.ere.gui.editors.serviceeditor.TreeNodeSelectionHandler;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.ContextDefinitionTree;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.ContextDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.FieldAndContextDefinitionPanel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.FieldsDefinitionTree;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.FieldsDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.CommonFieldsGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.CommonLinkNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.ContextFieldsGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.ContextGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.ContextNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.ContextTopNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldConditionNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldConfig;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldGroupLinkNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldLinkNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldTopNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.HierarchicalFieldNode;
import com.ericsson.ere.gui.editors.serviceeditor.xmlprinters.PrintServiceDefintion;
import com.ericsson.ere.util.Transformer;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.DefaultDialogFactory;
import ericsson.ere.gui.util.DialogFactoryInterface;
import ericsson.ere.gui.util.RmaAction;
import ericsson.ere.util.StringUtil;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FieldsAndContextTabPanel
extends JSplitPane {
    private ContextDefinitionTreeModel myContextDefinitionTreeModel;
    private FieldsDefinitionTreeModel myFieldsDefinitionTreeModel;
    private JTree myContextDefinitionTree;
    private JTree myFieldsDefinitionTree;
    private FieldAndContextDefinitionPanel myContextDefinitionPanel;
    private Action myAddDataFieldAction;
    private Action myAddHierarchicalFieldAction;
    private Action myAddConditionAction;
    private Action myAddFieldGroupAction;
    private Action myFieldDeleteAction;
    private Action myAddContextAction;
    private Action mySaveAction;
    private Action myExportAction;
    private Action myImportAction;
    private Action myAddContextGroupAction;
    private Action myShowLinkTargetAction;
    private Action myContextDeleteAction;
    private Action myFieldPrintClassAction;
    private Action myFieldPrintStructureAction;
    private Action myFieldMoveUpAction;
    private Action myFieldMoveDownAction;
    private Action myFieldEnterGroupAction;
    private Action myFieldLeaveGroupAction;
    private Action myContextMoveUpAction;
    private Action myContextMoveDownAction;
    private Action myContextEnterGroupAction;
    private Action myContextLeaveGroupAction;
    private Action myContextPrintClassAction;
    private Action myContextPrintStructureAction;
    private JMenuItem myFieldPrintClassMenuItem;
    private JMenuItem myFieldPrintStructureMenuItem;
    private JMenuItem myContextPrintClassMenuItem;
    private JMenuItem myContextPrintStructureMenuItem;
    private static final String LABEL_ADD_DATA_FIELD = "Add data field";
    private static final String LABEL_ADD_HIERARCHICAL_FIELD = "Add hierarchical field";
    private static final String LABEL_ADD_CONDITION = "Add condition";
    private static final String LABEL_ADD_GROUP = "Add group";
    private static final String LABEL_SHOW_FIELD = "Show field";
    private static final String LABEL_SHOW_GROUP = "Show group";
    private static final String LABEL_DELETE = "Delete";
    private static final String LABEL_ADD_CONTEXT = "Add Context";
    private static final String LABEL_PRINT_CLASS = "Print class";
    private static final String LABEL_PRINT_STRUCTURE = "Print structure";
    private static final String LABEL_MOVE_UP = "Move up";
    private static final String LABEL_MOVE_DOWN = "Move down";
    private static final String LABEL_ENTER_GROUP = "Enter group";
    private static final String LABEL_LEAVE_GROUP = "Leave group";
    private JPopupMenu myFieldPopupMenu;
    private JPopupMenu myContextPopupMenu;
    private VarTableModel myTableModel;
    private TreeNodeSelectionHandler mySelectionHandler;
    private DialogFactoryInterface myDialogFactory = new DefaultDialogFactory();

    public FieldsAndContextTabPanel(ContextDefinitionTreeModel contextModel, FieldsDefinitionTreeModel fieldsModel, Map<String, Action> commonActions) {
        this.myContextDefinitionTreeModel = contextModel;
        this.myFieldsDefinitionTreeModel = fieldsModel;
        this.createActions(commonActions);
        this.createPopupMenus();
        this.createPanel();
        this.bindActions();
    }

    public void setDialogFactory(DialogFactoryInterface factory) {
        this.myDialogFactory = factory;
    }

    private void createPanel() {
        this.myContextDefinitionPanel = new FieldAndContextDefinitionPanel();
        this.myTableModel = this.myContextDefinitionPanel.getTable().getTableModel();
        this.mySelectionHandler = new TreeNodeSelectionHandler(this.myTableModel);
        this.createFieldDefinitionTree();
        this.createContextDefinitionTree();
        JSplitPane treePane = new JSplitPane(1, new JScrollPane(this.myFieldsDefinitionTree), new JScrollPane(this.myContextDefinitionTree));
        treePane.setDividerSize(8);
        treePane.setDividerLocation(225);
        treePane.setOneTouchExpandable(true);
        this.setOrientation(1);
        this.setDividerSize(8);
        this.setDividerLocation(450);
        this.setOneTouchExpandable(true);
        this.setLeftComponent(treePane);
        this.setRightComponent(new JScrollPane(this.myContextDefinitionPanel));
    }

    private void createActions(Map<String, Action> commonActions) {
        this.myAddHierarchicalFieldAction = new RmaAction(this, "addHierarchicalDataFieldAction", LABEL_ADD_HIERARCHICAL_FIELD, null, "Adds a hierarchical field", KeyStroke.getKeyStroke(72, 2));
        this.myAddDataFieldAction = new RmaAction(this, "addDataFieldAction", LABEL_ADD_DATA_FIELD, null, "Adds a data field", KeyStroke.getKeyStroke(68, 2));
        this.myAddConditionAction = new RmaAction(this, "addConditionAction", LABEL_ADD_CONDITION, null, "Adds a condition field", KeyStroke.getKeyStroke(65, 2));
        this.myAddFieldGroupAction = new RmaAction(this, "addFieldGroupAction", LABEL_ADD_GROUP, null, "Adds a group", KeyStroke.getKeyStroke(71, 2));
        this.myFieldDeleteAction = new RmaAction(this, "deleteFieldAction", LABEL_DELETE, null, "Deletes marked element", KeyStroke.getKeyStroke(127, 0));
        this.myFieldPrintClassAction = new RmaAction(this, "printClassAction", LABEL_PRINT_CLASS, null, LABEL_PRINT_CLASS, null);
        this.myFieldPrintStructureAction = new RmaAction(this, "printStructureAction", LABEL_PRINT_STRUCTURE, null, LABEL_PRINT_STRUCTURE, null);
        this.myFieldMoveUpAction = new RmaAction(this, "moveFieldUpAction", LABEL_MOVE_UP, null, "Move node up", KeyStroke.getKeyStroke(38, 2));
        this.myFieldMoveDownAction = new RmaAction(this, "moveFieldDownAction", LABEL_MOVE_DOWN, null, "Move node down", KeyStroke.getKeyStroke(40, 2));
        this.myFieldEnterGroupAction = new RmaAction(this, "enterGroupFieldAction", LABEL_ENTER_GROUP, null, LABEL_ENTER_GROUP, KeyStroke.getKeyStroke(39, 2));
        this.myFieldLeaveGroupAction = new RmaAction(this, "leaveGroupFieldAction", LABEL_LEAVE_GROUP, null, LABEL_LEAVE_GROUP, KeyStroke.getKeyStroke(37, 2));
        this.mySaveAction = commonActions.get(ServiceEditorInternalFrame.ACTION_KEY_SAVE);
        this.myExportAction = commonActions.get(ServiceEditorInternalFrame.ACTION_KEY_EXPORT);
        this.myImportAction = commonActions.get(ServiceEditorInternalFrame.ACTION_KEY_IMPORT);
        this.myAddContextAction = new RmaAction(this, "addContextAction", LABEL_ADD_CONTEXT, null, "Adds a context", KeyStroke.getKeyStroke(78, 2));
        this.myAddContextGroupAction = new RmaAction(this, "addContextGroupAction", LABEL_ADD_GROUP, null, "Adds a group", KeyStroke.getKeyStroke(71, 2));
        this.myShowLinkTargetAction = new RmaAction(this, "showLinkTargetAction", LABEL_SHOW_FIELD, null, "Shows the link target in the fields tree", KeyStroke.getKeyStroke(87, 2));
        this.myContextDeleteAction = new RmaAction(this, "deleteContextAction", LABEL_DELETE, null, "Deletes marked element", KeyStroke.getKeyStroke(127, 0));
        this.myContextPrintClassAction = new RmaAction(this, "printClassAction", LABEL_PRINT_CLASS, null, LABEL_PRINT_CLASS, null);
        this.myContextPrintStructureAction = new RmaAction(this, "printStructureAction", LABEL_PRINT_STRUCTURE, null, LABEL_PRINT_STRUCTURE, null);
        this.myContextMoveUpAction = new RmaAction(this, "moveContextUpAction", LABEL_MOVE_UP, null, "Move node up", KeyStroke.getKeyStroke(38, 2));
        this.myContextMoveDownAction = new RmaAction(this, "moveContextDownAction", LABEL_MOVE_DOWN, null, "Move node down", KeyStroke.getKeyStroke(40, 2));
        this.myContextEnterGroupAction = new RmaAction(this, "enterGroupContextAction", LABEL_ENTER_GROUP, null, LABEL_ENTER_GROUP, KeyStroke.getKeyStroke(39, 2));
        this.myContextLeaveGroupAction = new RmaAction(this, "leaveGroupContextAction", LABEL_LEAVE_GROUP, null, LABEL_LEAVE_GROUP, KeyStroke.getKeyStroke(37, 2));
    }

    private void createPopupMenus() {
        this.myFieldPopupMenu = this.createFieldPopupMenu();
        this.myContextPopupMenu = this.createContextPopupMenu();
    }

    private void bindActions() {
        this.bindFieldActions();
        this.bindContextActions();
    }

    private void bindFieldActions() {
        ActionMap am1 = this.myFieldsDefinitionTree.getActionMap();
        InputMap[] ims1 = new InputMap[]{this.myFieldsDefinitionTree.getInputMap(1), this.myFieldsDefinitionTree.getInputMap()};
        this.bindSingleAction(this.myAddDataFieldAction, am1, ims1);
        this.bindSingleAction(this.myAddHierarchicalFieldAction, am1, ims1);
        this.bindSingleAction(this.myAddConditionAction, am1, ims1);
        this.bindSingleAction(this.myAddFieldGroupAction, am1, ims1);
        this.bindSingleAction(this.myImportAction, am1, ims1);
        this.bindSingleAction(this.mySaveAction, am1, ims1);
        this.bindSingleAction(this.myExportAction, am1, ims1);
        this.bindSingleAction(this.myFieldDeleteAction, am1, ims1);
        this.bindSingleAction(this.myFieldMoveUpAction, am1, ims1);
        this.bindSingleAction(this.myFieldMoveDownAction, am1, ims1);
        this.bindSingleAction(this.myFieldEnterGroupAction, am1, ims1);
        this.bindSingleAction(this.myFieldLeaveGroupAction, am1, ims1);
    }

    private void bindContextActions() {
        ActionMap am2 = this.myContextDefinitionTree.getActionMap();
        InputMap[] ims2 = new InputMap[]{this.myContextDefinitionTree.getInputMap(1), this.myContextDefinitionTree.getInputMap()};
        this.bindSingleAction(this.myAddContextAction, am2, ims2);
        this.bindSingleAction(this.myAddContextGroupAction, am2, ims2);
        this.bindSingleAction(this.myShowLinkTargetAction, am2, ims2);
        this.bindSingleAction(this.myImportAction, am2, ims2);
        this.bindSingleAction(this.mySaveAction, am2, ims2);
        this.bindSingleAction(this.myExportAction, am2, ims2);
        this.bindSingleAction(this.myContextDeleteAction, am2, ims2);
        this.bindSingleAction(this.myContextMoveUpAction, am2, ims2);
        this.bindSingleAction(this.myContextMoveDownAction, am2, ims2);
        this.bindSingleAction(this.myContextEnterGroupAction, am2, ims2);
        this.bindSingleAction(this.myContextLeaveGroupAction, am2, ims2);
    }

    private void bindSingleAction(Action action, ActionMap actionMap, InputMap[] inputMaps) {
        Object key = new Object();
        actionMap.put(key, action);
        for (InputMap inputMap : inputMaps) {
            KeyStroke ks = (KeyStroke)action.getValue("AcceleratorKey");
            inputMap.put(ks, key);
        }
    }

    private void createContextDefinitionTree() {
        this.myContextDefinitionTree = new ContextDefinitionTree(this.myContextDefinitionTreeModel, this.myFieldsDefinitionTree){

            @Override
            public Point getPopupLocation(MouseEvent event) {
                FieldsAndContextTabPanel.this.configureContextPopupMenu(event);
                return super.getPopupLocation(event);
            }
        };
        this.myContextDefinitionTree.setCellRenderer(new ServiceEditorTreeRenderer());
        this.myContextDefinitionTree.setComponentPopupMenu(this.myContextPopupMenu);
        this.myContextDefinitionTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FieldsAndContextTabPanel.this.enableContextMenuActions();
            }
        });
        this.mySelectionHandler.bindTree(this.myContextDefinitionTree, this);
    }

    private void createFieldDefinitionTree() {
        this.myFieldsDefinitionTree = new FieldsDefinitionTree(this.myFieldsDefinitionTreeModel){

            @Override
            public Point getPopupLocation(MouseEvent event) {
                FieldsAndContextTabPanel.this.configureFieldPopupMenu(event);
                return super.getPopupLocation(event);
            }
        };
        this.myFieldsDefinitionTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FieldsAndContextTabPanel.this.enableFieldMenuActions();
            }
        });
        this.myFieldsDefinitionTree.setCellRenderer(new ServiceEditorTreeRenderer());
        this.myFieldsDefinitionTree.setComponentPopupMenu(this.myFieldPopupMenu);
        this.mySelectionHandler.bindTree(this.myFieldsDefinitionTree, this);
    }

    public void addDataFieldAction(ActionEvent evt) {
        AbstractTreeNode currentNode = (AbstractTreeNode)((DefaultMutableTreeNode)this.myFieldsDefinitionTree.getSelectionPath().getLastPathComponent());
        FieldGroupNode.GroupType groupType = FieldGroupNode.GroupType.GROUP;
        if (currentNode != null) {
            TreeNode nodeToCheck = currentNode;
            if (currentNode instanceof FieldNode) {
                nodeToCheck = currentNode.getParent();
            }
            if (nodeToCheck instanceof FieldGroupNode) {
                groupType = ((FieldGroupNode)nodeToCheck).getGroupType();
            }
        }
        FieldNode newNode = this.myFieldsDefinitionTreeModel.addNewFieldNode(groupType, this.myFieldsDefinitionTree.getSelectionPath());
        this.myFieldsDefinitionTree.scrollPathToVisible(new TreePath(newNode.getPath()));
        this.myFieldsDefinitionTree.setSelectionPath(new TreePath(newNode.getPath()));
    }

    public void addHierarchicalDataFieldAction(ActionEvent evt) {
        HierarchicalFieldNode newNode = this.myFieldsDefinitionTreeModel.addNewHierarchicalFieldNode(this.myFieldsDefinitionTree.getSelectionPath(), null);
        this.myFieldsDefinitionTree.scrollPathToVisible(new TreePath(newNode.getPath()));
        this.myFieldsDefinitionTree.setSelectionPath(new TreePath(newNode.getPath()));
    }

    public void addConditionAction(ActionEvent evt) {
        FieldConditionNode newNode;
        TreePath selectedPath = this.myFieldsDefinitionTree.getSelectionPath();
        TreePath fieldNodePath = selectedPath;
        AbstractTreeNode currentNode = (AbstractTreeNode)fieldNodePath.getLastPathComponent();
        if (currentNode instanceof FieldConditionNode) {
            fieldNodePath = fieldNodePath.getParentPath();
        }
        if ("".equals((newNode = this.myFieldsDefinitionTreeModel.addNewFieldConditionNode(fieldNodePath)).getCondition())) {
            this.myFieldsDefinitionTreeModel.removeNodeFromParent(newNode);
            FieldNode fieldNode = (FieldNode)fieldNodePath.getLastPathComponent();
            this.myDialogFactory.getInformationDialog(this, "Problem when adding condition", "There are no conditions available for the data type \"" + fieldNode.getDataType() + "\"\nthat match the field settings");
        } else {
            this.myFieldsDefinitionTree.scrollPathToVisible(new TreePath(newNode.getPath()));
            this.myFieldsDefinitionTree.setSelectionPath(new TreePath(newNode.getPath()));
        }
    }

    public void addFieldGroupAction(ActionEvent evt) {
        FieldGroupNode newNode = this.myFieldsDefinitionTreeModel.addNewFieldGroupNode(this.myFieldsDefinitionTree.getSelectionPath());
        this.myFieldsDefinitionTree.scrollPathToVisible(new TreePath(newNode.getPath()));
        this.myFieldsDefinitionTree.setSelectionPath(new TreePath(newNode.getPath()));
    }

    public void showLinkTargetAction(ActionEvent evt) {
        TreePath aPath = this.myContextDefinitionTree.getSelectionPath();
        CommonLinkNode theLink = (CommonLinkNode)aPath.getLastPathComponent();
        Object target = theLink.getTarget();
        this.selectNode(this.myFieldsDefinitionTree, (AbstractTreeNode)target);
        this.myFieldsDefinitionTree.requestFocusInWindow();
    }

    public void moveFieldUpAction(ActionEvent evt) {
        AbstractTreeNode aNode = (AbstractTreeNode)this.myFieldsDefinitionTree.getSelectionPath().getLastPathComponent();
        if (this.myFieldsDefinitionTreeModel.moveUpOrDown(aNode, true)) {
            this.selectNode(this.myFieldsDefinitionTree, aNode);
        }
    }

    public void moveFieldDownAction(ActionEvent evt) {
        AbstractTreeNode aNode = (AbstractTreeNode)this.myFieldsDefinitionTree.getSelectionPath().getLastPathComponent();
        if (this.myFieldsDefinitionTreeModel.moveUpOrDown(aNode, false)) {
            this.selectNode(this.myFieldsDefinitionTree, aNode);
        }
    }

    public void enterGroupFieldAction(ActionEvent evt) {
        AbstractTreeNode aNode = (AbstractTreeNode)this.myFieldsDefinitionTree.getSelectionPath().getLastPathComponent();
        if (this.myFieldsDefinitionTreeModel.moveIntoGroup(aNode)) {
            this.selectNode(this.myFieldsDefinitionTree, aNode);
        }
    }

    public void leaveGroupFieldAction(ActionEvent evt) {
        AbstractTreeNode aNode = (AbstractTreeNode)this.myFieldsDefinitionTree.getSelectionPath().getLastPathComponent();
        if (this.myFieldsDefinitionTreeModel.moveOutOfGroup(aNode)) {
            this.selectNode(this.myFieldsDefinitionTree, aNode);
        }
    }

    public void moveContextUpAction(ActionEvent evt) {
        AbstractTreeNode aNode = (AbstractTreeNode)this.myContextDefinitionTree.getSelectionPath().getLastPathComponent();
        if (this.myContextDefinitionTreeModel.moveUpOrDown(aNode, true)) {
            this.selectNode(this.myContextDefinitionTree, aNode);
        }
    }

    public void moveContextDownAction(ActionEvent evt) {
        AbstractTreeNode aNode = (AbstractTreeNode)this.myContextDefinitionTree.getSelectionPath().getLastPathComponent();
        if (this.myContextDefinitionTreeModel.moveUpOrDown(aNode, false)) {
            this.selectNode(this.myContextDefinitionTree, aNode);
        }
    }

    public void enterGroupContextAction(ActionEvent evt) {
        AbstractTreeNode aNode = (AbstractTreeNode)this.myContextDefinitionTree.getSelectionPath().getLastPathComponent();
        if (this.myContextDefinitionTreeModel.moveIntoGroup(aNode)) {
            this.selectNode(this.myContextDefinitionTree, aNode);
        }
    }

    public void leaveGroupContextAction(ActionEvent evt) {
        AbstractTreeNode aNode = (AbstractTreeNode)this.myContextDefinitionTree.getSelectionPath().getLastPathComponent();
        if (this.myContextDefinitionTreeModel.moveOutOfGroup(aNode)) {
            this.selectNode(this.myContextDefinitionTree, aNode);
        }
    }

    public void deleteFieldAction(ActionEvent evt) {
        this.deleteFieldNode(true);
    }

    public void addContextAction(ActionEvent evt) {
        ContextNode newNode = this.myContextDefinitionTreeModel.addNewContextNode(this.myContextDefinitionTree.getSelectionPath());
        this.selectNode(this.myContextDefinitionTree, newNode);
    }

    public void addContextGroupAction(ActionEvent evt) {
        ContextGroupNode newNode = this.myContextDefinitionTreeModel.addNewContextGroupNode(this.myContextDefinitionTree.getSelectionPath());
        this.selectNode(this.myContextDefinitionTree, newNode);
    }

    public void deleteContextAction(ActionEvent evt) {
        this.deleteContextNode(true);
    }

    public void printClassAction(ActionEvent evt) {
        if (((JMenuItem)evt.getSource()).getAction() == this.myFieldPrintClassAction) {
            System.out.println("Class Name for node " + this.myFieldsDefinitionTree.getSelectionPath().getLastPathComponent().getClass());
        } else {
            System.out.println("Class Name for node " + this.myContextDefinitionTree.getSelectionPath().getLastPathComponent().getClass());
        }
    }

    public void printStructureAction(ActionEvent evt) {
        try {
            System.out.println(PrintServiceDefintion.print((DefaultMutableTreeNode)this.myFieldsDefinitionTreeModel.getRoot(), (DefaultMutableTreeNode)this.myContextDefinitionTreeModel.getRoot()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteFieldNode(boolean askFirst) {
        block4: {
            TreePath thePath = this.myFieldsDefinitionTree.getSelectionPath();
            AbstractTreeNode parent = (AbstractTreeNode)((AbstractTreeNode)thePath.getLastPathComponent()).getParent();
            boolean doDelete = true;
            if (askFirst) {
                doDelete = this.confirmDelete();
            }
            if (doDelete) {
                try {
                    this.myFieldsDefinitionTreeModel.deleteNode(thePath);
                }
                catch (ServiceEditorTreeModel.RemovalOfLinkTargetsNotPermittedException ex) {
                    Collection<AbstractTreeNode> linkTargets = ex.getLinkTargets();
                    boolean plural = linkTargets.size() > 1;
                    String fmt = "The entit%s %s %s used in one or more contexts.\nIf you continue, the entit%1$s will be removed from these contexts.\n\nDo you want to continue?";
                    String msg = String.format(fmt, plural ? "ies" : "y", StringUtil.joinSequenceAsSentence(new NodeNameTransformer(), linkTargets), plural ? "are" : "is");
                    if (!this.myDialogFactory.getQuestionDialogCustomButtons(this, "Delete Node", msg, "Yes", "No")) break block4;
                    ex.forceRemoval();
                    this.selectNode(this.myFieldsDefinitionTree, parent);
                }
            }
        }
    }

    private boolean confirmDelete() {
        return this.myDialogFactory.getQuestionDialog(this, RmaDefs.getStringResource("ratingrules.questions.confirmDelete.title"), RmaDefs.getStringResource("ratingrules.questions.confirmDelete.msg"));
    }

    private void selectNode(JTree tree, AbstractTreeNode node) {
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            tree.scrollPathToVisible(path);
            tree.setSelectionPath(path);
        }
    }

    private void deleteContextNode(boolean askFirst) {
        TreePath thePath = this.myContextDefinitionTree.getSelectionPath();
        AbstractTreeNode parent = (AbstractTreeNode)((AbstractTreeNode)thePath.getLastPathComponent()).getParent();
        boolean doDelete = true;
        if (askFirst) {
            doDelete = this.confirmDelete();
        }
        if (doDelete) {
            this.myContextDefinitionTreeModel.deleteNode(thePath);
            if (parent != null) {
                this.myContextDefinitionTree.scrollPathToVisible(new TreePath(parent.getPath()));
                this.myContextDefinitionTree.setSelectionPath(new TreePath(parent.getPath()));
            }
        }
    }

    private JPopupMenu createFieldPopupMenu() {
        this.myAddDataFieldAction.setEnabled(true);
        this.myAddConditionAction.setEnabled(true);
        this.myAddFieldGroupAction.setEnabled(true);
        this.myFieldDeleteAction.setEnabled(true);
        this.myFieldPrintClassMenuItem = new JMenuItem(this.myFieldPrintClassAction);
        this.myFieldPrintStructureMenuItem = new JMenuItem(this.myFieldPrintStructureAction);
        JPopupMenu theMenu = new JPopupMenu();
        JMenuItem groupItem = new JMenuItem(this.myAddFieldGroupAction);
        groupItem.setName("FieldsAndContextTabPanel.menu.add-group");
        theMenu.add(groupItem);
        JMenuItem menuItem = new JMenuItem(this.myAddDataFieldAction);
        menuItem.setName("FieldsAndContextTabPanel.menu.add-datafield");
        theMenu.add(menuItem);
        menuItem = new JMenuItem(this.myAddHierarchicalFieldAction);
        menuItem.setName("FieldsAndContextTabPanel.menu.add-hierarchicalfield");
        theMenu.add(menuItem);
        menuItem = new JMenuItem(this.myAddConditionAction);
        menuItem.setName("FieldsAndContextTabPanel.menu.add-condition");
        theMenu.add(menuItem);
        theMenu.addSeparator();
        theMenu.add(new JMenuItem(this.myImportAction));
        JMenuItem saveMenuItem = new JMenuItem(this.mySaveAction);
        saveMenuItem.setName("ServiceEditor.FieldsTreePopupMenu.MenuItem.Save");
        theMenu.add(saveMenuItem);
        theMenu.add(new JMenuItem(this.myExportAction));
        theMenu.addSeparator();
        theMenu.add(this.myFieldPrintClassMenuItem);
        theMenu.add(this.myFieldPrintStructureMenuItem);
        theMenu.addSeparator();
        theMenu.add(new JMenuItem(this.myFieldDeleteAction));
        theMenu.addSeparator();
        theMenu.add(new JMenuItem(this.myFieldMoveUpAction));
        theMenu.add(new JMenuItem(this.myFieldMoveDownAction));
        theMenu.add(new JMenuItem(this.myFieldEnterGroupAction));
        theMenu.add(new JMenuItem(this.myFieldLeaveGroupAction));
        return theMenu;
    }

    private JPopupMenu createContextPopupMenu() {
        this.myAddContextAction.setEnabled(true);
        this.myAddContextGroupAction.setEnabled(true);
        this.myShowLinkTargetAction.setEnabled(true);
        this.myContextDeleteAction.setEnabled(true);
        this.myContextPrintClassMenuItem = new JMenuItem(this.myContextPrintClassAction);
        this.myContextPrintStructureMenuItem = new JMenuItem(this.myContextPrintStructureAction);
        JPopupMenu theMenu = new JPopupMenu();
        theMenu.add(new JMenuItem(this.myAddContextAction));
        theMenu.add(new JMenuItem(this.myAddContextGroupAction));
        theMenu.addSeparator();
        theMenu.add(new JMenuItem(this.myImportAction));
        theMenu.add(new JMenuItem(this.mySaveAction));
        theMenu.add(new JMenuItem(this.myExportAction));
        theMenu.addSeparator();
        theMenu.add(this.myContextPrintClassMenuItem);
        theMenu.add(this.myContextPrintStructureMenuItem);
        theMenu.addSeparator();
        theMenu.add(new JMenuItem(this.myShowLinkTargetAction));
        theMenu.addSeparator();
        theMenu.add(new JMenuItem(this.myContextDeleteAction));
        theMenu.addSeparator();
        theMenu.add(new JMenuItem(this.myContextMoveUpAction));
        theMenu.add(new JMenuItem(this.myContextMoveDownAction));
        theMenu.add(new JMenuItem(this.myContextEnterGroupAction));
        theMenu.add(new JMenuItem(this.myContextLeaveGroupAction));
        return theMenu;
    }

    private void configureFieldPopupMenu(MouseEvent e) {
        this.enableFieldMenuActions();
        this.enableMenuExtensions(this.myFieldPopupMenu, e);
    }

    private void configureContextPopupMenu(MouseEvent e) {
        this.enableContextMenuActions();
        this.enableMenuExtensions(this.myContextPopupMenu, e);
    }

    private void enableFieldMenuActions() {
        TreePath thePath = this.myFieldsDefinitionTree.getSelectionPath();
        AbstractTreeNode theNode = null;
        this.myAddHierarchicalFieldAction.setEnabled(false);
        this.myAddDataFieldAction.setEnabled(false);
        this.myAddConditionAction.setEnabled(false);
        this.myAddFieldGroupAction.setEnabled(false);
        this.myFieldDeleteAction.setEnabled(false);
        this.myFieldMoveUpAction.setEnabled(false);
        this.myFieldMoveDownAction.setEnabled(false);
        this.myFieldLeaveGroupAction.setEnabled(false);
        this.myFieldEnterGroupAction.setEnabled(false);
        if (thePath != null) {
            theNode = (AbstractTreeNode)thePath.getLastPathComponent();
        }
        if (theNode != null && !(theNode instanceof FieldTopNode)) {
            if (theNode instanceof CommonFieldsGroupNode) {
                this.myAddDataFieldAction.setEnabled(true);
                this.myAddFieldGroupAction.setEnabled(true);
                this.myAddHierarchicalFieldAction.setEnabled(true);
            } else if (theNode instanceof ContextFieldsGroupNode) {
                this.myAddDataFieldAction.setEnabled(true);
                this.myAddFieldGroupAction.setEnabled(true);
                this.myAddHierarchicalFieldAction.setEnabled(true);
            } else if (theNode instanceof FieldNode) {
                this.myAddDataFieldAction.setEnabled(true);
                this.myAddConditionAction.setEnabled(true);
                List<Variable> list = ((FieldNode)theNode).getVariablesForEditing(this.myTableModel);
                Variable var = VarListUtil.getVariableForName(list, "Parameter type");
                if ("WORKING".equalsIgnoreCase(var.getValueString())) {
                    this.myAddConditionAction.setEnabled(false);
                }
                this.myFieldDeleteAction.setEnabled(true);
                this.myFieldMoveUpAction.setEnabled(true);
                this.myFieldMoveDownAction.setEnabled(true);
                if (!((FieldNode)theNode).isStrictArray()) {
                    this.myFieldLeaveGroupAction.setEnabled(true);
                    this.myFieldEnterGroupAction.setEnabled(true);
                }
            } else if (theNode instanceof FieldGroupNode) {
                this.myAddDataFieldAction.setEnabled(true);
                if (!((FieldGroupNode)theNode).isComplexGroup()) {
                    this.myAddFieldGroupAction.setEnabled(true);
                }
                this.myFieldDeleteAction.setEnabled(true);
                this.myFieldMoveUpAction.setEnabled(true);
                this.myFieldMoveDownAction.setEnabled(true);
                this.myFieldEnterGroupAction.setEnabled(true);
                this.myFieldLeaveGroupAction.setEnabled(true);
            } else if (theNode instanceof FieldConditionNode) {
                this.myAddConditionAction.setEnabled(true);
                this.myFieldDeleteAction.setEnabled(true);
                this.myFieldMoveUpAction.setEnabled(true);
                this.myFieldMoveDownAction.setEnabled(true);
            } else if (theNode instanceof HierarchicalFieldNode) {
                this.myAddDataFieldAction.setEnabled(true);
                HierarchicalFieldNode theHierarchicalNode = (HierarchicalFieldNode)theNode;
                if (theHierarchicalNode.getComplexType() == FieldConfig.ComplexType.NONE) {
                    this.myAddHierarchicalFieldAction.setEnabled(true);
                }
                this.myFieldDeleteAction.setEnabled(true);
                this.myFieldMoveUpAction.setEnabled(true);
                this.myFieldMoveDownAction.setEnabled(true);
                this.myFieldEnterGroupAction.setEnabled(true);
                this.myFieldLeaveGroupAction.setEnabled(true);
            }
        }
    }

    private void enableContextMenuActions() {
        TreePath thePath = this.myContextDefinitionTree.getSelectionPath();
        AbstractTreeNode theNode = null;
        this.myAddContextAction.setEnabled(false);
        this.myAddContextGroupAction.setEnabled(false);
        this.myShowLinkTargetAction.setEnabled(false);
        this.myContextDeleteAction.setEnabled(false);
        this.myContextMoveUpAction.setEnabled(false);
        this.myContextMoveDownAction.setEnabled(false);
        this.myContextEnterGroupAction.setEnabled(false);
        this.myContextLeaveGroupAction.setEnabled(false);
        if (thePath != null) {
            theNode = (AbstractTreeNode)thePath.getLastPathComponent();
        }
        if (theNode != null) {
            if (theNode instanceof ContextTopNode) {
                this.myAddContextAction.setEnabled(true);
            } else if (theNode instanceof ContextNode) {
                this.myAddContextGroupAction.setEnabled(true);
                this.myContextDeleteAction.setEnabled(true);
                this.myContextMoveUpAction.setEnabled(true);
                this.myContextMoveDownAction.setEnabled(true);
            } else if (theNode instanceof ContextGroupNode) {
                this.myAddContextGroupAction.setEnabled(true);
                this.myContextDeleteAction.setEnabled(true);
                this.myContextMoveUpAction.setEnabled(true);
                this.myContextMoveDownAction.setEnabled(true);
                this.myContextEnterGroupAction.setEnabled(true);
                this.myContextLeaveGroupAction.setEnabled(true);
            } else if (theNode instanceof CommonLinkNode) {
                this.myAddContextGroupAction.setEnabled(false);
                this.myShowLinkTargetAction.setEnabled(true);
                this.myContextDeleteAction.setEnabled(true);
                this.myContextMoveUpAction.setEnabled(true);
                this.myContextMoveDownAction.setEnabled(true);
                this.myContextEnterGroupAction.setEnabled(true);
                this.myContextLeaveGroupAction.setEnabled(true);
                this.myShowLinkTargetAction.putValue("Name", this.getShowLinkLabel(theNode));
            }
        }
    }

    private String getShowLinkLabel(AbstractTreeNode theNode) {
        String label = "Show target";
        if (theNode instanceof FieldLinkNode) {
            label = LABEL_SHOW_FIELD;
        } else if (theNode instanceof FieldGroupLinkNode) {
            label = LABEL_SHOW_GROUP;
        }
        return label;
    }

    private void enableMenuExtensions(JPopupMenu aPopupMenu, MouseEvent e) {
        boolean extendedTrigger = e.isShiftDown() && e.isControlDown();
        this.myFieldPrintClassMenuItem.setVisible(extendedTrigger);
        this.myFieldPrintStructureMenuItem.setVisible(extendedTrigger);
        int separatorIndex = this.myFieldPopupMenu.getComponentIndex(this.myFieldPrintStructureMenuItem) + 1;
        this.myFieldPopupMenu.getComponent(separatorIndex).setVisible(extendedTrigger);
        this.myContextPrintClassMenuItem.setVisible(extendedTrigger);
        this.myContextPrintStructureMenuItem.setVisible(extendedTrigger);
        separatorIndex = this.myContextPopupMenu.getComponentIndex(this.myContextPrintStructureMenuItem) + 1;
        this.myContextPopupMenu.getComponent(separatorIndex).setVisible(extendedTrigger);
    }

    public JTree getContextTree() {
        return this.myContextDefinitionTree;
    }

    public JTree getFieldsTree() {
        return this.myFieldsDefinitionTree;
    }

    private static class NodeNameTransformer
    implements Transformer<AbstractTreeNode, String> {
        private NodeNameTransformer() {
        }

        @Override
        public String transform(AbstractTreeNode input) {
            return "\"" + input.getName() + "\"";
        }
    }
}

