/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.datarepository;

import com.ericsson.ere.defs.DataRepositoryModel;
import com.ericsson.ere.defs.DataRepositoryModelListener;
import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositorySortedListModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DataRepositorySortedListModelImpl
implements DataRepositorySortedListModel,
DataRepositoryModelListener {
    private DataRepositoryModel myDataRepositoryModel;
    private List<Map.Entry<String, DataRepositoryModel.RepositoryDataType>> myKeyEntryList;
    private List<ListDataListener> myListeners = new LinkedList<ListDataListener>();

    public DataRepositorySortedListModelImpl(DataRepositoryModel dataRepositoryModel) {
        if (dataRepositoryModel == null) {
            throw new IllegalArgumentException("Data repository model must be non-null.");
        }
        dataRepositoryModel.addDataRepositoryListener(this);
        this.myDataRepositoryModel = dataRepositoryModel;
        this.initDataRepositoryModel();
    }

    private void initDataRepositoryModel() {
        this.myKeyEntryList = new ArrayList<Map.Entry<String, DataRepositoryModel.RepositoryDataType>>(this.myDataRepositoryModel.keyEntrySet());
        Collections.sort(this.myKeyEntryList, new HumanFriendlyStringComparator());
    }

    @Override
    public DataRepositoryModel getDataRepositoryModel() {
        return this.myDataRepositoryModel;
    }

    @Override
    public DataRepositoryModel.RepositoryDataType getRepositoryDataTypeAt(int index) {
        DataRepositoryModel.RepositoryDataType returnValue = null;
        if (0 <= index && index < this.myKeyEntryList.size()) {
            returnValue = this.myKeyEntryList.get(index).getValue();
        }
        return returnValue;
    }

    @Override
    public int getIndexOf(String name) {
        int returnValue = -1;
        for (int i = 0; name != null && i < this.myKeyEntryList.size(); ++i) {
            Map.Entry<String, DataRepositoryModel.RepositoryDataType> entry = this.myKeyEntryList.get(i);
            if (!name.equals(entry.getKey())) continue;
            returnValue = i;
            break;
        }
        return returnValue;
    }

    @Override
    public int getSize() {
        return this.myKeyEntryList.size();
    }

    public String getElementAt(int index) {
        String returnValue = null;
        if (0 <= index && index < this.myKeyEntryList.size()) {
            returnValue = this.myKeyEntryList.get(index).getKey();
        }
        return returnValue;
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
        if (listener != null) {
            this.myListeners.add(listener);
        }
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        if (listener != null) {
            this.myListeners.remove(listener);
        }
    }

    @Override
    public void repositoryUpdated() {
        this.initDataRepositoryModel();
        this.fireListeners();
    }

    private void fireListeners() {
        for (ListDataListener listener : this.myListeners) {
            listener.contentsChanged(new ListDataEvent(this, 0, 0, this.getSize() - 1));
        }
    }

    private static class HumanFriendlyStringComparator
    implements Comparator<Map.Entry<String, DataRepositoryModel.RepositoryDataType>> {
        private HumanFriendlyStringComparator() {
        }

        @Override
        public int compare(Map.Entry<String, DataRepositoryModel.RepositoryDataType> o1, Map.Entry<String, DataRepositoryModel.RepositoryDataType> o2) {
            int returnValue = o1.getKey().compareToIgnoreCase(o2.getKey());
            if (returnValue == 0) {
                returnValue = o1.getKey().compareTo(o2.getKey());
            }
            return returnValue;
        }
    }
}

