/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.datarepository;

import com.ericsson.ere.defs.DataRepositoryModel;
import com.ericsson.ere.defs.DataTypeBasedValueType;
import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositoryEditView;
import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositoryListView;
import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositorySortedListModel;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class DataRepositoryListPresenter {
    private DataRepositoryListView myListView;
    private DataRepositorySortedListModel myListModel;
    private DataRepositoryEditView myEditView;
    private static final String UCOMMITTED_MESSAGE = "Selected element has been edited but not commited. Commit or cancel changes before continuing.";

    public DataRepositoryListPresenter(DataRepositoryListView listView, DataRepositoryEditView editView, DataRepositorySortedListModel listModel) {
        if (listModel == null || listView == null || editView == null) {
            throw new IllegalArgumentException("Data repository list model, list view and edit view must be non-null.");
        }
        this.myListView = listView;
        this.myListModel = listModel;
        this.myEditView = editView;
        this.subscribeToViewEvents();
    }

    private void subscribeToViewEvents() {
        this.myListView.listSelectionEvent().addActionListener(new ListSelectionAction());
        this.myListView.addElementEvent().addActionListener(new AddAction());
        this.myListView.deleteElementEvent().addActionListener(new DeleteAction());
    }

    private String getUniqueName(String name) {
        String tmpName;
        DataRepositoryModel dataRepositoryModel = this.myListModel.getDataRepositoryModel();
        if (dataRepositoryModel.exists(tmpName = name)) {
            int i = 2;
            tmpName = tmpName + " ";
            while (dataRepositoryModel.exists(tmpName + i)) {
                ++i;
            }
            tmpName = tmpName + i;
        }
        return tmpName;
    }

    private class DeleteAction
    extends AbstractAction {
        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataRepositoryListPresenter.this.myEditView.isCommitted()) {
                int selectedIndex = DataRepositoryListPresenter.this.myListView.getSelectedIndex();
                if (selectedIndex >= 0) {
                    String selectedElement = (String)DataRepositoryListPresenter.this.myListModel.getElementAt(selectedIndex);
                    DataRepositoryListPresenter.this.myListModel.getDataRepositoryModel().remove(selectedElement);
                    int newSelectionIndex = Math.min(selectedIndex, DataRepositoryListPresenter.this.myListModel.getSize() - 1);
                    DataRepositoryListPresenter.this.myListView.setSelectedIndex(newSelectionIndex);
                }
            } else {
                DataRepositoryListPresenter.this.myListView.showInformation(DataRepositoryListPresenter.UCOMMITTED_MESSAGE);
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataRepositoryListPresenter.this.myEditView.isCommitted()) {
                String defaultName = "Element name";
                String uniqueName = DataRepositoryListPresenter.this.getUniqueName(defaultName);
                DataRepositoryListPresenter.this.myListModel.getDataRepositoryModel().addValue(uniqueName, DataTypeBasedValueType.createValueType(DataType.STRING, new ClassRepository()), "");
                int index = DataRepositoryListPresenter.this.myListModel.getIndexOf(uniqueName);
                DataRepositoryListPresenter.this.myListView.setSelectedIndex(index);
            } else {
                DataRepositoryListPresenter.this.myListView.showInformation(DataRepositoryListPresenter.UCOMMITTED_MESSAGE);
            }
        }
    }

    private class ListSelectionAction
    extends AbstractAction {
        private ListSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedIndex = DataRepositoryListPresenter.this.myListView.getSelectedIndex();
            DataRepositoryListPresenter.this.myListView.setDeleteEnabled(selectedIndex >= 0);
        }
    }
}

