/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.datarepository;

import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositoryEditView;
import com.ericsson.ere.gui.mvp.AbstractViewPanel;
import com.ericsson.ere.swing.EventSource;
import ericsson.ere.defs.RmaDefs;
import ericsson.vareditor.VarTable2;
import ericsson.vareditor.VarTableModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class DataRepositoryEditPanel
extends AbstractViewPanel
implements DataRepositoryEditView {
    private EventSource myCommitEvent = new EventSource();
    private EventSource myCancelEvent = new EventSource();
    private JButton myCommitButton;
    private JButton myCancelButton;
    private VarTable2 myVarTable;
    private JPanel myDataPanel = this.initEditPanel();
    private JPanel myEmptyPanel = this.initEmptyPanel();
    private boolean isCommitted = true;
    private boolean isEditVisible = true;

    public DataRepositoryEditPanel() {
        super(new GridBagLayout(), "Element edit", "service");
        this.showEditView(false);
    }

    private JPanel initEditPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.myVarTable = new VarTable2();
        this.myCommitButton = this.myCommitEvent.createButton("Commit", RmaDefs.getImageIcon("commit_edit.png"), "Commit changes");
        this.myCancelButton = this.myCancelEvent.createButton("Cancel", RmaDefs.getImageIcon("cancel_edit.png"), "Cancel changes");
        panel.add((Component)this.myVarTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)this.buildButtonToolBar(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JToolBar buildButtonToolBar() {
        JToolBar buttonToolbar = new JToolBar();
        buttonToolbar.setFloatable(false);
        buttonToolbar.add(Box.createHorizontalGlue());
        buttonToolbar.add(this.myCommitButton);
        buttonToolbar.add(this.myCancelButton);
        return buttonToolbar;
    }

    private JPanel initEmptyPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel("Select a data element in the list to view or edit it."));
        return panel;
    }

    @Override
    public EventSource commitEvent() {
        return this.myCommitEvent;
    }

    @Override
    public EventSource cancelEvent() {
        return this.myCancelEvent;
    }

    @Override
    public void setCommitted(boolean committed) {
        this.myCommitButton.setEnabled(!committed);
        this.myCancelButton.setEnabled(!committed);
        this.isCommitted = committed;
    }

    @Override
    public boolean isCommitted() {
        return this.isCommitted;
    }

    @Override
    public void setVarTableModel(VarTableModel model) {
        this.myVarTable.setTableModel(model);
    }

    @Override
    public void showEditView(boolean visible) {
        if (this.isEditVisible != visible) {
            if (visible) {
                this.remove(this.myEmptyPanel);
                this.add((Component)this.myDataPanel, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                this.remove(this.myDataPanel);
                this.add(this.myEmptyPanel);
            }
            this.revalidate();
            this.repaint();
            this.isEditVisible = visible;
        }
    }
}

