/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.constraint.handler;

import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.PluginName;
import ericsson.ere.exception.NotImplementedException;
import java.util.ArrayList;
import java.util.List;

public enum ConstraintType {
    PLUGIN_CONSTRAINT{}
    ,
    FIELD_CONSTRAINT{};


    public static List<String> getConstraintTargetsForType(ConstraintType type, ClassRepository repository) {
        ArrayList<String> resultList = new ArrayList<String>();
        switch (type) {
            case FIELD_CONSTRAINT: {
                ArrayList<FieldDefinition> tempList = new ArrayList<FieldDefinition>();
                tempList.addAll(repository.getOutputFieldDefinitions());
                tempList.addAll(repository.getInputFieldDefinitions());
                for (FieldDefinition def : tempList) {
                    resultList.add(def.getFieldName());
                }
                return resultList;
            }
            case PLUGIN_CONSTRAINT: {
                List<PluginName> list = repository.getBaseConditionList();
                for (PluginName name : list) {
                    resultList.add(name.getAlias());
                }
                return resultList;
            }
        }
        throw new NotImplementedException("Unknown ConstraintType");
    }
}

