/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.actions;

import com.ericsson.ere.constraint.ConstraintModel;
import com.ericsson.ere.constraint.entity.Constrainable;
import com.ericsson.ere.constraint.entity.Constraint;
import com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.ConstraintAddEditDialog;
import com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.actions.ConstraintActionHandler;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.management.Service;
import java.awt.Window;
import java.util.List;

public class ConstraintActionHandlerImpl
extends ConstraintActionHandler {
    private ConstraintModel myConstraintModel;
    private Service myService;

    public ConstraintActionHandlerImpl(ConstraintModel constraintModel, Service theService) {
        this.myConstraintModel = constraintModel;
        this.myService = theService;
    }

    @Override
    public void deleteConstrainableAction(Constrainable id) {
        boolean delete = DialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), "Remove Constrainable", "Are you sure you want to delete the selected constrainable?");
        if (delete) {
            List<Constraint> constraintsToDelete = null;
            constraintsToDelete = id.isGeneral() ? this.myConstraintModel.getGeneralConstraintsFromConstrainableType(id.getType()) : this.myConstraintModel.getConstraintListForConstrainable(id, true);
            for (Constraint con : constraintsToDelete) {
                this.myConstraintModel.removeConstraint(con);
            }
        }
    }

    @Override
    public Constraint showAddConstraintDialog(ConstraintAddEditDialog.ConstraintDialogDataSource source) {
        Constraint resultingConstraint = null;
        try {
            ConstraintAddEditDialog constraintDialog = new ConstraintAddEditDialog((Window)GuiServiceCenter.getInstance().getMainWindow(), this.myService.getClassRepository(), source);
            constraintDialog.setVisible(true);
            resultingConstraint = constraintDialog.getConstraintObject();
            if (resultingConstraint != null) {
                if (this.myConstraintModel.alreadyInModel(resultingConstraint)) {
                    DialogFactory.getErrorDialog("Failed to add new constraint", "The constraint could not be added since it already exist");
                    return this.showAddConstraintDialog(source);
                }
                if (!this.myConstraintModel.addConstraint(constraintDialog.getConstraintObject())) {
                    DialogFactory.getErrorDialog("Failed to add new constraint", "The constraint could not be added since it is in conflict with an existing constraint");
                    return this.showAddConstraintDialog(source);
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.handleCNFException(e);
        }
        return resultingConstraint;
    }

    private boolean doesConstraintDiffer(Constraint obj1, Constraint obj2) {
        return !obj1.equals(obj2) || obj1.isInclude() != obj2.isInclude();
    }

    @Override
    public Constraint showConstraintSettingDialog(Constraint constraintToEdit, ConstraintAddEditDialog.ConstraintDialogDataSource source) {
        Constraint resultingConstraint = null;
        try {
            Constraint clone = (Constraint)constraintToEdit.clone();
            ConstraintAddEditDialog constraintDialog = new ConstraintAddEditDialog((Window)GuiServiceCenter.getInstance().getMainWindow(), this.myService.getClassRepository(), source, constraintToEdit);
            constraintDialog.showMe();
            Constraint con = constraintDialog.getConstraintObject();
            if (con != null && this.doesConstraintDiffer(con, clone)) {
                this.myConstraintModel.removeConstraint(constraintToEdit);
                if (this.myConstraintModel.alreadyInModel(con)) {
                    this.myConstraintModel.addConstraint(clone);
                    DialogFactory.getErrorDialog("Failed to add new constraint", "The constraint could not be added since it already exist");
                    this.showConstraintSettingDialog(constraintToEdit, source);
                }
                if (!this.myConstraintModel.addConstraint(constraintDialog.getConstraintObject())) {
                    this.myConstraintModel.addConstraint(clone);
                    DialogFactory.getErrorDialog("Failed to add edit constraint", "The constraint could not be updated since it is in conflict with an existing constraint");
                    this.showConstraintSettingDialog(constraintToEdit, source);
                } else {
                    resultingConstraint = con;
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.handleCNFException(e);
        }
        return resultingConstraint;
    }

    private void handleCNFException(ClassNotFoundException e) {
        RmaDefs.loggerRma.severe("Failed to instantiate ConstraintDialogDataSource, exception = " + e);
        String msg = "Failed to show settings for constraint \nDetails: " + e.getMessage();
        DialogFactory.getErrorDialog("Constraint error", msg);
    }

    @Override
    public void deleteConstraint(Constraint constraintToRemove) {
        this.myConstraintModel.removeConstraint(constraintToRemove);
    }

    @Override
    public void showDeleteNotAllowedDialog() {
        DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Delete not allowed", "You can't delete a constraint that applies to other constraints from here,\nplease selected a general constrainable and delete from there.");
    }
}

