/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.swing.TreeModelAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class TreeNodeChangeTracker
implements PropertyChangeListener {
    private DefaultTreeModel myModel;

    public TreeNodeChangeTracker(DefaultTreeModel model) {
        this.myModel = model;
        this.addAsListenerRecursively((AbstractTreeNode)model.getRoot());
        this.myModel.addTreeModelListener(new ModelListener());
    }

    private void addAsListenerRecursively(AbstractTreeNode node) {
        node.addPropertyChangeListener(this);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.addAsListenerRecursively((AbstractTreeNode)node.getChildAt(i));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean changeToRoot = "___varlistvalid".equals(evt.getPropertyName());
        TreeNode node = (TreeNode)evt.getSource();
        do {
            this.myModel.nodeChanged(node);
        } while ((node = node.getParent()) != null && changeToRoot);
    }

    private class ModelListener
    extends TreeModelAdapter {
        private ModelListener() {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            List<AbstractTreeNode> nodes = this.getNodes(e.getChildren());
            for (AbstractTreeNode node : nodes) {
                node.addPropertyChangeListener(TreeNodeChangeTracker.this);
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            List<AbstractTreeNode> nodes = this.getNodes(e.getChildren());
            for (AbstractTreeNode node : nodes) {
                node.removePropertyChangeListener(TreeNodeChangeTracker.this);
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            List<AbstractTreeNode> nodes = this.getNodes(new Object[]{e.getTreePath().getLastPathComponent()});
            for (AbstractTreeNode node : nodes) {
                node.removePropertyChangeListener(TreeNodeChangeTracker.this);
                node.addPropertyChangeListener(TreeNodeChangeTracker.this);
            }
        }

        private List<AbstractTreeNode> getNodes(Object[] children) {
            ArrayList<AbstractTreeNode> list = new ArrayList<AbstractTreeNode>();
            if (children != null) {
                for (Object child : children) {
                    AbstractTreeNode tn = (AbstractTreeNode)child;
                    this.addToList(list, tn);
                }
            }
            return list;
        }

        private void addToList(List<AbstractTreeNode> list, AbstractTreeNode tn) {
            list.add(tn);
            for (int i = 0; i < tn.getChildCount(); ++i) {
                this.addToList(list, (AbstractTreeNode)tn.getChildAt(i));
            }
        }
    }
}

