/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.propertyeditor;

import com.ericsson.ere.gui.editors.interfaces.ProxySettingsEditorInterface;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.propertieseditor.EditablePropertiesInterface;
import ericsson.ere.gui.propertieseditor.PropertiesEditor;
import ericsson.ere.gui.propertieseditor.PropertiesException;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.settingsmap.Parameter;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.integration.settingsmap.propertyio.VarTableInput;
import ericsson.ere.integration.settingsmap.propertyio.VarTableOutput;
import ericsson.vareditor.VarTableModel;
import java.util.Vector;

public class DefaultServiceProxySettingsEditor
implements ProxySettingsEditorInterface {
    @Override
    public void performEdit(AbstractEreProxy abstractProxy) {
        if (abstractProxy instanceof ServiceProxy) {
            final ServiceProxy serviceProxy = (ServiceProxy)abstractProxy;
            SettingsMap map = serviceProxy.getSettingsMap();
            Parameter property = map.getParameter("Name");
            if (serviceProxy.isServiceUsed()) {
                if (property != null) {
                    property.setLocked(true);
                }
            } else if (property != null) {
                property.setLocked(false);
            }
            VarTableModel oldSettings = VarTableOutput.writeToVarTableModel(map);
            PropertiesEditor.showDialogEdit(oldSettings, "Properties for '" + serviceProxy.getName() + "'", new EditablePropertiesInterface(){
                private boolean updateSuccess = true;

                @Override
                public void cancel() {
                }

                @Override
                public String getTitle() {
                    return "Edit Service";
                }

                @Override
                public void update(VarTableModel model) throws PropertiesException {
                    SettingsMap newSettings = VarTableInput.readFromVarTableModel(model);
                    if (!RatingPlanProxy.validateName(newSettings.getParameterAsString("Name"))) {
                        throw new PropertiesException("The service name contains invalid characters.\nCharacters \\ / : * ? ; \" are not valid.");
                    }
                    try {
                        RatingManagerProxy manager = serviceProxy.getRatingManagerProxy();
                        Vector<ServiceProxy> siblings = manager.getServiceListProxy().getServiceList();
                        String oldServiceName = serviceProxy.getName();
                        if (siblings.size() > 1) {
                            for (int i = 0; i < siblings.size(); ++i) {
                                if (!siblings.get(i).equals(serviceProxy) && !oldServiceName.equals(siblings.get(i).getName())) continue;
                            }
                        }
                        if (newSettings.getParameterAsString("Name").trim().isEmpty()) {
                            DialogFactory.getErrorDialog(GuiServiceCenter.getInstance().getMainWindow(), "Service 'Name' field value error", "Empty value not allowed for field 'Name'.");
                            this.updateSuccess = false;
                            return;
                        }
                        serviceProxy.updateService(newSettings);
                        this.updateSuccess = true;
                    }
                    catch (Exception e) {
                        ExceptionUtil.handleException(e, "navigator", 1, "Failed to set new properties for the Service.", false);
                        String infoMessage = "Failed to set new properties for the Service";
                        infoMessage = e.getMessage() != null ? infoMessage + ":\n" + e.getMessage() : infoMessage + ".";
                        DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Invalid input", infoMessage);
                        this.updateSuccess = false;
                    }
                }

                @Override
                public boolean isSuccessful() {
                    return this.updateSuccess;
                }
            });
        }
    }
}

