/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.propertyeditor;

import com.ericsson.ere.gui.editors.interfaces.SaveAsProxyEditorInterface;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.propertieseditor.EditablePropertiesInterface;
import ericsson.ere.gui.propertieseditor.PropertiesEditor;
import ericsson.ere.gui.propertieseditor.PropertiesException;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.integration.settingsmap.propertyio.VarTableInput;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.documents.StringDocument;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Element;

public class DefaultSaveAsRatingPeriodProxyEditor
implements SaveAsProxyEditorInterface {
    private RatingPeriodProxy myNewRatingPeriodProxy;
    private boolean successfulEdit = true;
    private boolean requiresOverwriting;

    @Override
    public void performNew(final RatingPlanProxy planProxy) {
        final RatingManagerProxy ratingManagerProxy = planProxy.getRatingManagerProxy();
        RatingPlanProxy ratingPlanProxy = planProxy;
        ServiceProviderProxy serviceProviderProxy = ratingPlanProxy.getServiceProviderProxy();
        Vector<RatingPlanProxy> ratingPlanList = serviceProviderProxy.getRatingPlanList();
        StringVariable serviceProviderVariable = new StringVariable("Service provider");
        serviceProviderVariable.setValue(serviceProviderProxy.getName());
        serviceProviderVariable.setAllowEdit(false);
        StringVariable serviceVariable = new StringVariable("Service");
        serviceVariable = new StringVariable("Service", ratingPlanProxy.getServiceName());
        ((Variable)serviceVariable).setAllowEdit(false);
        ArrayList<String> compatibleRatingPlans = new ArrayList<String>();
        for (int i = 0; i < ratingPlanList.size(); ++i) {
            RatingPlanProxy proxy = ratingPlanList.get(i);
            if (!proxy.getServiceName().equals(ratingPlanProxy.getServiceName())) continue;
            compatibleRatingPlans.add(proxy.getName());
        }
        DropDownVariable ratingPlanVariable = new DropDownVariable("Ratingplan", 0, compatibleRatingPlans.toArray());
        ratingPlanVariable.setSelectedItem(ratingPlanProxy.getName());
        StringVariable nameVariable = new StringVariable("Name", "", new StringDocument(false));
        DateAndTimeVariable startDateVariable = new DateAndTimeVariable("Start date", DateAndTimeVariable.Content.DATE_TIME, "99990101T000000000");
        VarTableModel newSettings = new VarTableModel();
        newSettings.addRow(serviceProviderVariable);
        newSettings.addRow(serviceVariable);
        newSettings.addRow(ratingPlanVariable);
        newSettings.addRow(nameVariable);
        newSettings.addRow(startDateVariable);
        PropertiesEditor.showDialogEdit(newSettings, "New rating period", new EditablePropertiesInterface(){

            @Override
            public void cancel() {
            }

            @Override
            public String getTitle() {
                return null;
            }

            @Override
            public void update(VarTableModel model) throws PropertiesException {
                DefaultSaveAsRatingPeriodProxyEditor.this.successfulEdit = true;
                SettingsMap newSettings = VarTableInput.readFromVarTableModel(model);
                for (int i = 0; i < model.getRowCount(); ++i) {
                    Variable var = (Variable)model.getValueAt(i, 1);
                    if (!var.isValueValid()) {
                        DefaultSaveAsRatingPeriodProxyEditor.this.showErrorDialog(var);
                        return;
                    }
                    if (!var.getValueString().trim().isEmpty()) continue;
                    DefaultSaveAsRatingPeriodProxyEditor.this.showErrorDialog(var);
                    return;
                }
                if (!RatingPlanProxy.validateName(newSettings.getParameterAsString("Name"))) {
                    throw new PropertiesException("The rating period name contains invalid characters.\nCharacters \\ / : * ? ; \" are not valid.");
                }
                if (DefaultSaveAsRatingPeriodProxyEditor.this.successfulEdit) {
                    ServiceListProxy serviceListProxy = ratingManagerProxy.getServiceListProxy();
                    ServiceProxy serviceProxy = serviceListProxy.getServiceProxy(newSettings.getParameterAsString("Service"));
                    DefaultSaveAsRatingPeriodProxyEditor.this.myNewRatingPeriodProxy = null;
                    try {
                        String ratingPlanName = newSettings.getParameterAsString("Ratingplan");
                        String serviceProviderName = newSettings.getParameterAsString("Service provider");
                        Element defaultXML = RatingPeriodProxy.createNewRatingPeriodXML(serviceProxy.instantiateServiceObject(), newSettings.getParameterAsString("Name"), ratingPlanName, serviceProviderName);
                        RatingManagerProxy managerProxy = planProxy.getRatingManagerProxy();
                        ServiceProviderListProxy serviceProviderListProxy = managerProxy.getServiceProviderListProxy();
                        ServiceProviderProxy serviceProviderProxt = serviceProviderListProxy.getServiceProvider(serviceProviderName);
                        RatingPlanProxy ratingPlanProxy = serviceProviderProxt.getRatingPlanProxy(ratingPlanName);
                        String name = newSettings.getParameterAsString("Name");
                        String startTime = newSettings.getParameterAsString("Start date");
                        RatingPeriodProxy ratingPeriodProxy = ratingPlanProxy.getRatingPeriodProxy(name, startTime);
                        if (ratingPeriodProxy != null) {
                            DefaultSaveAsRatingPeriodProxyEditor.this.myNewRatingPeriodProxy = ratingPeriodProxy;
                            DefaultSaveAsRatingPeriodProxyEditor.this.requiresOverwriting = true;
                        } else {
                            DefaultSaveAsRatingPeriodProxyEditor.this.myNewRatingPeriodProxy = ratingPlanProxy.createRatingPeriod(newSettings, defaultXML);
                            DefaultSaveAsRatingPeriodProxyEditor.this.requiresOverwriting = false;
                        }
                    }
                    catch (EreCommunicationException e) {
                        throw new PropertiesException("Could not create new rating period : " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new PropertiesException("Could not create new XML defintion for service : " + e.getMessage());
                    }
                }
            }

            @Override
            public boolean isSuccessful() {
                return DefaultSaveAsRatingPeriodProxyEditor.this.successfulEdit;
            }
        });
    }

    @Override
    public RatingPeriodProxy getCreatedProxy() {
        return this.myNewRatingPeriodProxy;
    }

    private void showErrorDialog(Variable var) {
        DialogFactory.getErrorDialog(GuiServiceCenter.getInstance().getMainWindow(), "Invalid input", "The entered " + var.getLabel().toLowerCase() + " is invalid.");
        this.successfulEdit = false;
    }

    @Override
    public boolean requiresOverwriting() {
        return this.requiresOverwriting;
    }
}

