/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.propertyeditor;

import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionManager;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.editors.interfaces.ProxySettingsEditorInterface;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.propertieseditor.EditablePropertiesInterface;
import ericsson.ere.gui.propertieseditor.PropertiesEditor;
import ericsson.ere.gui.propertieseditor.PropertiesException;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.integration.settingsmap.propertyio.VarTableInput;
import ericsson.ere.integration.settingsmap.propertyio.VarTableOutput;
import ericsson.vareditor.VarTableModel;
import java.util.Vector;

public class DefaultRatingPeriodProxySettingsEditor
implements ProxySettingsEditorInterface {
    @Override
    public void performEdit(AbstractEreProxy abstractProxy) {
        FunctionManager mgr = FunctionManagerImpl.getInstance();
        if (abstractProxy instanceof RatingPeriodProxy) {
            FunctionContext ctx;
            FunctionState state;
            final RatingPeriodProxy ratingPeriodProxy = (RatingPeriodProxy)abstractProxy;
            VarTableModel oldSettings = VarTableOutput.writeToVarTableModel(ratingPeriodProxy.getSettingsMap());
            String ratingPeriodName = ratingPeriodProxy.toString();
            if (ratingPeriodProxy.toString() == null) {
                ratingPeriodName = "new Rating Period";
            }
            if ((state = mgr.getStateForFunction(FunctionToken.CHANGE_RATING_PERIOD_PROPERTIES, ctx = FunctionContext.createFunctionCtxFromProxy(abstractProxy))).getState() == FunctionState.State.OFF) {
                PropertiesEditor.showNonEditableDialog(oldSettings, "Properties for '" + ratingPeriodName + " (Read-only)'");
            } else {
                PropertiesEditor.showDialogEdit(oldSettings, "Properties for '" + ratingPeriodName + "'", new EditablePropertiesInterface(){
                    private boolean updateSuccess = true;

                    @Override
                    public void cancel() {
                    }

                    @Override
                    public String getTitle() {
                        return null;
                    }

                    @Override
                    public void update(VarTableModel model) throws PropertiesException {
                        this.updateSuccess = true;
                        SettingsMap newSettings = VarTableInput.readFromVarTableModel(model);
                        if (!RatingPlanProxy.validateName(newSettings.getParameterAsString("Name"))) {
                            throw new PropertiesException("The rating period name contains invalid characters.\nCharacters \\ / : * ? ; \" are not valid.");
                        }
                        if (!model.getVariableForLabel("Start date").isValueValid()) {
                            throw new PropertiesException("The rating period start date is invalid.");
                        }
                        try {
                            RatingPlanProxy ratingPlanProxy = ratingPeriodProxy.getParentRatingPlanProxy();
                            Vector<RatingPeriodProxy> siblings = ratingPlanProxy.getRatingPeriodList();
                            if (ratingPeriodProxy.isStartTimeUsed() && siblings.size() > 1) {
                                String ratingPeriodStartTime = newSettings.getParameterAsString("Start date");
                                for (int i = 0; i < siblings.size(); ++i) {
                                    RatingPeriodProxy siblingProxy = siblings.get(i);
                                    if (siblingProxy.equals(ratingPeriodProxy) || !ratingPeriodStartTime.equals(siblingProxy.getRatingPeriodStartTime())) continue;
                                    DialogFactory.getErrorDialog(GuiServiceCenter.getInstance().getMainWindow(), "Rating period 'Start date' field value error", "The entered 'Start date' value already exists in an existing Rating Period.");
                                    this.updateSuccess = false;
                                    return;
                                }
                            }
                            if (newSettings.getParameterAsString("Name").trim().isEmpty()) {
                                DialogFactory.getErrorDialog(GuiServiceCenter.getInstance().getMainWindow(), "Rating period 'Name' field value error", "Empty value not allowed for field 'Name'");
                                this.updateSuccess = false;
                                return;
                            }
                            if (!RatingPlanProxy.validateName(newSettings.getParameterAsString("Name"))) {
                                throw new PropertiesException("The rating period name contains invalid characters.\nCharacters \\ / : * ? ; \" are not valid.");
                            }
                            ratingPeriodProxy.updateRatingPeriod(newSettings);
                        }
                        catch (Exception e) {
                            ExceptionUtil.handleException(e, "navigator", 2, "Failed to set new properties for the Service", true);
                        }
                    }

                    @Override
                    public boolean isSuccessful() {
                        return this.updateSuccess;
                    }
                });
            }
        }
    }
}

