/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.propertyeditor;

import com.ericsson.ere.gui.editors.interfaces.NavigatorNodePropertiesInterface;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.util.List;

public class DefaultNavigatorNodeProperties
extends VarTableModel
implements NavigatorNodePropertiesInterface {
    @Override
    public void update(VarTableModel model) {
        List<Variable> list = model.getData();
        for (Variable var : list) {
            this.addRow((Variable)var.clone());
        }
    }

    @Override
    public void insertRowAt(Variable variable, int index) {
        super.insertRowAt(variable, index);
    }

    @Override
    public void addRow(Variable variable) {
        if (VarListUtil.getVariableForName(this.getData(), variable.getLabel()) != null) {
            VarListUtil.getVariableForName(this.getData(), variable.getLabel()).setValue(variable.getValueString());
        } else {
            super.addRow(variable);
        }
    }

    @Override
    public List<Variable> getVariableList() {
        return this.getData();
    }

    @Override
    public VarTableModel getVarTableModel() {
        return this;
    }

    @Override
    public VarTableModel getCompleteRatingPeriodVarTableModel() {
        return this.getVarTableModel();
    }

    @Override
    public VarTableModel getCompleteServiceVarTableModel() {
        return this.getVarTableModel();
    }

    protected void set(String label, String value, boolean allowEdit) {
        Variable variable = VarListUtil.getVariableForName(this.getData(), label);
        if (variable == null) {
            variable = new StringVariable(label, value);
            variable.setAllowEdit(allowEdit);
            this.addRow(variable);
        } else {
            variable.setValue(value);
        }
    }

    private void setTime(String label, String value, boolean allowEdit) {
        Variable variable = VarListUtil.getVariableForName(this.getData(), label);
        if (variable == null) {
            variable = new DateAndTimeVariable(label, DateAndTimeVariable.Content.DATE_TIME, value);
            variable.setAllowEdit(allowEdit);
            this.addRow(variable);
        } else {
            variable.setValue(value);
        }
    }

    protected String get(String label) {
        Variable var = VarListUtil.getVariableForName(this.getData(), label);
        if (var != null) {
            return var.getValueString();
        }
        return null;
    }

    @Override
    public void setServiceProviderName(String serviceProviderName, boolean allowEdit) {
        this.set("Service provider", serviceProviderName, allowEdit);
    }

    @Override
    public String getServiceProviderName() {
        return this.get("Service provider");
    }

    @Override
    public String getRatingPeriodFileRef() {
        return this.get("Selection Tree file");
    }

    @Override
    public String getRatingPeriodName() {
        return this.get("Name");
    }

    @Override
    public String getRatingPeriodStartTime() {
        return this.get("Start date");
    }

    @Override
    public Object getRatingPeriodTime() {
        return VarListUtil.getTimeValueForName(this.getData(), "Start date");
    }

    @Override
    public String getRatingPlanName() {
        return this.get("Ratingplan");
    }

    @Override
    public String getServiceName() {
        return this.get("Service");
    }

    @Override
    public void setRatingPeriodFileRef(String fileRef, boolean allowEdit) {
        this.set("Selection Tree file", fileRef, allowEdit);
    }

    @Override
    public void setRatingPeriodName(String ratingPeriodName, boolean allowEdit) {
        this.set("Name", ratingPeriodName, allowEdit);
    }

    @Override
    public void setRatingPeriodStartTime(String startDate, boolean allowEdit) {
        this.setTime("Start date", startDate, allowEdit);
    }

    @Override
    public void setRatingPlanName(String ratingPlanName, boolean allowEdit) {
        this.set("Ratingplan", ratingPlanName, allowEdit);
    }

    @Override
    public void setServiceName(String serviceName, boolean allowEdit) {
        this.set("Service", serviceName, allowEdit);
    }

    @Override
    public void setConditionFileName(String conditionFileName, boolean allowEdit) {
        this.set("Service condition file", conditionFileName, allowEdit);
    }

    @Override
    public String getConditionFileName() {
        return this.get("Service condition file");
    }

    @Override
    public void setDefinitionFileName(String conditionFileName, boolean allowEdit) {
        this.set("Service definition file", conditionFileName, allowEdit);
    }

    @Override
    public String getDefinitionFileName() {
        return this.get("Service definition file");
    }
}

