/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.propertyeditor;

import com.ericsson.ere.gui.editors.interfaces.ProxySettingsEditorInterface;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.propertieseditor.EditablePropertiesInterface;
import ericsson.ere.gui.propertieseditor.PropertiesEditor;
import ericsson.ere.gui.propertieseditor.PropertiesException;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.integration.settingsmap.propertyio.VarTableInput;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.Variable;
import java.util.Collections;
import java.util.Vector;
import org.w3c.dom.Element;

public class DefaultNavigatorNodeEditor
implements ProxySettingsEditorInterface,
EditablePropertiesInterface {
    private boolean updateSuccess = true;
    String editorTitle = "Edit properties";
    AbstractEreProxy abstractProxy = null;

    public void performNew(AbstractEreProxy aProxy) {
        this.abstractProxy = aProxy;
        RatingManagerProxy ratingManagerProxy = this.abstractProxy.getRatingManagerProxy();
        ServiceListProxy serviceListProxy = ratingManagerProxy.getServiceListProxy();
        if (this.abstractProxy instanceof ServiceListProxy || this.abstractProxy instanceof ServiceProxy) {
            VarTableModel newSettings = new VarTableModel();
            newSettings.addRow(new StringVariable("Name"));
            PropertiesEditor.showDialogEdit(newSettings, "New Service", (EditablePropertiesInterface)this);
        } else {
            if (serviceListProxy.getServiceList() == null || serviceListProxy.getServiceList().isEmpty()) {
                DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "No Service in Service list", "There is no service defined in the Service list. \nPlease, add a Service before trying to add a Service Provider.");
                return;
            }
            Vector<String> serviceNameList = new Vector<String>();
            for (ServiceProxy serviceProxy : serviceListProxy.getServiceList()) {
                serviceNameList.add(serviceProxy.getName());
            }
            Collections.sort(serviceNameList);
            StringVariable serviceProviderVariable = new StringVariable("Service provider");
            BaseVariable serviceVariable = new DropDownVariable("Service", 0, serviceNameList.toArray());
            StringVariable ratingPlanVariable = new StringVariable("Ratingplan");
            StringVariable nameVariable = new StringVariable("Name");
            DateAndTimeVariable startDateVariable = new DateAndTimeVariable("Start date", DateAndTimeVariable.Content.DATE_TIME, "99990101T000000000");
            if (!(this.abstractProxy instanceof ServiceProviderListProxy)) {
                RatingPlanProxy ratingPlanProxy;
                if (this.abstractProxy instanceof ServiceProviderProxy) {
                    ServiceProviderProxy serviceProviderProxy = (ServiceProviderProxy)this.abstractProxy;
                    serviceProviderVariable.setValue(serviceProviderProxy.getName());
                    serviceProviderVariable.setAllowEdit(false);
                } else if (this.abstractProxy instanceof RatingPlanProxy) {
                    ratingPlanProxy = (RatingPlanProxy)this.abstractProxy;
                    serviceProviderVariable.setValue(ratingPlanProxy.getServiceProviderProxy().getName());
                    serviceProviderVariable.setAllowEdit(false);
                    serviceVariable = new StringVariable("Service", ratingPlanProxy.getServiceName());
                    ((Variable)serviceVariable).setAllowEdit(false);
                    ratingPlanVariable.setValue(ratingPlanProxy.getName());
                    ratingPlanVariable.setAllowEdit(false);
                } else if (this.abstractProxy instanceof RatingPeriodProxy) {
                    ratingPlanProxy = ((RatingPeriodProxy)this.abstractProxy).getParentRatingPlanProxy();
                    serviceProviderVariable.setValue(ratingPlanProxy.getServiceProviderProxy().getName());
                    serviceProviderVariable.setAllowEdit(false);
                    serviceVariable = new StringVariable("Service", ratingPlanProxy.getServiceName());
                    ((Variable)serviceVariable).setAllowEdit(false);
                    ratingPlanVariable.setValue(ratingPlanProxy.getName());
                    ratingPlanVariable.setAllowEdit(false);
                }
            }
            VarTableModel newSettings = new VarTableModel();
            newSettings.addRow(serviceProviderVariable);
            newSettings.addRow(serviceVariable);
            newSettings.addRow(ratingPlanVariable);
            newSettings.addRow(nameVariable);
            newSettings.addRow(startDateVariable);
            PropertiesEditor.showDialogEdit(newSettings, "New rating period", (EditablePropertiesInterface)this);
        }
    }

    public void performShow(AbstractEreProxy aProxy) {
        this.abstractProxy = aProxy;
        String abstractProxyTitle = "";
        if (this.abstractProxy.toString() != null) {
            abstractProxyTitle = this.abstractProxy.toString();
        }
        PropertiesEditor.showDialogEdit(this.abstractProxy.getSettingsMap(), "Properties for '" + abstractProxyTitle + "'", (EditablePropertiesInterface)this);
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getTitle() {
        return this.editorTitle;
    }

    @Override
    public void update(VarTableModel model) throws PropertiesException {
        SettingsMap newSettings = VarTableInput.readFromVarTableModel(model);
        RatingManagerProxy ratingManagerProxy = this.abstractProxy.getRatingManagerProxy();
        ServiceListProxy serviceListProxy = ratingManagerProxy.getServiceListProxy();
        ServiceProviderListProxy serviceProviderListProxy = ratingManagerProxy.getServiceProviderListProxy();
        ServiceProxy serviceProxy = serviceListProxy.getServiceProxy(newSettings.getParameterAsString("Service"));
        try {
            String ratingPlanName = newSettings.getParameterAsString("Ratingplan");
            String serviceProviderName = newSettings.getParameterAsString("Service provider");
            Element defaultXML = RatingPeriodProxy.createNewRatingPeriodXML(serviceProxy.instantiateServiceObject(), newSettings.getParameterAsString("Name"), ratingPlanName, serviceProviderName);
            if (this.abstractProxy instanceof RatingPeriodProxy) {
                RatingPlanProxy ratingPlanProxy = ((RatingPeriodProxy)this.abstractProxy).getParentRatingPlanProxy();
                ratingPlanProxy.createRatingPeriod(newSettings, defaultXML);
            } else if (this.abstractProxy instanceof RatingPlanProxy) {
                RatingPlanProxy ratingPlanProxy = (RatingPlanProxy)this.abstractProxy;
                ratingPlanProxy.createRatingPeriod(newSettings, defaultXML);
            } else if (this.abstractProxy instanceof ServiceProviderProxy) {
                ServiceProviderProxy serviceProviderProxy = (ServiceProviderProxy)this.abstractProxy;
                if (!serviceProviderProxy.ratingPlanExists(ratingPlanName)) {
                    SettingsMap ratingPlanSettings = new SettingsMap();
                    ratingPlanSettings.setParameter("Name", ratingPlanName);
                    ratingPlanSettings.setParameter("Service", newSettings.getParameterAsString("Service"));
                    serviceProviderProxy.createRatingPlan(ratingPlanSettings);
                }
                RatingPlanProxy ratingPlanProxy = serviceProviderProxy.getRatingPlanProxy(ratingPlanName);
                ratingPlanProxy.createRatingPeriod(newSettings, defaultXML);
            } else if (this.abstractProxy instanceof ServiceProviderListProxy) {
                ServiceProviderProxy serviceProviderProxy;
                if (!serviceProviderListProxy.serviceProviderExists(serviceProviderName)) {
                    SettingsMap serviceProviderSettings = new SettingsMap();
                    serviceProviderSettings.setParameter("Name", serviceProviderName);
                    serviceProviderListProxy.createServiceProvider(serviceProviderSettings);
                }
                if (!(serviceProviderProxy = serviceProviderListProxy.getServiceProvider(serviceProviderName)).ratingPlanExists(ratingPlanName)) {
                    SettingsMap ratingPlanSettings = new SettingsMap();
                    ratingPlanSettings.setParameter("Name", ratingPlanName);
                    ratingPlanSettings.setParameter("Service", newSettings.getParameterAsString("Service"));
                    serviceProviderProxy.createRatingPlan(ratingPlanSettings);
                }
                RatingPlanProxy ratingPlanProxy = serviceProviderProxy.getRatingPlanProxy(ratingPlanName);
                ratingPlanProxy.createRatingPeriod(newSettings, defaultXML);
            }
        }
        catch (EreCommunicationException e) {
            throw new PropertiesException("Could not create new rating period : " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new PropertiesException("Could not create new XML defintion for service : " + e.getMessage(), e);
        }
    }

    @Override
    public void performEdit(AbstractEreProxy abstractProxy) {
    }

    @Override
    public boolean isSuccessful() {
        return this.updateSuccess;
    }
}

