/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression.parser;

import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.expression.BinaryOperator;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Operators;
import com.ericsson.ere.expression.UnaryOperator;
import com.ericsson.ere.expression.Unit;
import com.ericsson.ere.expression.UnitOperand;
import com.ericsson.ere.expression.parser.ExpressionParserHandler;
import com.ericsson.ere.expression.parser.ExpressionParserOptions;
import com.ericsson.ere.expression.parser.JavaCharStream;
import com.ericsson.ere.expression.parser.ParseException;
import com.ericsson.ere.expression.parser.PrivExpressionParserConstants;
import com.ericsson.ere.expression.parser.PrivExpressionParserTokenManager;
import com.ericsson.ere.expression.parser.Token;
import com.ericsson.ere.expression.parser.TokenMgrError;
import ericsson.ere.datatype.DataType;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

final class PrivExpressionParser
implements PrivExpressionParserConstants {
    private ExpressionParserOptions myOptions;
    private ExpressionParserHandler myHandler;
    public PrivExpressionParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[14];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public Expression parse() throws ParseException {
        try {
            return this.begin_parse();
        }
        catch (TokenMgrError err) {
            throw (ParseException)new ParseException("Token error when parsing.").initCause(err);
        }
    }

    void configure(ExpressionParserOptions options, ExpressionParserHandler handler) {
        this.myOptions = options;
        this.myHandler = handler;
    }

    private DataType parseDataType(String s) throws ParseException {
        int i = s.charAt(0) - 65;
        DataType dt = DataType.lookup(i);
        if (dt == null) {
            throw new ParseException("Unknown data type code: " + s);
        }
        return dt;
    }

    private Operator lookupOperator(String operator) throws ParseException {
        return this.myHandler.lookupOperator(operator);
    }

    private Unit lookupUnit(String unit) throws ParseException {
        return this.myHandler.lookupUnit(unit);
    }

    private Function lookupFunction(String funcName) throws ParseException {
        return this.myHandler.lookupFunction(funcName);
    }

    private Operand createLiteralOperand(String value, DataType dt) throws ParseException {
        return this.myHandler.createLiteralOperand(value, dt);
    }

    private Operand createFieldOperand(String field, String index) throws ParseException {
        return this.myHandler.createFieldOperand(field, index);
    }

    private DataType getDefaultStringDataType() {
        return this.myOptions.getDefaultStringDataType();
    }

    private DataType getDefaultNumericDataType() {
        return this.myOptions.getDefaultNumericDataType();
    }

    private DataType getDefaultDateTimeDataType(String value) {
        if (this.isDateConstant(value)) {
            return DataType.DATE;
        }
        return this.myOptions.getDefaultDateTimeDataType();
    }

    private boolean isDateConstant(String value) {
        return EREDateUtil.isBoundaryDateDefaultLabel(value);
    }

    static String escapeString(String str) {
        return str.replace("\"", "\\\"");
    }

    static String escapeFieldName(String str) {
        return str.replace("@", "\\@");
    }

    static String escapeIndexSpec(String str) {
        return str.replace("]", "\\]");
    }

    static String unescapeString(String str) {
        return str.replace("\\\"", "\"");
    }

    static String unescapeFieldName(String str) {
        return str.replace("\\@", "@");
    }

    static String unescapeIndexSpec(String str) {
        return str.replace("\\]", "]");
    }

    public final Expression begin_parse() throws ParseException {
        ETokenList e = this.expression();
        this.jj_consume_token(0);
        return e.createExpression();
    }

    public final ETokenList expression() throws ParseException {
        ETokenList e = new ETokenList();
        ETokenList tmp = this.primary();
        e.add(tmp);
        while (this.jj_2_1(2)) {
            tmp = this.binary_operator();
            e.add(tmp);
            tmp = this.primary();
            e.add(tmp);
        }
        return e;
    }

    public final ETokenList primary() throws ParseException {
        ETokenList o1 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 19: {
                o1 = this.unary_operator();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        ETokenList o2 = this.operand();
        return ETokenList.create(o1, o2);
    }

    public final ETokenList binary_operator() throws ParseException {
        Operator o;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                o = Operators.ADD;
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                o = Operators.SUBTRACT;
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                o = Operators.MULTIPLY;
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                o = Operators.DIVIDE;
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                o = Operators.INT_DIVIDE;
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                o = Operators.MODULUS;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                o = Operators.POWER;
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                String name = this.getToken((int)0).image;
                name = name.substring(1, name.length() - 1);
                o = this.lookupOperator(name);
                if (o instanceof BinaryOperator) break;
                throw new ParseException("Non-binary operator used in binary context.");
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return ETokenList.create(o);
    }

    public final ETokenList unary_operator() throws ParseException {
        Operator o;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                o = Operators.NEGATE;
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                String name = this.getToken((int)0).image;
                name = name.substring(1, name.length() - 1);
                o = this.lookupOperator(name);
                if (o instanceof UnaryOperator) break;
                throw new ParseException("Non-unary operator used in unary context.");
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return ETokenList.create(o);
    }

    public final ETokenList operand() throws ParseException {
        ETokenList e;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 35: {
                e = this.literal();
                break;
            }
            case 36: {
                e = this.field();
                break;
            }
            case 26: {
                e = this.function();
                break;
            }
            case 20: {
                e = this.nested_expression();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return e;
    }

    public final ETokenList nested_expression() throws ParseException {
        this.jj_consume_token(20);
        ETokenList e = this.expression();
        this.jj_consume_token(21);
        return ETokenList.create(ExpressionToken.LEFT_PAREN, e, ExpressionToken.RIGHT_PAREN);
    }

    public final ETokenList function() throws ParseException {
        ETokenList list = new ETokenList();
        this.jj_consume_token(26);
        String func = this.getToken((int)0).image;
        func = func.substring(0, func.length() - 1);
        Function f = this.lookupFunction(func);
        list.add(f);
        list.add(ExpressionToken.LEFT_PAREN);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 19: 
                case 20: 
                case 26: 
                case 28: 
                case 29: 
                case 31: 
                case 33: 
                case 35: 
                case 36: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block6;
                }
            }
            ETokenList tmp = this.function_arg();
            list.add(tmp);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(24);
                tmp = this.function_arg();
                list.add(ExpressionToken.FUNCTION_ARG_SEPARATOR);
                list.add(tmp);
            }
            break;
        }
        this.jj_consume_token(21);
        list.add(ExpressionToken.RIGHT_PAREN);
        return list;
    }

    public final ETokenList function_arg() throws ParseException {
        ETokenList e = this.expression();
        return e;
    }

    public final ETokenList literal() throws ParseException {
        DataType dt;
        Unit u = null;
        String value = this.getToken((int)1).image;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                dt = this.getDefaultStringDataType();
                value = value.substring(1, value.length() - 1);
                value = PrivExpressionParser.unescapeString(value);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        dt = this.string_datatype();
                        break block0;
                    }
                }
                this.jj_la1[6] = this.jj_gen;
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                dt = this.getDefaultNumericDataType();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        dt = this.numeric_datatype();
                        break block0;
                    }
                }
                this.jj_la1[7] = this.jj_gen;
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                dt = this.getDefaultDateTimeDataType(value);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        dt = this.date_time_datatype(value);
                        break block0;
                    }
                }
                this.jj_la1[8] = this.jj_gen;
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                dt = DataType.AMOUNT;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        this.single_datatype(DataType.AMOUNT);
                        break block0;
                    }
                }
                this.jj_la1[9] = this.jj_gen;
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                dt = DataType.BOOLEAN;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        this.single_datatype(DataType.BOOLEAN);
                        break block0;
                    }
                }
                this.jj_la1[10] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                u = this.unit();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        Operand op = this.createLiteralOperand(value, dt);
        if (u != null) {
            op = UnitOperand.create(op, u);
        }
        return ETokenList.create(op);
    }

    public final ETokenList field() throws ParseException {
        String index = null;
        Token field = this.jj_consume_token(36);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                index = this.field_index_spec();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        String fname = field.image;
        fname = fname.substring(1, fname.length() - 1);
        fname = PrivExpressionParser.unescapeFieldName(fname);
        Operand op = this.createFieldOperand(fname, index);
        return ETokenList.create(op);
    }

    public final String field_index_spec() throws ParseException {
        this.jj_consume_token(37);
        String spec = this.getToken((int)0).image;
        spec = spec.substring(1, spec.length() - 1);
        spec = PrivExpressionParser.unescapeIndexSpec(spec);
        return spec;
    }

    public final Unit unit() throws ParseException {
        this.jj_consume_token(38);
        String unit = this.getToken((int)0).image;
        int begin = unit.indexOf(123) + 1;
        int end = unit.indexOf(125);
        unit = unit.substring(begin, end);
        Unit u = this.lookupUnit(unit);
        return u;
    }

    public final DataType single_datatype(DataType expected) throws ParseException {
        this.jj_consume_token(27);
        DataType dt = this.parseDataType(this.getToken((int)0).image);
        if (dt != expected) {
            throw new ParseException("Expected data type " + expected.getTypeName() + " but got " + dt.getTypeName() + ".");
        }
        return dt;
    }

    public final DataType date_time_datatype(String value) throws ParseException {
        this.jj_consume_token(27);
        DataType dt = this.parseDataType(this.getToken((int)0).image);
        if (dt != DataType.DATE && dt != DataType.TIME) {
            throw new ParseException("Expected date/time data type for date/time literal.");
        }
        return dt;
    }

    public final DataType string_datatype() throws ParseException {
        this.jj_consume_token(27);
        DataType dt = this.parseDataType(this.getToken((int)0).image);
        if (!dt.isStringType()) {
            throw new ParseException("Expected string data type for string literal.");
        }
        return dt;
    }

    public final DataType numeric_datatype() throws ParseException {
        this.jj_consume_token(27);
        DataType dt = this.parseDataType(this.getToken((int)0).image);
        if (!dt.isNumeric()) {
            throw new ParseException("Expected numeric data type for number literal.");
        }
        return dt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private boolean jj_3R_11() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_10() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_18()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_19()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_20()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_9() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_28() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_8() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_7() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_6() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_6()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_7()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_8()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_9()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_10()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_11()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_12()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_13()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_27() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_25() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_24() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_27()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_28()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_29()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_30()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_31()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_22() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3R_14() {
        return this.jj_3R_16();
    }

    private boolean jj_3R_21() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_14()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3R_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_21()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_22()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_26() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_31() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3_1() {
        if (this.jj_3R_4()) {
            return true;
        }
        return this.jj_3R_5();
    }

    private boolean jj_3R_30() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_20() {
        return this.jj_3R_26();
    }

    private boolean jj_3R_19() {
        return this.jj_3R_25();
    }

    private boolean jj_3R_18() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_17() {
        return this.jj_3R_23();
    }

    private boolean jj_3R_29() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_13() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3R_12() {
        return this.jj_scan_token(12);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{524416, 532416, 524416, -1274019840, -1273495424, 0x1000000, 0x8000000, 0x8000000, 0x8000000, 0x8000000, 0x8000000, -1342177280, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 26, 26, 0, 0, 0, 0, 0, 0, 10, 64, 32};
    }

    public PrivExpressionParser(InputStream stream) {
        this(stream, null);
    }

    public PrivExpressionParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new PrivExpressionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PrivExpressionParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new PrivExpressionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PrivExpressionParser(PrivExpressionParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(PrivExpressionParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[40];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 14; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 40; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        PrivExpressionParser.jj_la1_init_0();
        PrivExpressionParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    private static class ETokenList {
        List<ExpressionToken> myTokens = new ArrayList<ExpressionToken>();

        ETokenList() {
        }

        void add(Object t) {
            if (t instanceof ETokenList) {
                this.myTokens.addAll(((ETokenList)t).myTokens);
            } else if (t instanceof ExpressionToken) {
                this.myTokens.add((ExpressionToken)t);
            } else {
                throw new IllegalArgumentException("Unknown type: " + t);
            }
        }

        static ETokenList create(Object ... tokens) {
            ETokenList list = new ETokenList();
            for (Object t : tokens) {
                if (t == null) continue;
                list.add(t);
            }
            return list;
        }

        Expression createExpression() {
            return new Expression(this.myTokens, Expression.ExpressionNotation.INFIX);
        }
    }
}

