/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression.parser;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.expression.FieldValueOperand;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.ValueOperand;
import com.ericsson.ere.expression.parser.AbstractExpressionParserHandler;
import com.ericsson.ere.expression.parser.ParseException;
import com.ericsson.ere.selectiontree.modifiers.DataSetValueReader;
import com.ericsson.ere.selectiontree.modifiers.DefaultDataSetValueReader;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import java.util.Map;

@Immutable
public class DefaultExpressionParserHandler
extends AbstractExpressionParserHandler {
    protected final DataSetValueReader myDataSetValueReader;

    public DefaultExpressionParserHandler(ClassRepository repository, DataSetValueReader dataSetValueReader) {
        this(repository, dataSetValueReader, null);
    }

    public DefaultExpressionParserHandler(ClassRepository repository, DataSetValueReader dataSetValueReader, Map<String, Function> customFunctions) {
        super(repository, customFunctions);
        this.myDataSetValueReader = dataSetValueReader != null ? dataSetValueReader : DefaultDataSetValueReader.INSTANCE;
    }

    @Override
    public Operand createLiteralOperand(String value, DataType dt) throws ParseException {
        ValueResolver resolver = dt.createContextBasedValueResolver().finish();
        Object obj = resolver.parseValueString(value);
        return ValueOperand.createFor(obj);
    }

    @Override
    protected Operand createFieldOperand(FieldDefinition parentField, ValueFieldCompositeObject indexObject) {
        FieldIndexKeyContainer.KeyType keytype;
        FieldIndexKeyContainer key = null;
        FieldIndexKeyContainer.KeyType keyType = keytype = parentField.isArray() ? FieldIndexKeyContainer.KeyType.VALUE_LIST : FieldIndexKeyContainer.KeyType.VALUE_MAP;
        if (indexObject != null) {
            FieldDefinition[] keyFieldDefs = null;
            String[] keyFields = parentField.getKeyFields();
            if (keyFields.length > 0) {
                keyFieldDefs = new FieldDefinition[keyFields.length];
                for (int i = 0; i < keyFieldDefs.length; ++i) {
                    keyFieldDefs[i] = this.findFieldByName(keyFields[i]);
                }
            }
            key = new FieldIndexKeyContainer(indexObject, keytype, this.myRepository, keyFieldDefs);
        }
        DataSetField dsf = new DataSetField(parentField);
        return new FieldValueOperand(dsf, key, this.myDataSetValueReader);
    }
}

