/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.datatype.LazyEvaluatedValue;
import com.ericsson.ere.expression.EvaluationContext;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.math.RatingDecimalUtil;
import com.ericsson.ere.selectiontree.modifiers.mfo.DataSetEvaluationContext;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.OctetString;

@Immutable
public class ValueOperand<T>
implements Operand {
    private T myValue;

    protected ValueOperand(T value) {
        this.myValue = value;
    }

    public T getValue(EvaluationContext context) {
        T value = this.myValue;
        if (value instanceof LazyEvaluatedValue) {
            if (!(context instanceof DataSetEvaluationContext)) {
                throw new IllegalArgumentException("Wrong context type, data set is required to evaluate lazy-evaluated value.");
            }
            DataSet dataset = ((DataSetEvaluationContext)context).getDataSet();
            value = ((LazyEvaluatedValue)value).evaluate(dataset);
        }
        return value;
    }

    public String toString() {
        String str = this.myValue instanceof RatingDecimal ? RatingDecimalUtil.toString((RatingDecimal)this.myValue) : DataType.valueToString(this.myValue);
        if (this.isStringLike(this.myValue)) {
            str = "\"" + str + "\"";
        }
        return str;
    }

    public String toStringSingleQuotes() {
        String str = DataType.valueToString(this.myValue);
        if (this.isStringLike(this.myValue)) {
            str = "'" + str + "'";
        }
        return str;
    }

    private boolean isStringLike(T value) {
        return value instanceof String || value instanceof BcdString || value instanceof OctetString;
    }

    public static <T> ValueOperand<T> createFor(T value) {
        return new ValueOperand<T>(value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueOperand other = (ValueOperand)obj;
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }
}

