/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.annotations.IdentityBasedEquality;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.FunctionArgumentTypeException;
import com.ericsson.ere.expression.FunctionArgumentValueException;
import com.ericsson.ere.expression.FunctionParameterInfo;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.math.RatingDecimalUtil;
import ericsson.ere.datatype.DataType;

@IdentityBasedEquality
public class RoundFunction
extends Function {
    private static final String FUNC_DESC = "Rounds a number to a specified number of decimals.";
    private static final FunctionParameterInfo[] PARAMS = new FunctionParameterInfo[]{FunctionParameterInfo.mandatoryParameter("number", "number to be rounded", DataType.RATINGDECIMAL, false), FunctionParameterInfo.optionalParameter("precision", "non-negative, integer-sized number to use as number of decimals (defaults to 0)", DataType.INTEGER, 0, false), FunctionParameterInfo.optionalParameter("mode", "rounding mode (0=up, 1=down, 2=ceiling, 3=floor, 4=half up (default), 5=half down, 6=half even)", DataType.SHORT, (short)4, false)};
    public static final RoundFunction INSTANCE = new RoundFunction();

    protected RoundFunction() {
    }

    @Override
    protected Object perform(Object[] args) {
        RatingDecimal number = this.getNumberToRound(args);
        int precision = this.getPrecision(args);
        int mode = this.getRoundingMode(args);
        RatingDecimal rounded = number.round(precision, mode);
        return rounded;
    }

    protected int getDefaultPrecision() {
        return 0;
    }

    protected int getDefaultRoundingMode() {
        return 4;
    }

    private int convertPrecisionToInteger(Number precision) {
        long lprec = precision.longValue();
        if (lprec < 0L) {
            throw new FunctionArgumentValueException(this, 1, Long.toString(lprec), "precision cannot be negative");
        }
        if (lprec > Integer.MAX_VALUE) {
            throw new FunctionArgumentValueException(this, 1, Long.toString(lprec), "precision must fit in an integer");
        }
        return (int)lprec;
    }

    private int convertModeToInteger(Number mode) {
        long lmode = mode.longValue();
        if (lmode < 0L || lmode > 6L) {
            throw new FunctionArgumentValueException(this, 2, Long.toString(lmode), "mode must be within the range 0 to 6");
        }
        return (int)lmode;
    }

    private RatingDecimal getNumberToRound(Object[] args) {
        return this.getRatingDecimalArgument(args, 0);
    }

    protected int getPrecision(Object[] args) {
        if (args.length < 2) {
            return this.getDefaultPrecision();
        }
        Number prec = this.getNumericArgument(args, 1);
        return this.convertPrecisionToInteger(prec);
    }

    protected int getRoundingMode(Object[] args) {
        if (args.length < 3) {
            return this.getDefaultRoundingMode();
        }
        Number mode = this.getNumericArgument(args, 2);
        return this.convertModeToInteger(mode);
    }

    protected final Number getNumericArgument(Object[] args, int index) {
        Object arg = args[index];
        if (arg instanceof Number) {
            return (Number)arg;
        }
        return this.getRatingDecimalArgument(args, index);
    }

    protected final RatingDecimal getRatingDecimalArgument(Object[] args, int index) {
        try {
            RatingDecimal number = RatingDecimalUtil.createRatingDecimalFromNumericValue(args[index]);
            return number;
        }
        catch (NumberFormatException e) {
            throw new FunctionArgumentTypeException(this, index, "must be a number");
        }
    }

    @Override
    public String getFunctionDescription() {
        return FUNC_DESC;
    }

    @Override
    public String getFunctionName() {
        return "round";
    }

    @Override
    public FunctionParameterInfo[] getParameters() {
        return PARAMS;
    }

    @Override
    public DataType getReturnType() {
        return DataType.RATINGDECIMAL;
    }
}

