/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.BalanceOfFunction;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.RoundFunction;
import com.ericsson.ere.expression.TruncateFunction;
import java.util.HashMap;
import java.util.Map;

public final class Functions {
    public static final Function ROUND = RoundFunction.INSTANCE;
    public static final Function TRUNCATE = TruncateFunction.INSTANCE;
    public static final Function BALANCEOF = BalanceOfFunction.INSTANCE;
    private static Map<String, Function> myNamedFunctions = new HashMap<String, Function>();

    private Functions() {
    }

    public static String getFunctionName(Function function) {
        String name = null;
        for (Map.Entry<String, Function> entry : myNamedFunctions.entrySet()) {
            if (!function.equals(entry.getValue())) continue;
            name = entry.getKey();
            break;
        }
        return name;
    }

    public static Function getFunctionByName(String name) {
        return myNamedFunctions.get(name);
    }

    static {
        myNamedFunctions.put(ROUND.getFunctionName(), ROUND);
        myNamedFunctions.put(TRUNCATE.getFunctionName(), TRUNCATE);
        myNamedFunctions.put(BALANCEOF.getFunctionName(), BALANCEOF);
    }
}

