/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.expression.Function;

public class FunctionArgumentCountException
extends ExpressionException {
    public FunctionArgumentCountException(Function f, int actualCount, int minCount, int maxCount) {
        super(FunctionArgumentCountException.createMessage(f, actualCount, minCount, maxCount));
    }

    private static String createMessage(Function f, int actualCount, int min, int max) {
        String expectedString = max < 0 || min == max ? String.valueOf(min) : String.format("%d-%d", min, max);
        String msg = String.format("Wrong number of arguments for function %s, found %d but expected %s.", f.getFunctionName(), actualCount, expectedString);
        return msg;
    }
}

