/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.EvaluationContext;
import com.ericsson.ere.expression.FunctionArgBOF;
import com.ericsson.ere.expression.FunctionArgumentCountException;
import com.ericsson.ere.expression.FunctionParameterInfo;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.ValueOperand;
import ericsson.ere.datatype.DataType;
import java.util.LinkedList;
import java.util.Stack;
import java.util.regex.Pattern;

public abstract class Function
implements Operator {
    public static final Pattern FUNCTION_NAME_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*");

    protected Function() {
        this.validateFunctionName();
    }

    private void validateFunctionName() {
        String name = this.getFunctionName();
        if (name == null || !FUNCTION_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid function name: " + name);
        }
    }

    @Override
    public void perform(Stack<Operand> operandStack, EvaluationContext context) {
        Operand o;
        LinkedList<Operand> operands = new LinkedList<Operand>();
        while (!this.isFunctionArgBOF(o = operandStack.pop())) {
            operands.add(0, o);
        }
        int argCount = operands.size();
        this.checkArgumentCount(argCount);
        Object[] argarr = new Object[argCount];
        int idx = 0;
        for (Operand oper : operands) {
            argarr[idx++] = oper.getValue(context);
        }
        Object result = this.perform(argarr);
        Operand resultOperand = this.createResultOperand(result);
        operandStack.push(resultOperand);
    }

    private void checkArgumentCount(int foundCount) {
        int[] argCount = this.calculateArgumentCount();
        int min = argCount[0];
        int max = argCount[1];
        if (foundCount < min || max >= 0 && foundCount > max) {
            throw new FunctionArgumentCountException(this, foundCount, min, max);
        }
    }

    private boolean isFunctionArgBOF(Operand o) {
        return o instanceof FunctionArgBOF;
    }

    protected Operand createResultOperand(Object result) {
        return ValueOperand.createFor(result);
    }

    protected abstract Object perform(Object[] var1);

    public abstract FunctionParameterInfo[] getParameters();

    public abstract String getFunctionName();

    public abstract String getFunctionDescription();

    public abstract DataType getReturnType();

    private int[] calculateArgumentCount() {
        int min;
        FunctionParameterInfo[] params = this.getParameters();
        int max = -1;
        if (params.length > 0) {
            for (min = 0; min < params.length && params[min].isMandatory(); ++min) {
            }
            if (!params[params.length - 1].isVarArg()) {
                max = params.length;
            }
        }
        return new int[]{min, max};
    }

    public String getSignature() {
        FunctionParameterInfo[] params = this.getParameters();
        StringBuilder b = new StringBuilder();
        b.append(this.getFunctionName());
        b.append("(");
        for (int i = 0; i < params.length; ++i) {
            boolean optional;
            if (i > 0) {
                b.append(", ");
            }
            boolean bl = optional = !params[i].isMandatory();
            if (optional) {
                b.append("[");
            }
            b.append(params[i].getName());
            if (params[i].isVarArg() && i == params.length - 1) {
                b.append("...");
            }
            if (!optional) continue;
            b.append("]");
        }
        b.append(")");
        return b.toString();
    }

    public String toString() {
        return this.getFunctionName();
    }
}

