/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.calendar.CalendarDate;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.expression.EvaluationContext;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.math.RatingDecimalUtil;
import ericsson.ere.datatype.Time;
import java.math.MathContext;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public abstract class FormatStringOperand
implements Operand {
    private final Operand myInnerOperand;

    protected FormatStringOperand(Operand inner) {
        this.myInnerOperand = inner;
    }

    @Override
    public Object getValue(EvaluationContext context) {
        return this.format(this.myInnerOperand.getValue(context));
    }

    protected abstract String format(Object var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myInnerOperand == null ? 0 : this.myInnerOperand.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FormatStringOperand other = (FormatStringOperand)obj;
        return !(this.myInnerOperand == null ? other.myInnerOperand != null : !this.myInnerOperand.equals(other.myInnerOperand));
    }

    public static FormatStringOperand create(Operand inner, String formatString) {
        return FormatStringOperand.create(inner, formatString, null);
    }

    public static FormatStringOperand create(Operand inner, String formatString, String localeString) {
        FormatStringOperand operand;
        Locale locale = FormatStringOperand.parseLocale(localeString);
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(formatString, locale);
            operand = new DateTimeFormatOperand(inner, fmt);
        }
        catch (IllegalArgumentException e) {
            operand = new StringFormatOperand(inner, formatString, locale);
        }
        return operand;
    }

    private static Locale parseLocale(String localeString) {
        if (localeString == null) {
            return Locale.US;
        }
        String[] args = new String[]{"", "", ""};
        String[] parts = localeString.split("_");
        if (parts.length < 1 || parts.length > 3 || "".equals(parts[0])) {
            throw new IllegalArgumentException("Locale string has an incorrect format (expected 1-3 parts separated by underscores): " + localeString);
        }
        System.arraycopy(parts, 0, args, 0, parts.length);
        return new Locale(args[0], args[1], args[2]);
    }

    private static class StringFormatOperand
    extends FormatStringOperand {
        private final String myFormatString;
        private final Locale myLocale;

        private StringFormatOperand(Operand inner, String formatString, Locale locale) {
            super(inner);
            this.myFormatString = formatString;
            this.myLocale = locale;
        }

        @Override
        protected String format(Object value) {
            Object o = this.toFormattable(value);
            return String.format(this.myLocale, this.myFormatString, o);
        }

        private Object toFormattable(Object value) {
            Object ret = value;
            if (value instanceof RatingDecimal) {
                RatingDecimal rd = (RatingDecimal)value;
                ret = rd.isWholeNumber() ? (RatingDecimalUtil.isWithinLongRange(rd) ? Long.valueOf(rd.longValue()) : RatingDecimalUtil.toBigInteger(rd)) : rd.bigDecimalValue(MathContext.DECIMAL128);
            }
            return ret;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.myFormatString == null ? 0 : this.myFormatString.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringFormatOperand other = (StringFormatOperand)obj;
            return !(this.myFormatString == null ? other.myFormatString != null : !this.myFormatString.equals(other.myFormatString));
        }
    }

    private static class DateTimeFormatOperand
    extends FormatStringOperand {
        private final SimpleDateFormat myFormatter;

        private DateTimeFormatOperand(Operand inner, SimpleDateFormat formatter) {
            super(inner);
            this.myFormatter = formatter;
        }

        @Override
        protected String format(Object value) {
            Date date = this.toDate(value);
            return this.myFormatter.format(date);
        }

        private Date toDate(Object value) {
            Date d;
            if (value instanceof Date) {
                d = (Date)value;
            } else if (value instanceof EREDate) {
                d = ((EREDate)value).asDate();
            } else if (value instanceof CalendarDate) {
                CalendarDate cd = (CalendarDate)value;
                GregorianCalendar c = new GregorianCalendar(cd.getYear(), cd.getMonth() - 1, cd.getDayOfMonth());
                d = c.getTime();
            } else if (value instanceof Time) {
                d = ((Time)value).getCalendar().getTime();
            } else if (value instanceof Calendar) {
                d = ((Calendar)value).getTime();
            } else {
                throw new IllegalArgumentException("Unknown date/time object: " + value.getClass().getName());
            }
            return d;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.myFormatter == null ? 0 : this.myFormatter.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DateTimeFormatOperand other = (DateTimeFormatOperand)obj;
            return !(this.myFormatter == null ? other.myFormatter != null : !this.myFormatter.equals(other.myFormatter));
        }
    }
}

