/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.ExpressionToken;

public class ExpressionException
extends RuntimeException {
    private static final ExpressionToken[] EMPTY_ARRAY = new ExpressionToken[0];
    private ExpressionToken[] myTokens;
    private int myIndex;

    public ExpressionException(String message) {
        super(message);
    }

    public ExpressionException(String message, ExpressionToken ... tokens) {
        super(message);
        this.myTokens = this.copyOf(tokens);
        this.myIndex = -1;
    }

    public ExpressionException(String message, int index, ExpressionToken ... tokens) {
        super(message);
        this.myTokens = this.copyOf(tokens);
        this.myIndex = index;
    }

    private ExpressionToken[] copyOf(ExpressionToken[] tokens) {
        ExpressionToken[] arr = new ExpressionToken[tokens.length];
        System.arraycopy(tokens, 0, arr, 0, arr.length);
        return arr;
    }

    public int getFaultyTokenIndex() {
        return this.myIndex;
    }

    public ExpressionToken[] getTokens() {
        return this.myTokens == null ? EMPTY_ARRAY : this.copyOf(this.myTokens);
    }
}

