/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.expression.GenericBinaryOperator;
import com.ericsson.ere.expression.Unit;
import com.ericsson.ere.expression.UnitValue;
import com.ericsson.ere.math.RatingDecimal;
import java.util.Date;

public enum BinaryDateOperator {
    ADD{

        @Override
        Object perform(Object left, Object right) {
            boolean leftIsDate = 1.isDateOrTime(left);
            Object date = leftIsDate ? left : right;
            Object other = leftIsDate ? right : left;
            String otherLocation = leftIsDate ? "right" : "left";
            DateUnit[] unit = new DateUnit[1];
            Integer[] value = new Integer[1];
            BinaryDateOperator.extractUnitAndValue(other, unit, value, otherLocation);
            Object ret = value[0] == 0 ? date : this.addToDate(date, value[0], unit[0]);
            return ret;
        }
    }
    ,
    SUBTRACT{

        @Override
        Object perform(Object left, Object right) {
            Object ret;
            boolean bothAreDates;
            boolean leftIsDate = 2.isDateOrTime(left);
            boolean bl = bothAreDates = leftIsDate && 2.isDateOrTime(right);
            if (bothAreDates) {
                int days = this.getDateDifferenceInDays(left, right);
                ret = days;
            } else if (leftIsDate) {
                DateUnit[] unit = new DateUnit[1];
                Integer[] value = new Integer[1];
                BinaryDateOperator.extractUnitAndValue(right, unit, value, "right");
                ret = value[0] == 0 ? left : this.addToDate(left, -value[0].intValue(), unit[0]);
            } else {
                throw new IllegalArgumentException("Date subtraction requires the left or both operands to be dates.");
            }
            return ret;
        }
    };


    abstract Object perform(Object var1, Object var2);

    private static DateUnit getDateUnit(UnitValue<?, ?> uv) {
        Object u = uv.getUnit();
        if (!(u instanceof DateUnit)) {
            throw new IllegalArgumentException("Unit not a DateUnit: " + u.getClass().getName());
        }
        return (DateUnit)u;
    }

    private static void extractUnitAndValue(Object valueObject, DateUnit[] refUnit, Integer[] refValue, String operandLocation) {
        Object obj = valueObject;
        refUnit[0] = DateUnit.DAYS;
        if (obj instanceof UnitValue) {
            UnitValue uv = (UnitValue)obj;
            obj = uv.getValue();
            refUnit[0] = BinaryDateOperator.getDateUnit(uv);
        }
        RatingDecimal num = GenericBinaryOperator.convertToRatingDecimal(obj, operandLocation);
        refValue[0] = num.intValue();
    }

    static boolean isDateOrTime(Object value) {
        return value instanceof EREDate || value instanceof Date;
    }

    static boolean canHandle(Object left, Object right) {
        return BinaryDateOperator.isDateOrTime(left) || BinaryDateOperator.isDateOrTime(right);
    }

    protected EREDate addToDate(Object dateObject, int value, DateUnit unit) {
        EREDate date = EREDateUtil.convertToEREDate(dateObject);
        return unit.execute(date, value);
    }

    protected int getDateDifferenceInDays(Object date1, Object date2) {
        EREDate minuend = EREDateUtil.convertToEREDate(date1);
        EREDate subtrahend = EREDateUtil.convertToEREDate(date2);
        return subtrahend.daysUntil(minuend);
    }

    public static enum DateUnit implements Unit
    {
        DAYS{

            @Override
            public EREDate execute(EREDate t, int t2) {
                return t.plusDays(t2);
            }
        }
        ,
        MONTHS{

            @Override
            public EREDate execute(EREDate t, int t2) {
                return t.plusMonths(t2);
            }
        }
        ,
        YEARS{

            @Override
            public EREDate execute(EREDate t, int t2) {
                return t.plusYears(t2);
            }
        };


        public abstract EREDate execute(EREDate var1, int var2);
    }
}

