/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.AbstractExpressionChecker;
import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.OperationRestriction;
import com.ericsson.ere.expression.Operator;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public abstract class AbstractOperationRestriction
implements OperationRestriction {
    @Override
    public final void enforce(Operator operator, Stack<Operand> operands) throws ExpressionException {
        int opcount = this.getOperandCountRequiredForOperator(operator);
        if (opcount > 0) {
            List<Operand> oplist = AbstractExpressionChecker.popOperandsToList(operands, opcount);
            this.enforce(operator, Collections.unmodifiableList(oplist));
            for (int i = oplist.size() - 1; i >= 0; --i) {
                operands.push(oplist.get(i));
            }
        }
    }

    protected abstract void enforce(Operator var1, List<Operand> var2) throws ExpressionException;

    protected abstract int getOperandCountRequiredForOperator(Operator var1);
}

