/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.executor;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.executor.DefaultTreeExecutor;
import com.ericsson.ere.executor.TimeSwitchTreeExecutor;
import com.ericsson.ere.executor.TreeExecutor;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.selectiontree.interfaces.MillisecondDurationSupport;

public class MillisecondTimeSwitchTreeExecutor
extends TimeSwitchTreeExecutor {
    private static final int MILLISECONDS_PER_SECOND = 1000;

    public MillisecondTimeSwitchTreeExecutor() {
        this(new DefaultTreeExecutor());
    }

    public MillisecondTimeSwitchTreeExecutor(TreeExecutor executor) {
        super(executor);
    }

    @Override
    protected long getSatisfiedDurationForCondition(Conditionality condition, DataSet dataset) {
        long satisfiedDuration;
        long duration = condition instanceof MillisecondDurationSupport ? ((MillisecondDurationSupport)((Object)condition)).getConditionSatisfiedDurationInMilliseconds(dataset) : ((satisfiedDuration = super.getSatisfiedDurationForCondition(condition, dataset)) == Long.MAX_VALUE ? satisfiedDuration : satisfiedDuration * 1000L);
        return duration;
    }

    @Override
    protected long getUnsatisfiedDurationForCondition(Conditionality condition, DataSet dataset) {
        long unsatisfiedDuration;
        long duration = condition instanceof MillisecondDurationSupport ? ((MillisecondDurationSupport)((Object)condition)).getConditionUnsatisfiedDurationInMilliseconds(dataset) : ((unsatisfiedDuration = super.getUnsatisfiedDurationForCondition(condition, dataset)) == Long.MAX_VALUE ? unsatisfiedDuration : unsatisfiedDuration * 1000L);
        return duration;
    }
}

